/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.verifier.resolver;

import com.facebook.presto.common.type.ArrayType;
import com.facebook.presto.common.type.DoubleType;
import com.facebook.presto.common.type.MapType;
import com.facebook.presto.common.type.RealType;
import com.facebook.presto.common.type.RowType;
import com.facebook.presto.common.type.Type;
import com.facebook.presto.verifier.checksum.ArrayColumnChecksum;
import com.facebook.presto.verifier.checksum.ColumnMatchResult;
import com.facebook.presto.verifier.checksum.MapColumnChecksum;
import com.facebook.presto.verifier.checksum.StructureColumnChecksum;
import com.facebook.presto.verifier.framework.DataMatchResult;
import com.facebook.presto.verifier.framework.QueryBundle;
import com.facebook.presto.verifier.resolver.FailureResolver;
import com.google.common.base.Preconditions;
import java.util.Objects;
import java.util.Optional;

public class StructuredColumnMismatchResolver
implements FailureResolver {
    public static final String NAME = "structured-column";

    @Override
    public Optional<String> resolveResultMismatch(DataMatchResult matchResult, QueryBundle control) {
        Preconditions.checkArgument((!matchResult.isMatched() ? 1 : 0) != 0, (Object)"Expect not matched");
        if (matchResult.getMatchType() != DataMatchResult.MatchType.COLUMN_MISMATCH) {
            return Optional.empty();
        }
        for (ColumnMatchResult<?> mismatchedColumn : matchResult.getMismatchedColumns()) {
            StructureColumnChecksum testChecksum;
            StructureColumnChecksum controlChecksum;
            Type columnType = mismatchedColumn.getColumn().getType();
            if (columnType instanceof ArrayType) {
                controlChecksum = (ArrayColumnChecksum)mismatchedColumn.getControlChecksum();
                testChecksum = (ArrayColumnChecksum)mismatchedColumn.getTestChecksum();
                if (Objects.isNull(((ArrayColumnChecksum)controlChecksum).getChecksum())) {
                    return Optional.empty();
                }
                if (StructuredColumnMismatchResolver.containsFloatingPointType(((ArrayType)columnType).getElementType()) && StructuredColumnMismatchResolver.isCardinalityMatched(controlChecksum, testChecksum)) continue;
                return Optional.empty();
            }
            if (columnType instanceof MapType) {
                controlChecksum = (MapColumnChecksum)mismatchedColumn.getControlChecksum();
                if (!StructuredColumnMismatchResolver.isCardinalityMatched(controlChecksum, testChecksum = (MapColumnChecksum)mismatchedColumn.getTestChecksum())) {
                    return Optional.empty();
                }
                boolean keyContainsFloatingPoint = StructuredColumnMismatchResolver.containsFloatingPointType(((MapType)columnType).getKeyType());
                boolean valueContainsFloatingPoint = StructuredColumnMismatchResolver.containsFloatingPointType(((MapType)columnType).getValueType());
                if (!keyContainsFloatingPoint && !valueContainsFloatingPoint) {
                    return Optional.empty();
                }
                if (!keyContainsFloatingPoint && !Objects.equals(((MapColumnChecksum)controlChecksum).getKeysChecksum(), ((MapColumnChecksum)testChecksum).getKeysChecksum())) {
                    return Optional.empty();
                }
                if (valueContainsFloatingPoint) continue;
                if (!Objects.equals(((MapColumnChecksum)controlChecksum).getValuesChecksum(), ((MapColumnChecksum)testChecksum).getValuesChecksum())) {
                    return Optional.empty();
                }
                if (!Objects.isNull(((MapColumnChecksum)controlChecksum).getValuesChecksum()) || Objects.equals(((MapColumnChecksum)controlChecksum).getChecksum(), ((MapColumnChecksum)testChecksum).getChecksum())) continue;
                return Optional.empty();
            }
            return Optional.empty();
        }
        return Optional.of("Structured columns auto-resolved");
    }

    private static boolean containsFloatingPointType(Type type) {
        if (type instanceof DoubleType || type instanceof RealType) {
            return true;
        }
        if (type instanceof ArrayType) {
            return StructuredColumnMismatchResolver.containsFloatingPointType(((ArrayType)type).getElementType());
        }
        if (type instanceof MapType) {
            return StructuredColumnMismatchResolver.containsFloatingPointType(((MapType)type).getKeyType()) || StructuredColumnMismatchResolver.containsFloatingPointType(((MapType)type).getValueType());
        }
        if (type instanceof RowType) {
            for (RowType.Field field : ((RowType)type).getFields()) {
                if (!StructuredColumnMismatchResolver.containsFloatingPointType(field.getType())) continue;
                return true;
            }
            return false;
        }
        return false;
    }

    private static <T extends StructureColumnChecksum> boolean isCardinalityMatched(T controlChecksum, T testChecksum) {
        return Objects.equals(controlChecksum.getCardinalityChecksum(), testChecksum.getCardinalityChecksum()) && Objects.equals(controlChecksum.getCardinalitySum(), testChecksum.getCardinalitySum());
    }
}

