/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.verifier.resolver;

import com.facebook.presto.spi.ErrorCodeSupplier;
import com.facebook.presto.verifier.framework.PrestoQueryException;
import com.facebook.presto.verifier.framework.QueryException;
import com.facebook.presto.verifier.framework.QueryStage;
import java.util.Optional;
import java.util.Set;
import java.util.function.Function;

public class FailureResolverUtil {
    private FailureResolverUtil() {
    }

    public static <T> Optional<T> mapMatchingPrestoException(QueryException queryException, QueryStage queryStage, Set<ErrorCodeSupplier> errorCodeSuppliers, Function<PrestoQueryException, Optional<T>> mapper) {
        if (queryException.getQueryStage() != queryStage || !(queryException instanceof PrestoQueryException)) {
            return Optional.empty();
        }
        PrestoQueryException prestoException = (PrestoQueryException)queryException;
        if (!prestoException.getErrorCode().isPresent()) {
            return Optional.empty();
        }
        int code = prestoException.getErrorCode().get().toErrorCode().getCode();
        for (ErrorCodeSupplier supplier : errorCodeSuppliers) {
            if (supplier.toErrorCode().getCode() != code) continue;
            return mapper.apply(prestoException);
        }
        return Optional.empty();
    }
}

