/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.verifier.resolver;

import com.facebook.presto.jdbc.QueryStats;
import com.facebook.presto.spi.ErrorCodeSupplier;
import com.facebook.presto.spi.StandardErrorCode;
import com.facebook.presto.verifier.framework.QueryException;
import com.facebook.presto.verifier.framework.QueryObjectBundle;
import com.facebook.presto.verifier.framework.QueryStage;
import com.facebook.presto.verifier.resolver.FailureResolver;
import com.facebook.presto.verifier.resolver.FailureResolverUtil;
import com.google.common.collect.ImmutableSet;
import java.util.Optional;
import java.util.Set;

public class ExceededGlobalMemoryLimitFailureResolver
implements FailureResolver {
    public static final String NAME = "exceeded-global-memory-limit";

    @Override
    public Optional<String> resolveQueryFailure(QueryStats controlQueryStats, QueryException queryException, Optional<QueryObjectBundle> test) {
        return FailureResolverUtil.mapMatchingPrestoException(queryException, QueryStage.TEST_MAIN, (Set<ErrorCodeSupplier>)ImmutableSet.of((Object)StandardErrorCode.EXCEEDED_GLOBAL_MEMORY_LIMIT), e -> e.getQueryActionStats().getQueryStats().isPresent() && controlQueryStats.getPeakTotalMemoryBytes() > e.getQueryActionStats().getQueryStats().get().getPeakTotalMemoryBytes() ? Optional.of("Control query uses more memory than the test cluster memory limit") : Optional.empty());
    }
}

