/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.verifier.prestoaction;

import com.facebook.presto.connector.thrift.ThriftErrorCode;
import com.facebook.presto.hive.HiveErrorCode;
import com.facebook.presto.plugin.jdbc.JdbcErrorCode;
import com.facebook.presto.spark.SparkErrorCode;
import com.facebook.presto.spi.ErrorCodeSupplier;
import com.facebook.presto.spi.StandardErrorCode;
import com.facebook.presto.verifier.framework.ClusterConnectionException;
import com.facebook.presto.verifier.framework.PrestoQueryException;
import com.facebook.presto.verifier.framework.QueryException;
import com.facebook.presto.verifier.framework.QueryStage;
import com.facebook.presto.verifier.framework.ThrottlingException;
import com.facebook.presto.verifier.prestoaction.QueryActionStats;
import com.facebook.presto.verifier.prestoaction.SqlExceptionClassifier;
import com.google.common.base.Functions;
import com.google.common.base.MoreObjects;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import java.io.EOFException;
import java.io.UncheckedIOException;
import java.net.SocketException;
import java.net.SocketTimeoutException;
import java.sql.SQLException;
import java.util.Arrays;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.TimeoutException;
import java.util.function.Function;
import java.util.regex.Pattern;

public class PrestoExceptionClassifier
implements SqlExceptionClassifier {
    private static final Pattern TABLE_ALREADY_EXISTS_PATTERN = Pattern.compile("table.*already exists", 2);
    private final Map<Integer, ErrorCodeSupplier> errorByCode;
    private final Set<ErrorCodeSupplier> retryableErrors;
    private final Set<ErrorMatcher> conditionalRetryableErrors;
    private final Set<ErrorCodeSupplier> resubmittedErrors;
    private final Set<ErrorMatcher> conditionalResubmittedErrors;

    private PrestoExceptionClassifier(Set<ErrorCodeSupplier> recognizedErrors, Set<ErrorCodeSupplier> retryableErrors, Set<ErrorMatcher> conditionalRetryableErrors, Set<ErrorCodeSupplier> resubmittedErrors, Set<ErrorMatcher> conditionalResubmittedErrors) {
        this.errorByCode = (Map)recognizedErrors.stream().collect(ImmutableMap.toImmutableMap(errorCode -> errorCode.toErrorCode().getCode(), (Function)Functions.identity()));
        this.retryableErrors = ImmutableSet.copyOf(retryableErrors);
        this.conditionalRetryableErrors = ImmutableSet.copyOf(conditionalRetryableErrors);
        this.resubmittedErrors = ImmutableSet.copyOf(resubmittedErrors);
        this.conditionalResubmittedErrors = ImmutableSet.copyOf(conditionalResubmittedErrors);
    }

    public static Builder defaultBuilder() {
        return new Builder().addRecognizedErrors(Arrays.asList(StandardErrorCode.values())).addRecognizedErrors(Arrays.asList(HiveErrorCode.values())).addRecognizedErrors(Arrays.asList(JdbcErrorCode.values())).addRecognizedErrors(Arrays.asList(ThriftErrorCode.values())).addRecognizedErrors(Arrays.asList(SparkErrorCode.values())).addRetryableError((ErrorCodeSupplier)StandardErrorCode.NO_NODES_AVAILABLE).addRetryableError((ErrorCodeSupplier)StandardErrorCode.REMOTE_TASK_ERROR).addRetryableError((ErrorCodeSupplier)StandardErrorCode.REMOTE_TASK_MISMATCH).addRetryableError((ErrorCodeSupplier)StandardErrorCode.SERVER_SHUTTING_DOWN).addRetryableError((ErrorCodeSupplier)StandardErrorCode.SERVER_STARTING_UP).addRetryableError((ErrorCodeSupplier)StandardErrorCode.TOO_MANY_REQUESTS_FAILED).addRetryableError((ErrorCodeSupplier)StandardErrorCode.PAGE_TRANSPORT_ERROR).addRetryableError((ErrorCodeSupplier)StandardErrorCode.PAGE_TRANSPORT_TIMEOUT).addRetryableError((ErrorCodeSupplier)StandardErrorCode.REMOTE_HOST_GONE).addRetryableError((ErrorCodeSupplier)StandardErrorCode.ABANDONED_TASK).addRetryableError((ErrorCodeSupplier)StandardErrorCode.ABANDONED_QUERY).addRetryableError((ErrorCodeSupplier)HiveErrorCode.HIVE_CURSOR_ERROR).addRetryableError((ErrorCodeSupplier)HiveErrorCode.HIVE_FILE_NOT_FOUND).addRetryableError((ErrorCodeSupplier)HiveErrorCode.HIVE_TOO_MANY_OPEN_PARTITIONS).addRetryableError((ErrorCodeSupplier)HiveErrorCode.HIVE_WRITER_OPEN_ERROR).addRetryableError((ErrorCodeSupplier)HiveErrorCode.HIVE_WRITER_CLOSE_ERROR).addRetryableError((ErrorCodeSupplier)HiveErrorCode.HIVE_WRITER_DATA_ERROR).addRetryableError((ErrorCodeSupplier)HiveErrorCode.HIVE_FILESYSTEM_ERROR).addRetryableError((ErrorCodeSupplier)HiveErrorCode.HIVE_CANNOT_OPEN_SPLIT).addRetryableError((ErrorCodeSupplier)HiveErrorCode.HIVE_METASTORE_ERROR).addRetryableError((ErrorCodeSupplier)JdbcErrorCode.JDBC_ERROR).addRetryableError((ErrorCodeSupplier)ThriftErrorCode.THRIFT_SERVICE_CONNECTION_ERROR).addRetryableError((ErrorCodeSupplier)ThriftErrorCode.THRIFT_SERVICE_GENERIC_REMOTE_ERROR).addRetryableError((ErrorCodeSupplier)StandardErrorCode.EXCEEDED_TIME_LIMIT, Optional.of(QueryStage.DESCRIBE), Optional.empty()).addResubmittedError((ErrorCodeSupplier)HiveErrorCode.HIVE_PARTITION_DROPPED_DURING_QUERY).addResubmittedError((ErrorCodeSupplier)HiveErrorCode.HIVE_TABLE_DROPPED_DURING_QUERY).addResubmittedError((ErrorCodeSupplier)StandardErrorCode.CLUSTER_OUT_OF_MEMORY).addResubmittedError((ErrorCodeSupplier)StandardErrorCode.ADMINISTRATIVELY_PREEMPTED).addResubmittedError((ErrorCodeSupplier)HiveErrorCode.HIVE_TABLE_READ_ONLY).addResubmittedError((ErrorCodeSupplier)HiveErrorCode.HIVE_PARTITION_READ_ONLY).addResubmittedError((ErrorCodeSupplier)HiveErrorCode.HIVE_PARTITION_OFFLINE).addResubmittedError((ErrorCodeSupplier)StandardErrorCode.SYNTAX_ERROR, Optional.of(QueryStage.CONTROL_SETUP), Optional.of(TABLE_ALREADY_EXISTS_PATTERN)).addResubmittedError((ErrorCodeSupplier)StandardErrorCode.SYNTAX_ERROR, Optional.of(QueryStage.TEST_SETUP), Optional.of(TABLE_ALREADY_EXISTS_PATTERN));
    }

    @Override
    public QueryException createException(QueryStage queryStage, QueryActionStats queryActionStats, SQLException cause) {
        Optional<Throwable> clusterConnectionExceptionCause = PrestoExceptionClassifier.getClusterConnectionExceptionCause(cause);
        if (clusterConnectionExceptionCause.isPresent()) {
            return new ClusterConnectionException(clusterConnectionExceptionCause.get(), queryStage);
        }
        Optional<Throwable> requestThrottledExceptionCause = PrestoExceptionClassifier.getRequestThrottleExceptionCause(cause);
        if (requestThrottledExceptionCause.isPresent()) {
            return new ThrottlingException(cause, queryStage);
        }
        Optional<ErrorCodeSupplier> errorCode = this.getErrorCode(cause.getErrorCode());
        boolean retryable = errorCode.isPresent() && this.isRetryable(errorCode.get(), queryStage, cause.getMessage());
        return new PrestoQueryException(cause, retryable, queryStage, errorCode, queryActionStats);
    }

    @Override
    public Optional<ErrorCodeSupplier> getErrorCode(int code) {
        return Optional.ofNullable(this.errorByCode.get(code));
    }

    @Override
    public boolean isRetryable(ErrorCodeSupplier errorCode, QueryStage queryStage, String message) {
        return this.retryableErrors.contains(errorCode) || this.conditionalRetryableErrors.stream().anyMatch(matcher -> matcher.matches(errorCode, queryStage, message));
    }

    @Override
    public boolean shouldResubmit(Throwable throwable) {
        if (!(throwable instanceof PrestoQueryException)) {
            return false;
        }
        PrestoQueryException queryException = (PrestoQueryException)throwable;
        Optional<ErrorCodeSupplier> errorCode = queryException.getErrorCode();
        return errorCode.isPresent() && (this.resubmittedErrors.contains(errorCode.get()) || this.conditionalResubmittedErrors.stream().anyMatch(matcher -> matcher.matches((ErrorCodeSupplier)errorCode.get(), queryException.getQueryStage(), queryException.getMessage())));
    }

    public static boolean isClusterConnectionException(Throwable t) {
        return PrestoExceptionClassifier.getClusterConnectionExceptionCause(t).isPresent();
    }

    private static Optional<Throwable> getClusterConnectionExceptionCause(Throwable t) {
        while (t != null) {
            if (t instanceof SocketTimeoutException || t instanceof SocketException || t instanceof EOFException || t instanceof UncheckedIOException || t instanceof TimeoutException || t.getClass().equals(RuntimeException.class) && t.getMessage() != null && t.getMessage().contains("Error fetching next at")) {
                return Optional.of(t);
            }
            t = t.getCause();
        }
        return Optional.empty();
    }

    private static Optional<Throwable> getRequestThrottleExceptionCause(Throwable t) {
        while (t != null) {
            if (t instanceof RuntimeException && t.getMessage() != null && t.getMessage().contains("Request throttled")) {
                return Optional.of(t);
            }
            t = t.getCause();
        }
        return Optional.empty();
    }

    private static class ErrorMatcher {
        private final ErrorCodeSupplier errorCode;
        private final Optional<QueryStage> queryStage;
        private final Optional<Pattern> errorMessagePattern;

        public ErrorMatcher(ErrorCodeSupplier errorCode, Optional<QueryStage> queryStage, Optional<Pattern> errorMessagePattern) {
            this.errorCode = Objects.requireNonNull(errorCode, "errorCode is null");
            this.queryStage = Objects.requireNonNull(queryStage, "queryStage is null");
            this.errorMessagePattern = Objects.requireNonNull(errorMessagePattern, "errorMessagePattern is null");
        }

        public ErrorCodeSupplier getErrorCode() {
            return this.errorCode;
        }

        public boolean matches(ErrorCodeSupplier errorCode, QueryStage queryStage, String errorMessage) {
            return !(!this.errorCode.equals(errorCode) || this.queryStage.isPresent() && !this.queryStage.get().equals((Object)queryStage) || this.errorMessagePattern.isPresent() && !this.errorMessagePattern.get().matcher(errorMessage).find());
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null || this.getClass() != obj.getClass()) {
                return false;
            }
            ErrorMatcher o = (ErrorMatcher)obj;
            return Objects.equals(this.errorCode, o.errorCode) && Objects.equals(this.queryStage, o.queryStage) && Objects.equals(this.errorMessagePattern, o.errorMessagePattern);
        }

        public int hashCode() {
            return Objects.hash(this.errorCode, this.queryStage, this.errorMessagePattern);
        }

        public String toString() {
            return MoreObjects.toStringHelper((Object)this).add("errorCode", (Object)this.errorCode).add("queryStage", this.queryStage).add("errorMessagePattern", this.errorMessagePattern).toString();
        }
    }

    public static class Builder {
        private final ImmutableSet.Builder<ErrorCodeSupplier> recognizedErrors = ImmutableSet.builder();
        private final ImmutableSet.Builder<ErrorCodeSupplier> retryableErrors = ImmutableSet.builder();
        private final ImmutableSet.Builder<ErrorMatcher> conditionalRetryableErrors = ImmutableSet.builder();
        private final ImmutableSet.Builder<ErrorCodeSupplier> resubmittedErrors = ImmutableSet.builder();
        private final ImmutableSet.Builder<ErrorMatcher> conditionalResubmittedErrors = ImmutableSet.builder();

        private Builder() {
        }

        public Builder addRecognizedErrors(Iterable<ErrorCodeSupplier> errors) {
            this.recognizedErrors.addAll(errors);
            return this;
        }

        public Builder addRetryableError(ErrorCodeSupplier error) {
            this.retryableErrors.add((Object)error);
            return this;
        }

        public Builder addRetryableError(ErrorCodeSupplier errorCode, Optional<QueryStage> queryStage, Optional<Pattern> errorMessagePattern) {
            this.conditionalRetryableErrors.add((Object)new ErrorMatcher(errorCode, queryStage, errorMessagePattern));
            return this;
        }

        public Builder addResubmittedError(ErrorCodeSupplier error) {
            this.resubmittedErrors.add((Object)error);
            return this;
        }

        public Builder addResubmittedError(ErrorCodeSupplier errorCode, Optional<QueryStage> queryStage, Optional<Pattern> errorMessagePattern) {
            this.conditionalResubmittedErrors.add((Object)new ErrorMatcher(errorCode, queryStage, errorMessagePattern));
            return this;
        }

        public PrestoExceptionClassifier build() {
            ImmutableSet recognizedErrors = this.recognizedErrors.build();
            ImmutableSet retryableErrors = this.retryableErrors.build();
            ImmutableSet conditionalRetryableErrors = this.conditionalRetryableErrors.build();
            ImmutableSet resubmittedErrors = this.resubmittedErrors.build();
            ImmutableSet conditionalResubmittedErrors = this.conditionalResubmittedErrors.build();
            retryableErrors.forEach(arg_0 -> Builder.lambda$build$0((Set)recognizedErrors, arg_0));
            conditionalRetryableErrors.forEach(arg_0 -> Builder.lambda$build$1((Set)recognizedErrors, arg_0));
            resubmittedErrors.forEach(arg_0 -> Builder.lambda$build$2((Set)recognizedErrors, arg_0));
            conditionalResubmittedErrors.forEach(arg_0 -> Builder.lambda$build$3((Set)recognizedErrors, arg_0));
            return new PrestoExceptionClassifier((Set)recognizedErrors, (Set)retryableErrors, (Set)conditionalRetryableErrors, (Set)resubmittedErrors, (Set)conditionalResubmittedErrors);
        }

        private static /* synthetic */ void lambda$build$3(Set recognizedErrors, ErrorMatcher errorMatcher) {
            Preconditions.checkArgument((boolean)recognizedErrors.contains(errorMatcher.getErrorCode()), (String)"Error not recognized: %s", (Object)errorMatcher.getErrorCode());
        }

        private static /* synthetic */ void lambda$build$2(Set recognizedErrors, ErrorCodeSupplier error) {
            Preconditions.checkArgument((boolean)recognizedErrors.contains(error), (String)"Error not recognized: %s", (Object)error);
        }

        private static /* synthetic */ void lambda$build$1(Set recognizedErrors, ErrorMatcher errorMatcher) {
            Preconditions.checkArgument((boolean)recognizedErrors.contains(errorMatcher.getErrorCode()), (String)"Error not recognized: %s", (Object)errorMatcher.getErrorCode());
        }

        private static /* synthetic */ void lambda$build$0(Set recognizedErrors, ErrorCodeSupplier error) {
            Preconditions.checkArgument((boolean)recognizedErrors.contains(error), (String)"Error not recognized: %s", (Object)error);
        }
    }
}

