/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.verifier.prestoaction;

import com.facebook.airlift.log.Logger;
import com.facebook.presto.jdbc.PrestoConnection;
import com.facebook.presto.jdbc.PrestoStatement;
import com.facebook.presto.jdbc.QueryStats;
import com.facebook.presto.sql.tree.Statement;
import com.facebook.presto.verifier.framework.ClusterConnectionException;
import com.facebook.presto.verifier.framework.PrestoQueryException;
import com.facebook.presto.verifier.framework.QueryConfiguration;
import com.facebook.presto.verifier.framework.QueryException;
import com.facebook.presto.verifier.framework.QueryResult;
import com.facebook.presto.verifier.framework.QueryStage;
import com.facebook.presto.verifier.framework.ThrottlingException;
import com.facebook.presto.verifier.framework.VerificationContext;
import com.facebook.presto.verifier.prestoaction.ClientInfoFactory;
import com.facebook.presto.verifier.prestoaction.PrestoAction;
import com.facebook.presto.verifier.prestoaction.PrestoActionConfig;
import com.facebook.presto.verifier.prestoaction.QueryActionStats;
import com.facebook.presto.verifier.prestoaction.QueryActionUtil;
import com.facebook.presto.verifier.prestoaction.SqlExceptionClassifier;
import com.facebook.presto.verifier.retry.ForClusterConnection;
import com.facebook.presto.verifier.retry.ForPresto;
import com.facebook.presto.verifier.retry.RetryConfig;
import com.facebook.presto.verifier.retry.RetryDriver;
import com.google.common.collect.ImmutableList;
import io.airlift.units.Duration;
import java.sql.DriverManager;
import java.sql.ResultSet;
import java.sql.SQLClientInfoException;
import java.sql.SQLException;
import java.util.Iterator;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;

public class JdbcPrestoAction
implements PrestoAction {
    public static final String QUERY_ACTION_TYPE = "presto-jdbc";
    private static final Logger log = Logger.get(JdbcPrestoAction.class);
    private final SqlExceptionClassifier exceptionClassifier;
    private final QueryConfiguration queryConfiguration;
    private final VerificationContext verificationContext;
    private final Iterator<String> jdbcUrlSelector;
    private final Duration queryTimeout;
    private final Duration metadataTimeout;
    private final Duration checksumTimeout;
    private final String applicationName;
    private final boolean removeMemoryRelatedSessionProperties;
    private final RetryDriver<QueryException> networkRetry;
    private final RetryDriver<QueryException> prestoRetry;
    private final ClientInfoFactory clientInfoFactory;

    public JdbcPrestoAction(SqlExceptionClassifier exceptionClassifier, QueryConfiguration queryConfiguration, VerificationContext verificationContext, Iterator<String> jdbcUrlSelector, PrestoActionConfig prestoActionConfig, Duration metadataTimeout, Duration checksumTimeout, @ForClusterConnection RetryConfig networkRetryConfig, @ForPresto RetryConfig prestoRetryConfig, ClientInfoFactory clientInfoFactory) {
        this.exceptionClassifier = Objects.requireNonNull(exceptionClassifier, "exceptionClassifier is null");
        this.queryConfiguration = Objects.requireNonNull(queryConfiguration, "queryConfiguration is null");
        this.verificationContext = Objects.requireNonNull(verificationContext, "verificationContext is null");
        this.jdbcUrlSelector = Objects.requireNonNull(jdbcUrlSelector, "jdbcUrlSelector is null");
        this.queryTimeout = Objects.requireNonNull(prestoActionConfig.getQueryTimeout(), "queryTimeout is null");
        this.applicationName = Objects.requireNonNull(prestoActionConfig.getApplicationName(), "applicationName is null");
        this.removeMemoryRelatedSessionProperties = prestoActionConfig.isRemoveMemoryRelatedSessionProperties();
        this.metadataTimeout = Objects.requireNonNull(metadataTimeout, "metadataTimeout is null");
        this.checksumTimeout = Objects.requireNonNull(checksumTimeout, "checksumTimeout is null");
        this.clientInfoFactory = Objects.requireNonNull(clientInfoFactory, "clientInfoFactory is null");
        this.networkRetry = new RetryDriver<QueryException>(networkRetryConfig, queryException -> (queryException instanceof ClusterConnectionException || queryException instanceof ThrottlingException) && queryException.isRetryable(), QueryException.class, verificationContext::addException);
        this.prestoRetry = new RetryDriver<QueryException>(prestoRetryConfig, queryException -> queryException instanceof PrestoQueryException && queryException.isRetryable(), QueryException.class, verificationContext::addException);
    }

    @Override
    public QueryActionStats execute(Statement statement, QueryStage queryStage) {
        return this.execute(statement, queryStage, new NoResultStatementExecutor());
    }

    @Override
    public <R> QueryResult<R> execute(Statement statement, QueryStage queryStage, PrestoAction.ResultSetConverter<R> converter) {
        return (QueryResult)this.execute(statement, queryStage, new ResultConvertingStatementExecutor<R>(converter));
    }

    private <T> T execute(Statement statement, QueryStage queryStage, StatementExecutor<T> statementExecutor) {
        return (T)this.prestoRetry.run("presto", () -> this.networkRetry.run("presto-cluster-connection", () -> this.executeOnce(statement, queryStage, statementExecutor)));
    }

    /*
     * Exception decompiling
     */
    private <T> T executeOnce(Statement statement, QueryStage queryStage, StatementExecutor<T> statementExecutor) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [0[TRYBLOCK]], but top level block is 1[TRYBLOCK]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private PrestoConnection getConnection(QueryStage queryStage, String clientInfo) throws SQLException {
        PrestoConnection connection = DriverManager.getConnection(this.jdbcUrlSelector.next(), this.queryConfiguration.getUsername().orElse(null), this.queryConfiguration.getPassword().orElse(null)).unwrap(PrestoConnection.class);
        try {
            connection.setClientInfo("ApplicationName", this.applicationName);
            connection.setClientInfo("ClientInfo", clientInfo);
            connection.setCatalog(this.queryConfiguration.getCatalog());
            connection.setSchema(this.queryConfiguration.getSchema());
        }
        catch (SQLClientInfoException sQLClientInfoException) {
            // empty catch block
        }
        Map<String, String> sessionProperties = QueryActionUtil.mangleSessionProperties(this.queryConfiguration.getSessionProperties(), queryStage, this.getTimeout(queryStage), this.removeMemoryRelatedSessionProperties);
        for (Map.Entry<String, String> entry : sessionProperties.entrySet()) {
            connection.setSessionProperty(entry.getKey(), entry.getValue());
        }
        return connection;
    }

    private Duration getTimeout(QueryStage queryStage) {
        switch (queryStage) {
            case REWRITE: 
            case DESCRIBE: 
            case CONTROL_SETUP: 
            case CONTROL_TEARDOWN: 
            case TEST_SETUP: 
            case TEST_TEARDOWN: 
            case DETERMINISM_ANALYSIS_SETUP: {
                return this.metadataTimeout;
            }
            case CONTROL_CHECKSUM: 
            case TEST_CHECKSUM: 
            case DETERMINISM_ANALYSIS_CHECKSUM: {
                return this.checksumTimeout;
            }
        }
        return this.queryTimeout;
    }

    private static class NoResultStatementExecutor<R>
    implements StatementExecutor<QueryActionStats> {
        private final ProgressMonitor progressMonitor = new ProgressMonitor();

        private NoResultStatementExecutor() {
        }

        @Override
        public QueryActionStats execute(PrestoStatement statement, String query) throws SQLException {
            boolean moreResults = statement.execute(query);
            if (moreResults) {
                NoResultStatementExecutor.consumeResultSet(statement.getResultSet());
            }
            do {
                if (!(moreResults = statement.getMoreResults())) continue;
                NoResultStatementExecutor.consumeResultSet(statement.getResultSet());
            } while (moreResults || statement.getUpdateCount() != -1);
            return this.progressMonitor.getLastQueryStats();
        }

        @Override
        public ProgressMonitor getProgressMonitor() {
            return this.progressMonitor;
        }

        private static void consumeResultSet(ResultSet resultSet) throws SQLException {
            while (resultSet.next()) {
            }
        }
    }

    private static class ResultConvertingStatementExecutor<R>
    implements StatementExecutor<QueryResult<R>> {
        private final PrestoAction.ResultSetConverter<R> converter;
        private final ProgressMonitor progressMonitor = new ProgressMonitor();

        public ResultConvertingStatementExecutor(PrestoAction.ResultSetConverter<R> converter) {
            this.converter = Objects.requireNonNull(converter, "converter is null");
        }

        @Override
        public QueryResult<R> execute(PrestoStatement statement, String query) throws SQLException {
            ImmutableList.Builder rows = ImmutableList.builder();
            try (ResultSet resultSet = statement.executeQuery(query);){
                while (resultSet.next()) {
                    this.converter.apply(resultSet).ifPresent(arg_0 -> ((ImmutableList.Builder)rows).add(arg_0));
                }
                QueryResult queryResult = new QueryResult(rows.build(), resultSet.getMetaData(), this.progressMonitor.getLastQueryStats());
                return queryResult;
            }
        }

        @Override
        public ProgressMonitor getProgressMonitor() {
            return this.progressMonitor;
        }
    }

    private static interface StatementExecutor<T> {
        public T execute(PrestoStatement var1, String var2) throws SQLException;

        public ProgressMonitor getProgressMonitor();
    }

    private static class ProgressMonitor
    implements Consumer<QueryStats> {
        private Optional<QueryStats> queryStats = Optional.empty();

        private ProgressMonitor() {
        }

        @Override
        public synchronized void accept(QueryStats queryStats) {
            if (!this.queryStats.isPresent()) {
                log.debug("Running Presto Query: %s", new Object[]{queryStats.getQueryId()});
            }
            this.queryStats = Optional.of(Objects.requireNonNull(queryStats, "queryStats is null"));
        }

        public synchronized QueryActionStats getLastQueryStats() {
            return new QueryActionStats(this.queryStats, Optional.empty());
        }
    }
}

