/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.verifier.framework;

import com.facebook.airlift.configuration.Config;
import com.facebook.airlift.configuration.ConfigDescription;
import com.facebook.presto.verifier.rewrite.FunctionCallRewriter;
import com.google.common.base.Splitter;
import com.google.common.collect.ImmutableMultimap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Multimap;
import java.util.Collection;
import java.util.Locale;
import java.util.Optional;
import java.util.Set;
import javax.validation.constraints.Min;
import javax.validation.constraints.NotNull;

public class VerifierConfig {
    public static final String CONTROL_TEST_MODE = "control-test";
    public static final String QUERY_BANK_MODE = "query-bank";
    private Optional<Set<String>> whitelist = Optional.empty();
    private Optional<Set<String>> blacklist = Optional.empty();
    private String sourceQuerySupplier = "mysql";
    private Set<String> eventClients = ImmutableSet.of((Object)"human-readable");
    private Optional<String> jsonEventLogFile = Optional.empty();
    private Optional<String> humanReadableEventLogFile = Optional.empty();
    private String testId;
    private Optional<String> testName = Optional.empty();
    private int maxConcurrency = 10;
    private int suiteRepetitions = 1;
    private int queryRepetitions = 1;
    private double relativeErrorMargin = 1.0E-4;
    private double absoluteErrorMargin = 1.0E-12;
    private boolean useErrorMarginForFloatingPointArrays = true;
    private boolean validateStringAsDouble;
    private boolean smartTeardown;
    private int verificationResubmissionLimit = 6;
    private boolean setupOnMainClusters = true;
    private boolean teardownOnMainClusters = true;
    private boolean skipControl;
    private boolean skipChecksum;
    private boolean concurrentControlAndTest;
    private boolean explain;
    private boolean saveSnapshot;
    private boolean extendedVerification;
    private String runningMode = "control-test";
    private Multimap<String, FunctionCallRewriter.FunctionCallSubstitute> functionSubstitutes = ImmutableMultimap.of();

    @NotNull
    public Optional<Set<String>> getWhitelist() {
        return this.whitelist;
    }

    @ConfigDescription(value="Names of queries which are whitelisted. Whitelist is applied before the blacklist")
    @Config(value="whitelist")
    public VerifierConfig setWhitelist(String whitelist) {
        this.whitelist = whitelist == null ? Optional.empty() : Optional.of(ImmutableSet.copyOf((Collection)Splitter.on((char)',').trimResults().omitEmptyStrings().splitToList((CharSequence)whitelist)));
        return this;
    }

    @NotNull
    public Optional<Set<String>> getBlacklist() {
        return this.blacklist;
    }

    @ConfigDescription(value="Names of queries which are blacklisted")
    @Config(value="blacklist")
    public VerifierConfig setBlacklist(String blacklist) {
        this.blacklist = blacklist == null ? Optional.empty() : Optional.of(ImmutableSet.copyOf((Collection)Splitter.on((char)',').trimResults().omitEmptyStrings().splitToList((CharSequence)blacklist)));
        return this;
    }

    @NotNull
    public String getSourceQuerySupplier() {
        return this.sourceQuerySupplier;
    }

    @ConfigDescription(value="The type of source query supplier")
    @Config(value="source-query.supplier")
    public VerifierConfig setSourceQuerySupplier(String sourceQuerySupplier) {
        this.sourceQuerySupplier = sourceQuerySupplier;
        return this;
    }

    @NotNull
    public Set<String> getEventClients() {
        return this.eventClients;
    }

    @ConfigDescription(value="The event client(s) to log the results to")
    @Config(value="event-clients")
    public VerifierConfig setEventClients(String eventClients) {
        this.eventClients = ImmutableSet.copyOf((Collection)Splitter.on((char)',').trimResults().omitEmptyStrings().splitToList((CharSequence)eventClients));
        return this;
    }

    @NotNull
    public Optional<String> getJsonEventLogFile() {
        return this.jsonEventLogFile;
    }

    @ConfigDescription(value="The file to log json events. Used with event-clients=json. Print to standard output stream if not specified.")
    @Config(value="json.log-file")
    public VerifierConfig setJsonEventLogFile(String jsonEventLogFile) {
        this.jsonEventLogFile = Optional.ofNullable(jsonEventLogFile);
        return this;
    }

    @NotNull
    public Optional<String> getHumanReadableEventLogFile() {
        return this.humanReadableEventLogFile;
    }

    @ConfigDescription(value="The file to log human readable events. Used with event-clients=human-readable. Print to standard output stream if not specified.")
    @Config(value="human-readable.log-file")
    public VerifierConfig setHumanReadableEventLogFile(String humanReadableEventLogFile) {
        this.humanReadableEventLogFile = Optional.ofNullable(humanReadableEventLogFile);
        return this;
    }

    @NotNull
    public String getTestId() {
        return this.testId;
    }

    @ConfigDescription(value="A customizable string that will be passed into query client info and logged with the results")
    @Config(value="test-id")
    public VerifierConfig setTestId(String testId) {
        this.testId = testId;
        return this;
    }

    @NotNull
    public Optional<String> getTestName() {
        return this.testName;
    }

    @ConfigDescription(value="A customizable string that will be passed into query client info")
    @Config(value="test-name")
    public VerifierConfig setTestName(String testName) {
        this.testName = Optional.ofNullable(testName);
        return this;
    }

    @Min(value=1L)
    public @Min(value=1L) int getMaxConcurrency() {
        return this.maxConcurrency;
    }

    @Config(value="max-concurrency")
    public VerifierConfig setMaxConcurrency(int maxConcurrency) {
        this.maxConcurrency = maxConcurrency;
        return this;
    }

    @Min(value=1L)
    public @Min(value=1L) int getSuiteRepetitions() {
        return this.suiteRepetitions;
    }

    @ConfigDescription(value="Number of times to run each suite")
    @Config(value="suite-repetitions")
    public VerifierConfig setSuiteRepetitions(int suiteRepetitions) {
        this.suiteRepetitions = suiteRepetitions;
        return this;
    }

    @Min(value=1L)
    public @Min(value=1L) int getQueryRepetitions() {
        return this.queryRepetitions;
    }

    @ConfigDescription(value="The number of times to repeat each query")
    @Config(value="query-repetitions")
    public VerifierConfig setQueryRepetitions(int queryRepetitions) {
        this.queryRepetitions = queryRepetitions;
        return this;
    }

    @Min(value=0L)
    public @Min(value=0L) double getRelativeErrorMargin() {
        return this.relativeErrorMargin;
    }

    @ConfigDescription(value="The maximum tolerable relative error between the sum of two floating point columns.")
    @Config(value="relative-error-margin")
    public VerifierConfig setRelativeErrorMargin(double relativeErrorMargin) {
        this.relativeErrorMargin = relativeErrorMargin;
        return this;
    }

    @Min(value=0L)
    public @Min(value=0L) double getAbsoluteErrorMargin() {
        return this.absoluteErrorMargin;
    }

    @ConfigDescription(value="The maximum tolerable difference between the mean of two floating point columns. Applicable when one mean value is 0.")
    @Config(value="absolute-error-margin")
    public VerifierConfig setAbsoluteErrorMargin(double absoluteErrorMargin) {
        this.absoluteErrorMargin = absoluteErrorMargin;
        return this;
    }

    public boolean isUseErrorMarginForFloatingPointArrays() {
        return this.useErrorMarginForFloatingPointArrays;
    }

    @ConfigDescription(value="When set to true, arrays of floating point numbers are validated like floating point columns, using error margins. False by default.")
    @Config(value="use-error-margin-for-floating-point-arrays")
    public VerifierConfig setUseErrorMarginForFloatingPointArrays(boolean useErrorMarginForFloatingPointArrays) {
        this.useErrorMarginForFloatingPointArrays = useErrorMarginForFloatingPointArrays;
        return this;
    }

    public boolean isValidateStringAsDouble() {
        return this.validateStringAsDouble;
    }

    @ConfigDescription(value="When set to true, validate string column as double if the values are all in the floating point format.")
    @Config(value="validate-string-as-double")
    public VerifierConfig setValidateStringAsDouble(boolean validateStringAsDouble) {
        this.validateStringAsDouble = validateStringAsDouble;
        return this;
    }

    public boolean isSmartTeardown() {
        return this.smartTeardown;
    }

    @ConfigDescription(value="When set to false, temporary tables are not dropped if verification fails and both control and test query succeeds")
    @Config(value="smart-teardown")
    public VerifierConfig setSmartTeardown(boolean smartTeardown) {
        this.smartTeardown = smartTeardown;
        return this;
    }

    @Min(value=0L)
    public @Min(value=0L) int getVerificationResubmissionLimit() {
        return this.verificationResubmissionLimit;
    }

    @ConfigDescription(value="Maximum number of time a transiently failed verification can be resubmitted")
    @Config(value="verification-resubmission.limit")
    public VerifierConfig setVerificationResubmissionLimit(int verificationResubmissionLimit) {
        this.verificationResubmissionLimit = verificationResubmissionLimit;
        return this;
    }

    public boolean isSetupOnMainClusters() {
        return this.setupOnMainClusters;
    }

    @ConfigDescription(value="If true, run control/test setup queries on control/test clusters. Otherwise, run setup queries on the help cluster.")
    @Config(value="setup-on-main-clusters")
    public VerifierConfig setSetupOnMainClusters(boolean setupOnMainClusters) {
        this.setupOnMainClusters = setupOnMainClusters;
        return this;
    }

    public boolean isTeardownOnMainClusters() {
        return this.teardownOnMainClusters;
    }

    @ConfigDescription(value="If true, run control/test teardown queries on control/test clusters. Otherwise, run teardown queries on the help cluster.")
    @Config(value="teardown-on-main-clusters")
    public VerifierConfig setTeardownOnMainClusters(boolean teardownOnMainClusters) {
        this.teardownOnMainClusters = teardownOnMainClusters;
        return this;
    }

    public boolean isSkipControl() {
        return this.skipControl;
    }

    @ConfigDescription(value="Skip control queries and result comparison, only run test queries.")
    @Config(value="skip-control")
    public VerifierConfig setSkipControl(boolean skipControl) {
        this.skipControl = skipControl;
        return this;
    }

    @ConfigDescription(value="Skip checksum, only run control and test queries.")
    @Config(value="skip-checksum")
    public VerifierConfig setSkipChecksum(boolean skipChecksum) {
        this.skipChecksum = skipChecksum;
        return this;
    }

    public boolean isSkipChecksum() {
        return this.skipChecksum;
    }

    public boolean isExplain() {
        return this.explain;
    }

    @ConfigDescription(value="If true, run explain verification on the given queries.")
    @Config(value="explain")
    public VerifierConfig setExplain(boolean explain) {
        this.explain = explain;
        return this;
    }

    public boolean isConcurrentControlAndTest() {
        return this.concurrentControlAndTest;
    }

    @ConfigDescription(value="Run control and test query concurrently")
    @Config(value="concurrent-control-and-test")
    public VerifierConfig setConcurrentControlAndTest(boolean concurrentControlAndTest) {
        this.concurrentControlAndTest = concurrentControlAndTest;
        return this;
    }

    public boolean isSaveSnapshot() {
        return this.saveSnapshot;
    }

    @ConfigDescription(value="Save control query results to database as snapshots.")
    @Config(value="save-snapshot")
    public VerifierConfig setSaveSnapshot(boolean saveSnapshot) {
        this.saveSnapshot = saveSnapshot;
        return this;
    }

    public boolean isExtendedVerification() {
        return this.extendedVerification;
    }

    @ConfigDescription(value="Run extended verification logic in verifier.")
    @Config(value="extended-verification")
    public VerifierConfig setExtendedVerification(boolean extendedVerification) {
        this.extendedVerification = extendedVerification;
        return this;
    }

    public String getRunningMode() {
        return this.runningMode;
    }

    @ConfigDescription(value="Set running mode to 'control-test' or 'query-bank'.")
    @Config(value="running-mode")
    public VerifierConfig setRunningMode(String runningMode) {
        this.runningMode = runningMode;
        if (QUERY_BANK_MODE.toLowerCase(Locale.ENGLISH).equals(runningMode)) {
            this.skipControl = true;
        }
        return this;
    }

    public Multimap<String, FunctionCallRewriter.FunctionCallSubstitute> getFunctionSubstitutes() {
        return this.functionSubstitutes;
    }

    @ConfigDescription(value="Specification of function substitutions, in the format of /foo(c0,_)/bar(c0)/,/fred(c0,c1)/baz(qux(c1,c0))/,/foobar(c0)/if(qux(c1),bar(c0),baz(c1))/,..., where foo(c0, _) would be substituted by bar(c0), with the declared arguments applied to the corresponding positions. Concatenate function substitutions with comma.")
    @Config(value="function-substitutes")
    public VerifierConfig setFunctionSubstitutes(String functionSubstitutes) {
        this.functionSubstitutes = FunctionCallRewriter.validateAndConstructFunctionCallSubstituteMap(functionSubstitutes);
        return this;
    }
}

