/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.verifier.framework;

import com.facebook.presto.sql.tree.Expression;
import com.facebook.presto.sql.tree.QualifiedName;
import com.facebook.presto.sql.tree.Statement;
import com.facebook.presto.verifier.framework.ClusterType;
import com.facebook.presto.verifier.framework.QueryBundle;
import java.util.List;
import java.util.Objects;
import java.util.Optional;

public class QueryObjectBundle
extends QueryBundle {
    private final QualifiedName objectName;
    private final Optional<Expression> partitionsPredicate;
    private final boolean reuseTable;
    private final Optional<String> rewrittenFunctionCalls;

    public QueryObjectBundle(QualifiedName objectName, List<Statement> setupQueries, Statement query, List<Statement> teardownQueries, ClusterType cluster, Optional<String> rewrittenFunctionCalls, Optional<Expression> partitionsPredicate, boolean reuseTable) {
        super(setupQueries, query, teardownQueries, cluster);
        this.objectName = Objects.requireNonNull(objectName, "objectName is null");
        this.rewrittenFunctionCalls = Objects.requireNonNull(rewrittenFunctionCalls, "rewrittenFunctionCalls is null");
        this.partitionsPredicate = partitionsPredicate;
        this.reuseTable = reuseTable;
    }

    public QualifiedName getObjectName() {
        return this.objectName;
    }

    public Optional<String> getRewrittenFunctionCalls() {
        return this.rewrittenFunctionCalls;
    }

    public boolean isReuseTable() {
        return this.reuseTable;
    }

    public Optional<Expression> getPartitionsPredicate() {
        return this.partitionsPredicate;
    }
}

