/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.verifier.framework;

import com.facebook.presto.verifier.framework.QueryConfigurationOverrides;
import com.google.common.base.MoreObjects;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import org.jdbi.v3.core.mapper.reflect.ColumnName;
import org.jdbi.v3.core.mapper.reflect.JdbiConstructor;

public class QueryConfiguration {
    public static final String CLIENT_TAG_OUTPUT_RETAINED = "OUTPUT_RETAINED";
    private final String catalog;
    private final String schema;
    private final Optional<String> username;
    private final Optional<String> password;
    private final Map<String, String> sessionProperties;
    private final boolean isReusableTable;
    private final List<String> partitions;

    @JdbiConstructor
    public QueryConfiguration(@ColumnName(value="catalog") String catalog, @ColumnName(value="schema") String schema, @ColumnName(value="username") Optional<String> username, @ColumnName(value="password") Optional<String> password, @ColumnName(value="session_properties") Optional<Map<String, String>> sessionProperties, @ColumnName(value="client_tags") Optional<List<String>> clientTags, @ColumnName(value="partitions") Optional<List<String>> partitions) {
        this(catalog, schema, username, password, sessionProperties, clientTags.filter(tags -> tags.contains(CLIENT_TAG_OUTPUT_RETAINED)).isPresent(), partitions);
    }

    public QueryConfiguration(String catalog, String schema, Optional<String> username, Optional<String> password, Optional<Map<String, String>> sessionProperties, boolean isReusableTable, Optional<List<String>> partitions) {
        this.catalog = Objects.requireNonNull(catalog, "catalog is null");
        this.schema = Objects.requireNonNull(schema, "schema is null");
        this.username = Objects.requireNonNull(username, "username is null");
        this.password = Objects.requireNonNull(password, "password is null");
        this.sessionProperties = ImmutableMap.copyOf(sessionProperties.orElse((Map<String, String>)ImmutableMap.of()));
        this.isReusableTable = isReusableTable;
        this.partitions = ImmutableList.copyOf((Collection)partitions.orElse((List<String>)ImmutableList.of()));
    }

    public QueryConfiguration applyOverrides(QueryConfigurationOverrides overrides) {
        HashMap<String, String> sessionProperties;
        if (overrides.getSessionPropertiesOverrideStrategy() == QueryConfigurationOverrides.SessionPropertiesOverrideStrategy.OVERRIDE) {
            sessionProperties = new HashMap<String, String>(overrides.getSessionPropertiesOverride());
        } else {
            sessionProperties = new HashMap<String, String>(this.sessionProperties);
            if (overrides.getSessionPropertiesOverrideStrategy() == QueryConfigurationOverrides.SessionPropertiesOverrideStrategy.SUBSTITUTE) {
                sessionProperties.putAll(overrides.getSessionPropertiesOverride());
            }
        }
        overrides.getSessionPropertiesToRemove().forEach(sessionProperties::remove);
        return new QueryConfiguration(overrides.getCatalogOverride().orElse(this.catalog), overrides.getSchemaOverride().orElse(this.schema), Optional.ofNullable(overrides.getUsernameOverride().orElse(this.username.orElse(null))), Optional.ofNullable(overrides.getPasswordOverride().orElse(this.password.orElse(null))), Optional.of(sessionProperties), this.isReusableTable, Optional.of(this.partitions));
    }

    public String getCatalog() {
        return this.catalog;
    }

    public String getSchema() {
        return this.schema;
    }

    public Optional<String> getUsername() {
        return this.username;
    }

    public Optional<String> getPassword() {
        return this.password;
    }

    public Map<String, String> getSessionProperties() {
        return this.sessionProperties;
    }

    public boolean isReusableTable() {
        return this.isReusableTable;
    }

    public List<String> getPartitions() {
        return this.partitions;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        QueryConfiguration o = (QueryConfiguration)obj;
        return Objects.equals(this.catalog, o.catalog) && Objects.equals(this.schema, o.schema) && Objects.equals(this.username, o.username) && Objects.equals(this.password, o.password) && Objects.equals(this.sessionProperties, o.sessionProperties) && this.isReusableTable == o.isReusableTable && Objects.equals(this.partitions, this.partitions);
    }

    public int hashCode() {
        return Objects.hash(this.catalog, this.schema, this.username, this.password, this.sessionProperties, this.isReusableTable, this.partitions);
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("catalog", (Object)this.catalog).add("schema", (Object)this.schema).add("username", this.username).add("password", this.password).add("sessionProperties", this.sessionProperties).add("isReusableTable", this.isReusableTable).add("partitions", this.partitions).toString();
    }
}

