/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.verifier.framework;

import com.facebook.presto.common.type.TypeManager;
import com.facebook.presto.jdbc.QueryStats;
import com.facebook.presto.sql.tree.QualifiedName;
import com.facebook.presto.sql.tree.Query;
import com.facebook.presto.sql.tree.Statement;
import com.facebook.presto.verifier.checksum.ChecksumResult;
import com.facebook.presto.verifier.checksum.ChecksumValidator;
import com.facebook.presto.verifier.checksum.ColumnMatchResult;
import com.facebook.presto.verifier.framework.ChecksumQueryContext;
import com.facebook.presto.verifier.framework.Column;
import com.facebook.presto.verifier.framework.DataMatchResult;
import com.facebook.presto.verifier.framework.DataVerification;
import com.facebook.presto.verifier.framework.DataVerificationUtil;
import com.facebook.presto.verifier.framework.DeterminismAnalyzer;
import com.facebook.presto.verifier.framework.QueryObjectBundle;
import com.facebook.presto.verifier.framework.QueryResult;
import com.facebook.presto.verifier.framework.QueryStage;
import com.facebook.presto.verifier.framework.SnapshotQuery;
import com.facebook.presto.verifier.framework.SourceQuery;
import com.facebook.presto.verifier.framework.VerificationContext;
import com.facebook.presto.verifier.framework.VerifierConfig;
import com.facebook.presto.verifier.framework.VerifierUtil;
import com.facebook.presto.verifier.prestoaction.QueryActions;
import com.facebook.presto.verifier.prestoaction.SqlExceptionClassifier;
import com.facebook.presto.verifier.resolver.FailureResolverManager;
import com.facebook.presto.verifier.rewrite.QueryRewriter;
import com.facebook.presto.verifier.source.SnapshotQueryConsumer;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import com.google.common.util.concurrent.ListeningExecutorService;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.OptionalLong;
import java.util.Set;

public class ExtendedVerification
extends DataVerification {
    public ExtendedVerification(QueryActions queryActions, SourceQuery sourceQuery, QueryRewriter queryRewriter, DeterminismAnalyzer determinismAnalyzer, FailureResolverManager failureResolverManager, SqlExceptionClassifier exceptionClassifier, VerificationContext verificationContext, VerifierConfig verifierConfig, TypeManager typeManager, ChecksumValidator checksumValidator, ListeningExecutorService executor, SnapshotQueryConsumer snapshotQueryConsumer, Map<String, SnapshotQuery> snapshotQueries) {
        super(queryActions, sourceQuery, queryRewriter, determinismAnalyzer, failureResolverManager, exceptionClassifier, verificationContext, verifierConfig, typeManager, checksumValidator, executor, snapshotQueryConsumer, snapshotQueries);
    }

    @Override
    public DataMatchResult verify(QueryObjectBundle control, QueryObjectBundle test, Optional<QueryResult<Void>> controlQueryResult, Optional<QueryResult<Void>> testQueryResult, ChecksumQueryContext controlChecksumQueryContext, ChecksumQueryContext testChecksumQueryContext) {
        List<Column> testPartitionColumns;
        List<Column> controlPartitionColumns;
        DataMatchResult dataMatchResult = super.verify(control, test, controlQueryResult, testQueryResult, controlChecksumQueryContext, testChecksumQueryContext);
        if (!dataMatchResult.isMatched()) {
            return dataMatchResult;
        }
        if (this.skipControl || this.saveSnapshot || this.runningMode.equals("query-bank")) {
            return dataMatchResult;
        }
        List<Column> controlColumns = DataVerificationUtil.getColumns(this.getHelperAction(), this.typeManager, control.getObjectName());
        List<Column> testColumns = DataVerificationUtil.getColumns(this.getHelperAction(), this.typeManager, test.getObjectName());
        try {
            controlPartitionColumns = DataVerificationUtil.getColumns(this.getHelperAction(), this.typeManager, this.formPartitionTableName(control.getObjectName()));
            testPartitionColumns = DataVerificationUtil.getColumns(this.getHelperAction(), this.typeManager, this.formPartitionTableName(test.getObjectName()));
        }
        catch (Throwable e) {
            return dataMatchResult;
        }
        List<Column> controlDataColumns = this.getDataColumn(controlColumns, (Set<Column>)ImmutableSet.copyOf(controlPartitionColumns));
        List<Column> testDataColumns = this.getDataColumn(testColumns, (Set<Column>)ImmutableSet.copyOf(testPartitionColumns));
        Optional<DataMatchResult> partitionMatchResult = this.verifyPartition(control, test, controlPartitionColumns, testPartitionColumns, controlDataColumns, testDataColumns, controlChecksumQueryContext, testChecksumQueryContext);
        Optional<DataMatchResult> bucketMatchResult = this.verifyBucket(control, test, controlPartitionColumns, testPartitionColumns, controlDataColumns, testDataColumns, controlChecksumQueryContext, testChecksumQueryContext);
        if (partitionMatchResult.isPresent() && !partitionMatchResult.get().isMatched()) {
            return partitionMatchResult.get();
        }
        if (bucketMatchResult.isPresent() && !bucketMatchResult.get().isMatched()) {
            return bucketMatchResult.get();
        }
        return dataMatchResult;
    }

    private Optional<DataMatchResult> verifyPartition(QueryObjectBundle control, QueryObjectBundle test, List<Column> controlPartitionColumns, List<Column> testPartitionColumns, List<Column> controlDataColumns, List<Column> testDataColumns, ChecksumQueryContext controlChecksumQueryContext, ChecksumQueryContext testChecksumQueryContext) {
        List<ChecksumResult> controlPartitionChecksum = this.runPartitionChecksum(control, controlPartitionColumns, controlDataColumns, controlChecksumQueryContext, QueryStage.CONTROL_PARTITION_CHECKSUM);
        List<ChecksumResult> testPartitionChecksum = this.runPartitionChecksum(test, testPartitionColumns, testDataColumns, testChecksumQueryContext, QueryStage.TEST_PARTITION_CHECKSUM);
        if (controlPartitionChecksum.size() != testPartitionChecksum.size()) {
            return Optional.of(new DataMatchResult(DataMatchResult.DataType.PARTITION_DATA, DataMatchResult.MatchType.PARTITION_COUNT_MISMATCH, Optional.empty(), OptionalLong.of(controlPartitionChecksum.size()), OptionalLong.of(testPartitionChecksum.size()), (List<ColumnMatchResult<?>>)ImmutableList.of()));
        }
        for (int i = 0; i < controlPartitionChecksum.size(); ++i) {
            DataMatchResult partitionMatchResult = DataVerificationUtil.match(DataMatchResult.DataType.PARTITION_DATA, this.checksumValidator, controlDataColumns, testDataColumns, controlPartitionChecksum.get(i), testPartitionChecksum.get(i));
            if (partitionMatchResult.isMatched()) continue;
            return Optional.of(partitionMatchResult);
        }
        return Optional.of(new DataMatchResult(DataMatchResult.DataType.PARTITION_DATA, DataMatchResult.MatchType.MATCH, Optional.empty(), OptionalLong.of(controlPartitionChecksum.size()), OptionalLong.of(testPartitionChecksum.size()), (List<ColumnMatchResult<?>>)ImmutableList.of()));
    }

    private Optional<DataMatchResult> verifyBucket(QueryObjectBundle control, QueryObjectBundle test, List<Column> controlPartitionColumns, List<Column> testPartitionColumns, List<Column> controlDataColumns, List<Column> testDataColumns, ChecksumQueryContext controlChecksumQueryContext, ChecksumQueryContext testChecksumQueryContext) {
        List<ChecksumResult> controlBucketChecksum = null;
        List<ChecksumResult> testBucketChecksum = null;
        try {
            controlBucketChecksum = this.runBucketChecksum(control, controlPartitionColumns, controlDataColumns, controlChecksumQueryContext, QueryStage.CONTROL_BUCKET_CHECKSUM);
            testBucketChecksum = this.runBucketChecksum(test, testPartitionColumns, testDataColumns, testChecksumQueryContext, QueryStage.TEST_BUCKET_CHECKSUM);
        }
        catch (Throwable e) {
            return Optional.empty();
        }
        if (controlBucketChecksum.size() != testBucketChecksum.size()) {
            return Optional.of(new DataMatchResult(DataMatchResult.DataType.BUCKET_DATA, DataMatchResult.MatchType.BUCKET_COUNT_MISMATCH, Optional.empty(), OptionalLong.of(controlBucketChecksum.size()), OptionalLong.of(testBucketChecksum.size()), (List<ColumnMatchResult<?>>)ImmutableList.of()));
        }
        for (int i = 0; i < controlBucketChecksum.size(); ++i) {
            DataMatchResult bucketMatchResult = DataVerificationUtil.match(DataMatchResult.DataType.BUCKET_DATA, this.checksumValidator, controlDataColumns, testDataColumns, controlBucketChecksum.get(i), testBucketChecksum.get(i));
            if (bucketMatchResult.isMatched()) continue;
            return Optional.of(bucketMatchResult);
        }
        return Optional.of(new DataMatchResult(DataMatchResult.DataType.BUCKET_DATA, DataMatchResult.MatchType.MATCH, Optional.empty(), OptionalLong.of(controlBucketChecksum.size()), OptionalLong.of(testBucketChecksum.size()), (List<ColumnMatchResult<?>>)ImmutableList.of()));
    }

    private QualifiedName formPartitionTableName(QualifiedName tableName) {
        int nameSizes = tableName.getParts().size();
        ImmutableList.Builder nameBuilder = ImmutableList.builder();
        for (int index = 0; index < nameSizes; ++index) {
            String part = null;
            part = index != nameSizes - 1 ? (String)tableName.getParts().get(index) : (String)tableName.getParts().get(index) + "$partitions";
            nameBuilder.add((Object)part);
        }
        return QualifiedName.of((Iterable)nameBuilder.build());
    }

    private List<Column> getDataColumn(List<Column> columns, Set<Column> partitionColumns) {
        ImmutableList.Builder dataColumns = ImmutableList.builder();
        for (Column column : columns) {
            if (partitionColumns.contains(column)) continue;
            dataColumns.add((Object)column);
        }
        return dataColumns.build();
    }

    private List<ChecksumResult> runPartitionChecksum(QueryObjectBundle bundle, List<Column> partitionColumns, List<Column> dataColumns, ChecksumQueryContext checksumQueryContext, QueryStage queryStage) {
        Query partitionChecksumQuery = this.checksumValidator.generatePartitionChecksumQuery(bundle.getObjectName(), dataColumns, partitionColumns, bundle.getPartitionsPredicate());
        checksumQueryContext.setPartitionChecksumQuery(ExtendedVerification.formatSql((Statement)partitionChecksumQuery));
        return VerifierUtil.callAndConsume(() -> this.getHelperAction().execute((Statement)partitionChecksumQuery, queryStage, ChecksumResult::fromResultSet), stats -> stats.getQueryStats().map(QueryStats::getQueryId).ifPresent(checksumQueryContext::setPartitionChecksumQueryId)).getResults();
    }

    private List<ChecksumResult> runBucketChecksum(QueryObjectBundle bundle, List<Column> partitionColumns, List<Column> dataColumns, ChecksumQueryContext checksumQueryContext, QueryStage queryStage) {
        Query bucketChecksumQuery = this.checksumValidator.generateBucketChecksumQuery(bundle.getObjectName(), partitionColumns, dataColumns, bundle.getPartitionsPredicate());
        List<ChecksumResult> checksumResults = VerifierUtil.callAndConsume(() -> this.getHelperAction().execute((Statement)bucketChecksumQuery, queryStage, ChecksumResult::fromResultSet), stats -> stats.getQueryStats().map(QueryStats::getQueryId).ifPresent(checksumQueryContext::setBucketChecksumQueryId)).getResults();
        checksumQueryContext.setBucketChecksumQuery(ExtendedVerification.formatSql((Statement)bucketChecksumQuery));
        return checksumResults;
    }
}

