/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.verifier.framework;

import com.facebook.presto.sql.parser.ParsingException;
import com.facebook.presto.verifier.framework.MatchResult;
import com.google.common.base.Throwables;
import java.util.Objects;
import java.util.Optional;

public class DdlMatchResult
implements MatchResult {
    private final MatchType matchType;
    private final Optional<ParsingException> exception;
    private final String controlObject;
    private final String testObject;

    public DdlMatchResult(MatchType matchType, Optional<ParsingException> exception, String controlObject, String testObject) {
        this.matchType = Objects.requireNonNull(matchType, "matchType is null");
        this.exception = Objects.requireNonNull(exception, "exception is null");
        this.controlObject = Objects.requireNonNull(controlObject, "controlObject is null");
        this.testObject = Objects.requireNonNull(testObject, "testObject is null");
    }

    @Override
    public boolean isMatched() {
        return this.matchType == MatchType.MATCH;
    }

    @Override
    public String getDataType() {
        return "DDL";
    }

    @Override
    public String getMatchTypeName() {
        return this.matchType.name();
    }

    @Override
    public boolean isMismatchPossiblyCausedByNonDeterminism() {
        return false;
    }

    @Override
    public boolean isMismatchPossiblyCausedByReuseOutdatedTable() {
        return false;
    }

    @Override
    public String getReport() {
        StringBuilder message = new StringBuilder().append(this.getMatchTypeName()).append("\n\n");
        this.exception.ifPresent(e -> message.append(Throwables.getStackTraceAsString((Throwable)e)).append("\n"));
        return message.append("Control:\n").append(this.controlObject.trim()).append("\n\n").append("Test:").append(this.testObject.trim()).append("\n").toString();
    }

    public static enum MatchType {
        MATCH,
        MISMATCH,
        CONTROL_NOT_PARSABLE,
        TEST_NOT_PARSABLE,
        SNAPSHOT_DOES_NOT_EXIST;

    }
}

