/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.verifier.framework;

import com.facebook.presto.common.type.TypeManager;
import com.facebook.presto.jdbc.QueryStats;
import com.facebook.presto.sql.tree.QualifiedName;
import com.facebook.presto.sql.tree.Query;
import com.facebook.presto.sql.tree.Statement;
import com.facebook.presto.verifier.checksum.ChecksumResult;
import com.facebook.presto.verifier.checksum.ChecksumValidator;
import com.facebook.presto.verifier.checksum.ColumnMatchResult;
import com.facebook.presto.verifier.event.DeterminismAnalysisDetails;
import com.facebook.presto.verifier.event.QueryInfo;
import com.facebook.presto.verifier.framework.AbstractVerification;
import com.facebook.presto.verifier.framework.ChecksumQueryContext;
import com.facebook.presto.verifier.framework.ClusterType;
import com.facebook.presto.verifier.framework.Column;
import com.facebook.presto.verifier.framework.DataMatchResult;
import com.facebook.presto.verifier.framework.DataVerificationUtil;
import com.facebook.presto.verifier.framework.DeterminismAnalyzer;
import com.facebook.presto.verifier.framework.QueryObjectBundle;
import com.facebook.presto.verifier.framework.QueryResult;
import com.facebook.presto.verifier.framework.QueryStage;
import com.facebook.presto.verifier.framework.QueryState;
import com.facebook.presto.verifier.framework.SnapshotQuery;
import com.facebook.presto.verifier.framework.SourceQuery;
import com.facebook.presto.verifier.framework.VerificationContext;
import com.facebook.presto.verifier.framework.VerifierConfig;
import com.facebook.presto.verifier.framework.VerifierUtil;
import com.facebook.presto.verifier.prestoaction.QueryActions;
import com.facebook.presto.verifier.prestoaction.SqlExceptionClassifier;
import com.facebook.presto.verifier.resolver.FailureResolverManager;
import com.facebook.presto.verifier.rewrite.QueryRewriter;
import com.facebook.presto.verifier.source.SnapshotQueryConsumer;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Iterables;
import com.google.common.util.concurrent.ListeningExecutorService;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.OptionalLong;

public class DataVerification
extends AbstractVerification<QueryObjectBundle, DataMatchResult, Void> {
    protected final QueryRewriter queryRewriter;
    protected final DeterminismAnalyzer determinismAnalyzer;
    protected final FailureResolverManager failureResolverManager;
    protected final TypeManager typeManager;
    protected final ChecksumValidator checksumValidator;

    public DataVerification(QueryActions queryActions, SourceQuery sourceQuery, QueryRewriter queryRewriter, DeterminismAnalyzer determinismAnalyzer, FailureResolverManager failureResolverManager, SqlExceptionClassifier exceptionClassifier, VerificationContext verificationContext, VerifierConfig verifierConfig, TypeManager typeManager, ChecksumValidator checksumValidator, ListeningExecutorService executor, SnapshotQueryConsumer snapshotQueryConsumer, Map<String, SnapshotQuery> snapshotQueries) {
        super(queryActions, sourceQuery, exceptionClassifier, verificationContext, Optional.empty(), verifierConfig, executor, snapshotQueryConsumer, snapshotQueries);
        this.queryRewriter = Objects.requireNonNull(queryRewriter, "queryRewriter is null");
        this.determinismAnalyzer = Objects.requireNonNull(determinismAnalyzer, "determinismAnalyzer is null");
        this.failureResolverManager = Objects.requireNonNull(failureResolverManager, "failureResolverManager is null");
        this.typeManager = Objects.requireNonNull(typeManager, "typeManager is null");
        this.checksumValidator = Objects.requireNonNull(checksumValidator, "checksumValidator is null");
    }

    @Override
    protected QueryObjectBundle getQueryRewrite(ClusterType clusterType) {
        return this.queryRewriter.rewriteQuery(this.getSourceQuery().getQuery(clusterType), this.getSourceQuery().getQueryConfiguration(clusterType), clusterType, this.getVerificationContext().getResubmissionCount() == 0);
    }

    @Override
    protected void updateQueryInfoWithQueryBundle(QueryInfo.Builder queryInfo, Optional<QueryObjectBundle> queryBundle) {
        super.updateQueryInfoWithQueryBundle(queryInfo, queryBundle);
        queryInfo.setQuery(queryBundle.map(bundle -> DataVerification.formatSql(bundle.getQuery(), bundle.getRewrittenFunctionCalls()))).setOutputTableName(queryBundle.map(QueryObjectBundle::getObjectName).map(QualifiedName::toString)).setIsReuseTable(queryBundle.map(QueryObjectBundle::isReuseTable).orElse(false));
    }

    @Override
    public DataMatchResult verify(QueryObjectBundle control, QueryObjectBundle test, Optional<QueryResult<Void>> controlQueryResult, Optional<QueryResult<Void>> testQueryResult, ChecksumQueryContext controlChecksumQueryContext, ChecksumQueryContext testChecksumQueryContext) {
        List<Column> testColumns = DataVerificationUtil.getColumns(this.getHelperAction(), this.typeManager, test.getObjectName());
        Query testChecksumQuery = this.checksumValidator.generateChecksumQuery(test.getObjectName(), testColumns, test.getPartitionsPredicate());
        testChecksumQueryContext.setChecksumQuery(DataVerification.formatSql((Statement)testChecksumQuery));
        List<Column> controlColumns = null;
        ChecksumResult controlChecksumResult = null;
        if (this.isControlEnabled()) {
            controlColumns = DataVerificationUtil.getColumns(this.getHelperAction(), this.typeManager, control.getObjectName());
            Query controlChecksumQuery = this.checksumValidator.generateChecksumQuery(control.getObjectName(), controlColumns, control.getPartitionsPredicate());
            controlChecksumQueryContext.setChecksumQuery(DataVerification.formatSql((Statement)controlChecksumQuery));
            QueryResult controlChecksum = VerifierUtil.callAndConsume(() -> this.getHelperAction().execute((Statement)controlChecksumQuery, QueryStage.CONTROL_CHECKSUM, ChecksumResult::fromResultSet), stats -> stats.getQueryStats().map(QueryStats::getQueryId).ifPresent(controlChecksumQueryContext::setChecksumQueryId));
            controlChecksumResult = (ChecksumResult)Iterables.getOnlyElement(controlChecksum.getResults());
            if (this.saveSnapshot) {
                String snapshot = ChecksumResult.toJson(controlChecksumResult);
                this.snapshotQueryConsumer.accept(new SnapshotQuery(this.getSourceQuery().getSuite(), this.getSourceQuery().getName(), this.isExplain, snapshot));
                return new DataMatchResult(DataMatchResult.DataType.DATA, DataMatchResult.MatchType.MATCH, Optional.empty(), OptionalLong.empty(), OptionalLong.empty(), (List<ColumnMatchResult<?>>)ImmutableList.of());
            }
        } else if ("query-bank".equals(this.runningMode)) {
            controlColumns = testColumns;
            String key = String.format("SUITE_%s_@TEST_%s_@EXPLAIN_%s", this.getSourceQuery().getSuite(), this.getSourceQuery().getName(), this.isExplain);
            SnapshotQuery snapshotQuery = (SnapshotQuery)this.snapshotQueries.get(key);
            if (snapshotQuery != null) {
                String snapshotJson = snapshotQuery.getSnapshot();
                controlChecksumResult = ChecksumResult.fromJson(snapshotJson);
            } else {
                return new DataMatchResult(DataMatchResult.DataType.DATA, DataMatchResult.MatchType.SNAPSHOT_DOES_NOT_EXIST, Optional.empty(), OptionalLong.empty(), OptionalLong.empty(), Collections.emptyList());
            }
        }
        QueryResult testChecksum = VerifierUtil.callAndConsume(() -> this.getHelperAction().execute((Statement)testChecksumQuery, QueryStage.TEST_CHECKSUM, ChecksumResult::fromResultSet), stats -> stats.getQueryStats().map(QueryStats::getQueryId).ifPresent(testChecksumQueryContext::setChecksumQueryId));
        ChecksumResult testChecksumResult = (ChecksumResult)Iterables.getOnlyElement(testChecksum.getResults());
        return DataVerificationUtil.match(DataMatchResult.DataType.DATA, this.checksumValidator, controlColumns, testColumns, controlChecksumResult, testChecksumResult);
    }

    @Override
    protected DeterminismAnalysisDetails analyzeDeterminism(QueryObjectBundle control, DataMatchResult matchResult) {
        return this.determinismAnalyzer.analyze(control, matchResult.getControlChecksum());
    }

    @Override
    protected Optional<String> resolveFailure(Optional<QueryObjectBundle> control, Optional<QueryObjectBundle> test, AbstractVerification.QueryContext controlQueryContext, Optional<DataMatchResult> matchResult, Optional<Throwable> throwable) {
        if (matchResult.isPresent() && !matchResult.get().isMatched()) {
            Preconditions.checkState((boolean)control.isPresent(), (Object)"control is missing");
            return this.failureResolverManager.resolveResultMismatch(matchResult.get(), control.get());
        }
        if (throwable.isPresent() && ImmutableList.of((Object)((Object)QueryState.SUCCEEDED), (Object)((Object)QueryState.REUSE)).contains((Object)controlQueryContext.getState())) {
            Preconditions.checkState((boolean)controlQueryContext.getMainQueryStats().isPresent(), (Object)"controlQueryStats is missing");
            return this.failureResolverManager.resolveException(controlQueryContext.getMainQueryStats().get(), throwable.get(), test);
        }
        return Optional.empty();
    }
}

