/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.verifier.framework;

import com.facebook.airlift.concurrent.MoreFutures;
import com.facebook.airlift.log.Logger;
import com.facebook.presto.jdbc.QueryStats;
import com.facebook.presto.spi.StandardErrorCode;
import com.facebook.presto.sql.SqlFormatter;
import com.facebook.presto.sql.tree.Node;
import com.facebook.presto.sql.tree.Statement;
import com.facebook.presto.verifier.event.DeterminismAnalysisDetails;
import com.facebook.presto.verifier.event.QueryInfo;
import com.facebook.presto.verifier.event.VerifierQueryEvent;
import com.facebook.presto.verifier.framework.ChecksumQueryContext;
import com.facebook.presto.verifier.framework.ClusterType;
import com.facebook.presto.verifier.framework.DataVerificationUtil;
import com.facebook.presto.verifier.framework.DeterminismAnalysis;
import com.facebook.presto.verifier.framework.MatchResult;
import com.facebook.presto.verifier.framework.PrestoQueryException;
import com.facebook.presto.verifier.framework.QueryBundle;
import com.facebook.presto.verifier.framework.QueryConfiguration;
import com.facebook.presto.verifier.framework.QueryException;
import com.facebook.presto.verifier.framework.QueryObjectBundle;
import com.facebook.presto.verifier.framework.QueryResult;
import com.facebook.presto.verifier.framework.QueryStage;
import com.facebook.presto.verifier.framework.QueryState;
import com.facebook.presto.verifier.framework.SkippedReason;
import com.facebook.presto.verifier.framework.SnapshotQuery;
import com.facebook.presto.verifier.framework.SourceQuery;
import com.facebook.presto.verifier.framework.Verification;
import com.facebook.presto.verifier.framework.VerificationContext;
import com.facebook.presto.verifier.framework.VerificationResult;
import com.facebook.presto.verifier.framework.VerifierConfig;
import com.facebook.presto.verifier.framework.VerifierUtil;
import com.facebook.presto.verifier.prestoaction.PrestoAction;
import com.facebook.presto.verifier.prestoaction.QueryAction;
import com.facebook.presto.verifier.prestoaction.QueryActionStats;
import com.facebook.presto.verifier.prestoaction.QueryActions;
import com.facebook.presto.verifier.prestoaction.SqlExceptionClassifier;
import com.facebook.presto.verifier.source.SnapshotQueryConsumer;
import com.google.common.base.Preconditions;
import com.google.common.base.Strings;
import com.google.common.base.Throwables;
import com.google.common.collect.ImmutableList;
import com.google.common.util.concurrent.Futures;
import com.google.common.util.concurrent.ListeningExecutorService;
import java.lang.invoke.LambdaMetafactory;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.Callable;
import java.util.concurrent.Future;
import java.util.function.Consumer;

public abstract class AbstractVerification<B extends QueryBundle, R extends MatchResult, V>
implements Verification {
    private static final Logger LOG = Logger.get(AbstractVerification.class);
    private static final String INTERNAL_ERROR = "VERIFIER_INTERNAL_ERROR";
    private static final String SNAPSHOT_DOES_NOT_EXIST = "SNAPSHOT_DOES_NOT_EXIST";
    private final QueryActions queryActions;
    private final SourceQuery sourceQuery;
    private final SqlExceptionClassifier exceptionClassifier;
    private final VerificationContext verificationContext;
    private final Optional<PrestoAction.ResultSetConverter<V>> mainQueryResultSetConverter;
    private final ListeningExecutorService executor;
    private final String testId;
    private final boolean smartTeardown;
    private final int verificationResubmissionLimit;
    private final boolean setupOnMainClusters;
    private final boolean teardownOnMainClusters;
    protected final boolean skipControl;
    private final boolean skipChecksum;
    protected final String runningMode;
    protected final boolean saveSnapshot;
    protected final boolean isExplain;
    private final boolean concurrentControlAndTest;
    protected final SnapshotQueryConsumer snapshotQueryConsumer;
    protected final Map<String, SnapshotQuery> snapshotQueries;

    public AbstractVerification(QueryActions queryActions, SourceQuery sourceQuery, SqlExceptionClassifier exceptionClassifier, VerificationContext verificationContext, Optional<PrestoAction.ResultSetConverter<V>> mainQueryResultSetConverter, VerifierConfig verifierConfig, ListeningExecutorService executor, SnapshotQueryConsumer snapshotQueryConsumer, Map<String, SnapshotQuery> snapshotQueries) {
        this.queryActions = Objects.requireNonNull(queryActions, "queryActions is null");
        this.sourceQuery = Objects.requireNonNull(sourceQuery, "sourceQuery is null");
        this.exceptionClassifier = Objects.requireNonNull(exceptionClassifier, "exceptionClassifier is null");
        this.verificationContext = Objects.requireNonNull(verificationContext, "verificationContext is null");
        this.mainQueryResultSetConverter = Objects.requireNonNull(mainQueryResultSetConverter, "mainQueryResultSetConverter is null");
        this.executor = Objects.requireNonNull(executor, "executor is null");
        this.snapshotQueryConsumer = Objects.requireNonNull(snapshotQueryConsumer, "snapshotQueryConsumer is null");
        this.snapshotQueries = Objects.requireNonNull(snapshotQueries, "snapshotQuerySupplier is null");
        this.testId = Objects.requireNonNull(verifierConfig.getTestId(), "testId is null");
        this.smartTeardown = verifierConfig.isSmartTeardown();
        this.verificationResubmissionLimit = verifierConfig.getVerificationResubmissionLimit();
        this.setupOnMainClusters = verifierConfig.isSetupOnMainClusters();
        this.teardownOnMainClusters = verifierConfig.isTeardownOnMainClusters();
        this.skipControl = verifierConfig.isSkipControl();
        this.skipChecksum = verifierConfig.isSkipChecksum();
        this.concurrentControlAndTest = verifierConfig.isConcurrentControlAndTest();
        this.runningMode = verifierConfig.getRunningMode();
        this.saveSnapshot = verifierConfig.isSaveSnapshot();
        this.isExplain = verifierConfig.isExplain();
    }

    protected abstract B getQueryRewrite(ClusterType var1);

    protected abstract R verify(B var1, B var2, Optional<QueryResult<V>> var3, Optional<QueryResult<V>> var4, ChecksumQueryContext var5, ChecksumQueryContext var6);

    protected abstract DeterminismAnalysisDetails analyzeDeterminism(B var1, R var2);

    protected abstract Optional<String> resolveFailure(Optional<B> var1, Optional<B> var2, QueryContext var3, Optional<R> var4, Optional<Throwable> var5);

    protected void updateQueryInfo(QueryInfo.Builder queryInfo, Optional<QueryResult<V>> queryResult) {
    }

    protected void updateQueryInfoWithQueryBundle(QueryInfo.Builder queryInfo, Optional<B> queryBundle) {
        queryInfo.setQuery(queryBundle.map(QueryBundle::getQuery).map(AbstractVerification::formatSql)).setSetupQueries(queryBundle.map(QueryBundle::getSetupQueries).map(AbstractVerification::formatSqls)).setTeardownQueries(queryBundle.map(QueryBundle::getTeardownQueries).map(AbstractVerification::formatSqls));
    }

    protected PrestoAction getHelperAction() {
        return this.queryActions.getHelperAction();
    }

    protected boolean isControlEnabled() {
        return !this.skipControl || this.saveSnapshot;
    }

    @Override
    public SourceQuery getSourceQuery() {
        return this.sourceQuery;
    }

    @Override
    public VerificationContext getVerificationContext() {
        return this.verificationContext;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     * Could not resolve type clashes
     */
    @Override
    public VerificationResult run() {
        block26: {
            block29: {
                control /* !! */  = Optional.empty();
                test = Optional.empty();
                controlQueryResult = Optional.empty();
                testQueryResult = Optional.empty();
                controlQueryContext = new QueryContext();
                testQueryContext = new QueryContext();
                controlChecksumQueryContext = new ChecksumQueryContext();
                testChecksumQueryContext = new ChecksumQueryContext();
                matchResult = Optional.empty();
                determinismAnalysisDetails = Optional.empty();
                controlReuseTable = false;
                testReuseTable = false;
                partialResult = Optional.empty();
                throwable = Optional.empty();
                if (this.isControlEnabled()) {
                    control /* !! */  = Optional.of(this.getQueryRewrite(ClusterType.CONTROL));
                    v0 = controlReuseTable = control /* !! */ .isPresent() != false && control /* !! */ .get() instanceof QueryObjectBundle != false && ((QueryObjectBundle)control /* !! */ .get()).isReuseTable() != false;
                    if (controlReuseTable) {
                        controlQueryContext.setState(QueryState.REUSE);
                        controlQueryContext.setMainQueryStats(QueryActionStats.queryIdStats(this.sourceQuery.getQueryId(ClusterType.CONTROL).get()));
                    }
                }
                v1 = testReuseTable = (test = Optional.of(this.getQueryRewrite(ClusterType.TEST))).isPresent() != false && test.get() instanceof QueryObjectBundle != false && ((QueryObjectBundle)test.get()).isReuseTable() != false;
                if (testReuseTable) {
                    testQueryContext.setState(QueryState.REUSE);
                    testQueryContext.setMainQueryStats(QueryActionStats.queryIdStats(this.sourceQuery.getQueryId(ClusterType.TEST).get()));
                }
                if (this.isControlEnabled() && !controlReuseTable) {
                    controlQueryBundle = (QueryBundle)control /* !! */ .get();
                    controlSetupAction = this.setupOnMainClusters != false ? this.queryActions.getControlAction() : this.queryActions.getHelperAction();
                    controlQueryBundle.getSetupQueries().forEach((Consumer<Statement>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)V, lambda$run$1(com.facebook.presto.verifier.prestoaction.QueryAction com.facebook.presto.verifier.framework.AbstractVerification$QueryContext com.facebook.presto.sql.tree.Statement ), (Lcom/facebook/presto/sql/tree/Statement;)V)((QueryAction)controlSetupAction, (QueryContext)controlQueryContext));
                }
                if (!testReuseTable) {
                    testQueryBundle = (QueryBundle)test.get();
                    testSetupAction = this.setupOnMainClusters != false ? this.queryActions.getTestAction() : this.queryActions.getHelperAction();
                    testQueryBundle.getSetupQueries().forEach((Consumer<Statement>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)V, lambda$run$3(com.facebook.presto.verifier.prestoaction.QueryAction com.facebook.presto.verifier.framework.AbstractVerification$QueryContext com.facebook.presto.sql.tree.Statement ), (Lcom/facebook/presto/sql/tree/Statement;)V)((QueryAction)testSetupAction, (QueryContext)testQueryContext));
                }
                controlQueryFuture = Futures.immediateFuture(Optional.empty());
                testQueryFuture = Futures.immediateFuture(Optional.empty());
                if (this.isControlEnabled() && !controlReuseTable) {
                    controlQueryBundle = (QueryBundle)control /* !! */ .get();
                    controlQueryFuture = this.executor.submit((Callable<Optional>)LambdaMetafactory.metafactory(null, null, null, ()Ljava/lang/Object;, lambda$run$4(com.facebook.presto.verifier.framework.QueryBundle com.facebook.presto.verifier.framework.AbstractVerification$QueryContext ), ()Ljava/util/Optional;)((AbstractVerification)this, (QueryBundle)controlQueryBundle, (QueryContext)controlQueryContext));
                }
                if (!this.concurrentControlAndTest) {
                    MoreFutures.getFutureValue((Future)controlQueryFuture);
                }
                if (!testReuseTable) {
                    testQueryBundle = (QueryBundle)test.get();
                    testQueryFuture = this.executor.submit((Callable<Optional>)LambdaMetafactory.metafactory(null, null, null, ()Ljava/lang/Object;, lambda$run$5(com.facebook.presto.verifier.framework.QueryBundle com.facebook.presto.verifier.framework.AbstractVerification$QueryContext ), ()Ljava/util/Optional;)((AbstractVerification)this, (QueryBundle)testQueryBundle, (QueryContext)testQueryContext));
                }
                controlQueryResult = (Optional)MoreFutures.getFutureValue((Future)controlQueryFuture);
                if ("query-bank".equals(this.runningMode) && !this.saveSnapshot) {
                    controlQueryContext.setState(QueryState.SUCCEEDED);
                    controlQueryContext.setMainQueryStats(QueryActionStats.EMPTY_STATS);
                } else if (!this.skipControl || "query-bank".equals(this.runningMode)) {
                    if (!controlReuseTable) {
                        controlQueryContext.setState(QueryState.SUCCEEDED);
                    }
                } else {
                    controlQueryContext.setState(QueryState.NOT_RUN);
                }
                testQueryResult = (Optional)MoreFutures.getFutureValue((Future)testQueryFuture);
                if (!testReuseTable) {
                    testQueryContext.setState(QueryState.SUCCEEDED);
                }
                if (!"query-bank".equals(this.runningMode) || this.saveSnapshot || this.skipChecksum) break block29;
                control /* !! */  = test;
                matchResult = Optional.of(this.verify((QueryBundle)control /* !! */ .get(), (QueryBundle)test.get(), controlQueryResult, testQueryResult, controlChecksumQueryContext, testChecksumQueryContext));
                ** GOTO lbl84
            }
            if (!this.isControlEnabled() || this.skipChecksum) ** GOTO lbl84
            matchResult = Optional.of(this.verify((QueryBundle)control /* !! */ .get(), (QueryBundle)test.get(), controlQueryResult, testQueryResult, controlChecksumQueryContext, testChecksumQueryContext));
            if ("query-bank".equals(this.runningMode)) ** GOTO lbl84
            if (!controlReuseTable && !testReuseTable || !((MatchResult)matchResult.get()).isMismatchPossiblyCausedByReuseOutdatedTable() || this.verificationContext.getResubmissionCount() >= this.verificationResubmissionLimit) break block26;
            testQueryBundle = new VerificationResult(this, true, Optional.empty());
            if (!this.smartTeardown || !ImmutableList.of((Object)QueryState.SUCCEEDED, (Object)QueryState.REUSE).contains((Object)testQueryContext.getState()) || partialResult.isPresent() && ((PartialVerificationResult)partialResult.get()).getStatus().equals((Object)VerifierQueryEvent.EventStatus.SUCCEEDED)) {
                controlTeardownAction = this.teardownOnMainClusters != false ? this.queryActions.getControlAction() : this.queryActions.getHelperAction();
                testTeardownAction = this.teardownOnMainClusters != false ? this.queryActions.getTestAction() : this.queryActions.getHelperAction();
                DataVerificationUtil.teardownSafely(controlTeardownAction, control /* !! */ , (Consumer<QueryActionStats>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)V, addTeardownQuery(com.facebook.presto.verifier.prestoaction.QueryActionStats ), (Lcom/facebook/presto/verifier/prestoaction/QueryActionStats;)V)((QueryContext)controlQueryContext));
                DataVerificationUtil.teardownSafely(testTeardownAction, test, (Consumer<QueryActionStats>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)V, addTeardownQuery(com.facebook.presto.verifier.prestoaction.QueryActionStats ), (Lcom/facebook/presto/verifier/prestoaction/QueryActionStats;)V)((QueryContext)testQueryContext));
            }
            return testQueryBundle;
        }
        try {
            if (((MatchResult)matchResult.get()).isMismatchPossiblyCausedByNonDeterminism()) {
                determinismAnalysisDetails = Optional.of(this.analyzeDeterminism((QueryBundle)control /* !! */ .get(), (MatchResult)matchResult.get()));
            }
lbl84:
            // 6 sources

            partialResult = Optional.of(this.concludeVerificationPartial(control /* !! */ , test, controlQueryContext, testQueryContext, matchResult, determinismAnalysisDetails, Optional.empty()));
        }
        catch (Throwable t) {
            block27: {
                try {
                    if (!this.exceptionClassifier.shouldResubmit(t) || this.verificationContext.getResubmissionCount() >= this.verificationResubmissionLimit) break block27;
                    AbstractVerification.LOG.info("Error during verification: %s", new Object[]{t});
                    testTeardownAction = new VerificationResult(this, true, Optional.empty());
                }
                catch (Throwable var20_23) {
                    if (!this.smartTeardown || !ImmutableList.of((Object)QueryState.SUCCEEDED, (Object)QueryState.REUSE).contains((Object)testQueryContext.getState()) || partialResult.isPresent() && ((PartialVerificationResult)partialResult.get()).getStatus().equals((Object)VerifierQueryEvent.EventStatus.SUCCEEDED)) {
                        controlTeardownAction = this.teardownOnMainClusters != false ? this.queryActions.getControlAction() : this.queryActions.getHelperAction();
                        testTeardownAction = this.teardownOnMainClusters != false ? this.queryActions.getTestAction() : this.queryActions.getHelperAction();
                        DataVerificationUtil.teardownSafely(controlTeardownAction, control /* !! */ , (Consumer<QueryActionStats>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)V, addTeardownQuery(com.facebook.presto.verifier.prestoaction.QueryActionStats ), (Lcom/facebook/presto/verifier/prestoaction/QueryActionStats;)V)((QueryContext)controlQueryContext));
                        DataVerificationUtil.teardownSafely(testTeardownAction, test, (Consumer<QueryActionStats>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)V, addTeardownQuery(com.facebook.presto.verifier.prestoaction.QueryActionStats ), (Lcom/facebook/presto/verifier/prestoaction/QueryActionStats;)V)((QueryContext)testQueryContext));
                    }
                    throw var20_23;
                }
                if (!this.smartTeardown || !ImmutableList.of((Object)QueryState.SUCCEEDED, (Object)QueryState.REUSE).contains((Object)testQueryContext.getState()) || partialResult.isPresent() && ((PartialVerificationResult)partialResult.get()).getStatus().equals((Object)VerifierQueryEvent.EventStatus.SUCCEEDED)) {
                    controlTeardownAction = this.teardownOnMainClusters != false ? this.queryActions.getControlAction() : this.queryActions.getHelperAction();
                    testTeardownAction = this.teardownOnMainClusters != false ? this.queryActions.getTestAction() : this.queryActions.getHelperAction();
                    DataVerificationUtil.teardownSafely(controlTeardownAction, control /* !! */ , (Consumer<QueryActionStats>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)V, addTeardownQuery(com.facebook.presto.verifier.prestoaction.QueryActionStats ), (Lcom/facebook/presto/verifier/prestoaction/QueryActionStats;)V)((QueryContext)controlQueryContext));
                    DataVerificationUtil.teardownSafely(testTeardownAction, test, (Consumer<QueryActionStats>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)V, addTeardownQuery(com.facebook.presto.verifier.prestoaction.QueryActionStats ), (Lcom/facebook/presto/verifier/prestoaction/QueryActionStats;)V)((QueryContext)testQueryContext));
                }
                return testTeardownAction;
            }
            throwable = Optional.of(t);
            partialResult = Optional.of(this.concludeVerificationPartial(control /* !! */ , test, controlQueryContext, testQueryContext, matchResult, determinismAnalysisDetails, Optional.of(t)));
            if (!this.smartTeardown || !ImmutableList.of((Object)QueryState.SUCCEEDED, (Object)QueryState.REUSE).contains((Object)testQueryContext.getState()) || partialResult.isPresent() && ((PartialVerificationResult)partialResult.get()).getStatus().equals((Object)VerifierQueryEvent.EventStatus.SUCCEEDED)) {
                controlTeardownAction = this.teardownOnMainClusters != false ? this.queryActions.getControlAction() : this.queryActions.getHelperAction();
                testTeardownAction = this.teardownOnMainClusters != false ? this.queryActions.getTestAction() : this.queryActions.getHelperAction();
                DataVerificationUtil.teardownSafely(controlTeardownAction, control /* !! */ , (Consumer<QueryActionStats>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)V, addTeardownQuery(com.facebook.presto.verifier.prestoaction.QueryActionStats ), (Lcom/facebook/presto/verifier/prestoaction/QueryActionStats;)V)((QueryContext)controlQueryContext));
                DataVerificationUtil.teardownSafely((QueryAction)testTeardownAction, test, (Consumer<QueryActionStats>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)V, addTeardownQuery(com.facebook.presto.verifier.prestoaction.QueryActionStats ), (Lcom/facebook/presto/verifier/prestoaction/QueryActionStats;)V)((QueryContext)testQueryContext));
            } else {
                ** GOTO lbl143
            }
        }
        if (!this.smartTeardown || !ImmutableList.of((Object)QueryState.SUCCEEDED, (Object)QueryState.REUSE).contains((Object)testQueryContext.getState()) || partialResult.isPresent() && ((PartialVerificationResult)partialResult.get()).getStatus().equals((Object)VerifierQueryEvent.EventStatus.SUCCEEDED)) {
            controlTeardownAction = this.teardownOnMainClusters != false ? this.queryActions.getControlAction() : this.queryActions.getHelperAction();
            testTeardownAction = this.teardownOnMainClusters != false ? this.queryActions.getTestAction() : this.queryActions.getHelperAction();
            DataVerificationUtil.teardownSafely(controlTeardownAction, control /* !! */ , (Consumer<QueryActionStats>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)V, addTeardownQuery(com.facebook.presto.verifier.prestoaction.QueryActionStats ), (Lcom/facebook/presto/verifier/prestoaction/QueryActionStats;)V)((QueryContext)controlQueryContext));
            DataVerificationUtil.teardownSafely((QueryAction)testTeardownAction, test, (Consumer<QueryActionStats>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)V, addTeardownQuery(com.facebook.presto.verifier.prestoaction.QueryActionStats ), (Lcom/facebook/presto/verifier/prestoaction/QueryActionStats;)V)((QueryContext)testQueryContext));
        }
        return this.concludeVerification((PartialVerificationResult)partialResult.get(), control /* !! */ , test, controlQueryResult, testQueryResult, controlQueryContext, testQueryContext, matchResult, controlChecksumQueryContext, testChecksumQueryContext, determinismAnalysisDetails, throwable);
    }

    private Optional<QueryResult<V>> runMainQuery(Statement statement, ClusterType clusterType, QueryContext queryContext) {
        Preconditions.checkArgument((clusterType == ClusterType.CONTROL || clusterType == ClusterType.TEST ? 1 : 0) != 0, (String)"Invalid ClusterType: %s", (Object)((Object)clusterType));
        if (this.mainQueryResultSetConverter.isPresent()) {
            return Optional.of(VerifierUtil.callAndConsume(() -> ((PrestoAction)this.queryActions.getQueryAction(clusterType)).execute(statement, clusterType == ClusterType.CONTROL ? QueryStage.CONTROL_MAIN : QueryStage.TEST_MAIN, this.mainQueryResultSetConverter.get()), queryContext::setMainQueryStats, queryContext::setException));
        }
        VerifierUtil.runAndConsume(() -> this.queryActions.getQueryAction(clusterType).execute(statement, clusterType == ClusterType.CONTROL ? QueryStage.CONTROL_MAIN : QueryStage.TEST_MAIN), queryContext::setMainQueryStats, queryContext::setException);
        return Optional.empty();
    }

    private VerifierQueryEvent.EventStatus getEventStatus(Optional<SkippedReason> skippedReason, Optional<String> resolveMessage, Optional<R> matchResult, QueryContext controlQueryContext, QueryContext testQueryContext) {
        if (skippedReason.isPresent() || matchResult.isPresent() && SNAPSHOT_DOES_NOT_EXIST.equals(((MatchResult)matchResult.get()).getMatchTypeName())) {
            return VerifierQueryEvent.EventStatus.SKIPPED;
        }
        if (resolveMessage.isPresent()) {
            return VerifierQueryEvent.EventStatus.FAILED_RESOLVED;
        }
        if (this.skipControl ? ImmutableList.of((Object)((Object)QueryState.SUCCEEDED), (Object)((Object)QueryState.REUSE)).contains((Object)testQueryContext.getState()) : (this.skipChecksum ? ImmutableList.of((Object)((Object)QueryState.SUCCEEDED), (Object)((Object)QueryState.REUSE)).contains((Object)testQueryContext.getState()) && ImmutableList.of((Object)((Object)QueryState.SUCCEEDED), (Object)((Object)QueryState.REUSE)).contains((Object)controlQueryContext.getState()) : matchResult.isPresent() && ((MatchResult)matchResult.get()).isMatched())) {
            return VerifierQueryEvent.EventStatus.SUCCEEDED;
        }
        return VerifierQueryEvent.EventStatus.FAILED;
    }

    private PartialVerificationResult concludeVerificationPartial(Optional<B> control, Optional<B> test, QueryContext controlQueryContext, QueryContext testQueryContext, Optional<R> matchResult, Optional<DeterminismAnalysisDetails> determinismAnalysisDetails, Optional<Throwable> throwable) {
        Optional<SkippedReason> skippedReason = this.getSkippedReason(throwable, controlQueryContext.getState(), determinismAnalysisDetails.map(DeterminismAnalysisDetails::getDeterminismAnalysis));
        Optional<String> resolveMessage = this.resolveFailure(control, test, controlQueryContext, matchResult, throwable);
        VerifierQueryEvent.EventStatus status = this.getEventStatus(skippedReason, resolveMessage, matchResult, controlQueryContext, testQueryContext);
        return new PartialVerificationResult(skippedReason, resolveMessage, status);
    }

    private VerificationResult concludeVerification(PartialVerificationResult partialResult, Optional<B> control, Optional<B> test, Optional<QueryResult<V>> controlQueryResult, Optional<QueryResult<V>> testQueryResult, QueryContext controlQueryContext, QueryContext testQueryContext, Optional<R> matchResult, ChecksumQueryContext controlChecksumQueryContext, ChecksumQueryContext testChecksumQueryContext, Optional<DeterminismAnalysisDetails> determinismAnalysisDetails, Optional<Throwable> throwable) {
        Optional<String> errorCode = Optional.empty();
        Optional<String> errorMessage = Optional.empty();
        if (partialResult.getStatus() != VerifierQueryEvent.EventStatus.SUCCEEDED) {
            errorCode = Optional.ofNullable(throwable.map(t -> t instanceof QueryException ? ((QueryException)t).getErrorCodeName() : INTERNAL_ERROR).orElse(matchResult.map(MatchResult::getMatchTypeName).orElse(null)));
            errorMessage = Optional.of(this.constructErrorMessage(throwable, matchResult, controlQueryContext.getState(), testQueryContext.getState()));
        }
        VerifierQueryEvent event = new VerifierQueryEvent(this.sourceQuery.getSuite(), this.testId, this.sourceQuery.getName(), partialResult.getStatus(), matchResult.map(MatchResult::getDataType), matchResult.map(MatchResult::getMatchTypeName), partialResult.getSkippedReason(), determinismAnalysisDetails, partialResult.getResolveMessage(), this.skipControl ? Optional.empty() : Optional.of(this.buildQueryInfo(this.sourceQuery.getControlConfiguration(), this.sourceQuery.getQuery(ClusterType.CONTROL), controlChecksumQueryContext, control, controlQueryContext, controlQueryResult)), this.buildQueryInfo(this.sourceQuery.getTestConfiguration(), this.sourceQuery.getQuery(ClusterType.TEST), testChecksumQueryContext, test, testQueryContext, testQueryResult), errorCode, errorMessage, throwable.filter(QueryException.class::isInstance).map(QueryException.class::cast).map(QueryException::toQueryFailure), this.verificationContext.getQueryFailures(), this.verificationContext.getResubmissionCount());
        return new VerificationResult(this, false, Optional.of(event));
    }

    private QueryInfo buildQueryInfo(QueryConfiguration configuration, String originalQuery, ChecksumQueryContext checksumQueryContext, Optional<B> queryBundle, QueryContext queryContext, Optional<QueryResult<V>> queryResult) {
        QueryInfo.Builder queryInfo = QueryInfo.builder(configuration.getCatalog(), configuration.getSchema(), originalQuery, configuration.getSessionProperties()).setSetupQueryIds(queryContext.getSetupQueryIds()).setTeardownQueryIds(queryContext.getTeardownQueryIds()).setChecksumQueryId(checksumQueryContext.getChecksumQueryId()).setChecksumQuery(checksumQueryContext.getChecksumQuery()).setPartitionChecksumQueryId(checksumQueryContext.getPartitionChecksumQueryId()).setPartitionChecksumQuery(checksumQueryContext.getPartitionChecksumQuery()).setBucketChecksumQueryId(checksumQueryContext.getBucketChecksumQueryId()).setBucketChecksumQuery(checksumQueryContext.getBucketChecksumQuery()).setQueryActionStats(queryContext.getMainQueryStats());
        this.updateQueryInfoWithQueryBundle(queryInfo, queryBundle);
        this.updateQueryInfo(queryInfo, queryResult);
        return queryInfo.build();
    }

    protected static String formatSql(Statement statement) {
        return SqlFormatter.formatSql((Node)statement, Optional.empty());
    }

    protected static String formatSql(Statement statement, Optional<String> comment) {
        return comment.isPresent() ? AbstractVerification.formatSql(statement) + "\n-- " + comment.get() : AbstractVerification.formatSql(statement);
    }

    protected static List<String> formatSqls(List<Statement> statements) {
        return (List)statements.stream().map(AbstractVerification::formatSql).collect(ImmutableList.toImmutableList());
    }

    private Optional<SkippedReason> getSkippedReason(Optional<Throwable> throwable, QueryState controlState, Optional<DeterminismAnalysis> determinismAnalysis) {
        if (throwable.isPresent() && !(throwable.get() instanceof QueryException)) {
            return Optional.of(SkippedReason.VERIFIER_INTERNAL_ERROR);
        }
        if (this.skipControl && !"query-bank".equals(this.runningMode)) {
            return Optional.empty();
        }
        switch (controlState) {
            case FAILED: {
                return Optional.of(SkippedReason.CONTROL_QUERY_FAILED);
            }
            case FAILED_TO_SETUP: {
                return Optional.of(SkippedReason.CONTROL_SETUP_QUERY_FAILED);
            }
            case TIMED_OUT: {
                return Optional.of(SkippedReason.CONTROL_QUERY_TIMED_OUT);
            }
            case NOT_RUN: {
                return Optional.of(SkippedReason.FAILED_BEFORE_CONTROL_QUERY);
            }
        }
        if (determinismAnalysis.isPresent() && determinismAnalysis.get().isNonDeterministic()) {
            return Optional.of(SkippedReason.NON_DETERMINISTIC);
        }
        return Optional.empty();
    }

    private static QueryState getFailingQueryState(QueryException queryException) {
        QueryStage queryStage = queryException.getQueryStage();
        Preconditions.checkArgument((queryStage.isSetup() || queryStage.isMain() ? 1 : 0) != 0, (String)"Expect QueryStage SETUP or MAIN: %s", (Object)((Object)queryStage));
        if (queryStage.isSetup()) {
            return QueryState.FAILED_TO_SETUP;
        }
        return queryException instanceof PrestoQueryException && ((PrestoQueryException)queryException).getErrorCode().equals(Optional.of(StandardErrorCode.EXCEEDED_TIME_LIMIT)) ? QueryState.TIMED_OUT : QueryState.FAILED;
    }

    private String constructErrorMessage(Optional<Throwable> throwable, Optional<R> matchResult, QueryState controlState, QueryState testState) {
        StringBuilder message = new StringBuilder(String.format("Test state %s, Control state %s.%n%n", new Object[]{testState, controlState}));
        if (throwable.isPresent()) {
            if (throwable.get() instanceof PrestoQueryException) {
                PrestoQueryException exception = (PrestoQueryException)throwable.get();
                message.append(exception.getQueryStage().name().replace("_", " ")).append(" query failed on ").append((Object)exception.getQueryStage().getTargetCluster()).append(" cluster:\n").append(exception.getCause() == null ? Strings.nullToEmpty((String)exception.getMessage()) : Throwables.getStackTraceAsString((Throwable)exception.getCause()));
            } else {
                message.append(Throwables.getStackTraceAsString((Throwable)throwable.get()));
            }
        }
        matchResult.ifPresent(result -> message.append(result.getReport()));
        return message.toString();
    }

    private /* synthetic */ Optional lambda$run$5(QueryBundle testQueryBundle, QueryContext testQueryContext) throws Exception {
        return this.runMainQuery(testQueryBundle.getQuery(), ClusterType.TEST, testQueryContext);
    }

    private /* synthetic */ Optional lambda$run$4(QueryBundle controlQueryBundle, QueryContext controlQueryContext) throws Exception {
        return this.runMainQuery(controlQueryBundle.getQuery(), ClusterType.CONTROL, controlQueryContext);
    }

    private static /* synthetic */ void lambda$run$3(QueryAction testSetupAction, QueryContext testQueryContext, Statement query) {
        VerifierUtil.runAndConsume(() -> testSetupAction.execute(query, QueryStage.TEST_SETUP), testQueryContext::addSetupQuery, testQueryContext::setException);
    }

    private static /* synthetic */ void lambda$run$1(QueryAction controlSetupAction, QueryContext controlQueryContext, Statement query) {
        VerifierUtil.runAndConsume(() -> controlSetupAction.execute(query, QueryStage.CONTROL_SETUP), controlQueryContext::addSetupQuery, controlQueryContext::setException);
    }

    private static class PartialVerificationResult {
        private final Optional<SkippedReason> skippedReason;
        private final Optional<String> resolveMessage;
        private final VerifierQueryEvent.EventStatus status;

        public PartialVerificationResult(Optional<SkippedReason> skippedReason, Optional<String> resolveMessage, VerifierQueryEvent.EventStatus status) {
            this.skippedReason = Objects.requireNonNull(skippedReason, "skippedReason is null");
            this.resolveMessage = Objects.requireNonNull(resolveMessage, "resolveMessage is null");
            this.status = Objects.requireNonNull(status, "status is null");
        }

        public Optional<SkippedReason> getSkippedReason() {
            return this.skippedReason;
        }

        public Optional<String> getResolveMessage() {
            return this.resolveMessage;
        }

        public VerifierQueryEvent.EventStatus getStatus() {
            return this.status;
        }
    }

    protected static class QueryContext {
        private Optional<QueryActionStats> mainQueryStats = Optional.empty();
        private Optional<QueryState> state = Optional.empty();
        private ImmutableList.Builder<String> setupQueryIds = ImmutableList.builder();
        private ImmutableList.Builder<String> teardownQueryIds = ImmutableList.builder();

        protected QueryContext() {
        }

        public Optional<QueryActionStats> getMainQueryStats() {
            return this.mainQueryStats;
        }

        public void setMainQueryStats(QueryActionStats mainQueryStats) {
            Preconditions.checkState((!this.mainQueryStats.isPresent() ? 1 : 0) != 0, (String)"mainQueryStats is already set", (Object)mainQueryStats);
            this.mainQueryStats = Optional.of(mainQueryStats);
        }

        public QueryState getState() {
            return this.state.orElse(QueryState.NOT_RUN);
        }

        public void setState(QueryState state) {
            Preconditions.checkState((!this.state.isPresent() ? 1 : 0) != 0, (String)"state is already set", (Object)((Object)state));
            this.state = Optional.of(state);
        }

        public void setException(QueryException e) {
            this.setState(AbstractVerification.getFailingQueryState(e));
        }

        public List<String> getSetupQueryIds() {
            return this.setupQueryIds.build();
        }

        public void addSetupQuery(QueryActionStats queryActionStats) {
            queryActionStats.getQueryStats().map(QueryStats::getQueryId).ifPresent(arg_0 -> this.setupQueryIds.add(arg_0));
        }

        public List<String> getTeardownQueryIds() {
            return this.teardownQueryIds.build();
        }

        public void addTeardownQuery(QueryActionStats queryActionStats) {
            queryActionStats.getQueryStats().map(QueryStats::getQueryId).ifPresent(arg_0 -> this.teardownQueryIds.add(arg_0));
        }
    }
}

