/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.verifier.event;

import com.facebook.airlift.event.client.EventField;
import com.facebook.airlift.event.client.EventType;
import com.facebook.presto.verifier.event.DeterminismAnalysisDetails;
import com.facebook.presto.verifier.event.QueryFailure;
import com.facebook.presto.verifier.event.QueryInfo;
import com.facebook.presto.verifier.framework.ClusterType;
import com.facebook.presto.verifier.framework.SkippedReason;
import com.facebook.presto.verifier.framework.SourceQuery;
import com.google.common.collect.ImmutableList;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import javax.annotation.concurrent.Immutable;

@EventType(value="VerifierQuery")
@Immutable
public class VerifierQueryEvent {
    private final String suite;
    private final String testId;
    private final String name;
    private final String status;
    private final String dataType;
    private final String matchType;
    private final String skippedReason;
    private final String determinismAnalysis;
    private final DeterminismAnalysisDetails determinismAnalysisDetails;
    private final String resolveMessage;
    private final QueryInfo controlQueryInfo;
    private final QueryInfo testQueryInfo;
    private final String errorCode;
    private final String errorMessage;
    private final QueryFailure finalQueryFailure;
    private final List<QueryFailure> queryFailures;
    private final int resubmissionCount;

    public VerifierQueryEvent(String suite, String testId, String name, EventStatus status, Optional<String> dataType, Optional<String> matchType, Optional<SkippedReason> skippedReason, Optional<DeterminismAnalysisDetails> determinismAnalysisDetails, Optional<String> resolveMessage, Optional<QueryInfo> controlQueryInfo, QueryInfo testQueryInfo, Optional<String> errorCode, Optional<String> errorMessage, Optional<QueryFailure> finalQueryFailure, List<QueryFailure> queryFailures, int resubmissionCount) {
        this.suite = Objects.requireNonNull(suite, "suite is null");
        this.testId = Objects.requireNonNull(testId, "testId is null");
        this.name = Objects.requireNonNull(name, "name is null");
        this.status = status.name();
        this.dataType = dataType.orElse(null);
        this.matchType = matchType.orElse(null);
        this.skippedReason = skippedReason.map(Enum::name).orElse(null);
        this.determinismAnalysis = determinismAnalysisDetails.map(DeterminismAnalysisDetails::getResult).orElse(null);
        this.determinismAnalysisDetails = determinismAnalysisDetails.orElse(null);
        this.resolveMessage = resolveMessage.orElse(null);
        this.controlQueryInfo = controlQueryInfo.orElse(null);
        this.testQueryInfo = Objects.requireNonNull(testQueryInfo, "testQueryInfo is null");
        this.errorCode = errorCode.orElse(null);
        this.errorMessage = errorMessage.orElse(null);
        this.finalQueryFailure = finalQueryFailure.orElse(null);
        this.queryFailures = ImmutableList.copyOf(queryFailures);
        this.resubmissionCount = resubmissionCount;
    }

    public static VerifierQueryEvent skipped(String suite, String testId, SourceQuery sourceQuery, SkippedReason skippedReason, boolean skipControl) {
        return new VerifierQueryEvent(suite, testId, sourceQuery.getName(), EventStatus.SKIPPED, Optional.empty(), Optional.empty(), Optional.of(skippedReason), Optional.empty(), Optional.empty(), skipControl ? Optional.empty() : Optional.of(QueryInfo.builder(sourceQuery.getControlConfiguration().getCatalog(), sourceQuery.getControlConfiguration().getSchema(), sourceQuery.getQuery(ClusterType.CONTROL), sourceQuery.getControlConfiguration().getSessionProperties()).build()), QueryInfo.builder(sourceQuery.getTestConfiguration().getCatalog(), sourceQuery.getTestConfiguration().getSchema(), sourceQuery.getQuery(ClusterType.TEST), sourceQuery.getTestConfiguration().getSessionProperties()).build(), Optional.empty(), Optional.empty(), Optional.empty(), (List<QueryFailure>)ImmutableList.of(), 0);
    }

    @EventField
    public String getSuite() {
        return this.suite;
    }

    @EventField
    public String getTestId() {
        return this.testId;
    }

    @EventField
    public String getName() {
        return this.name;
    }

    @EventField
    public String getStatus() {
        return this.status;
    }

    @EventField
    public String getDataType() {
        return this.dataType;
    }

    @EventField
    public String getMatchType() {
        return this.matchType;
    }

    @EventField
    public String getSkippedReason() {
        return this.skippedReason;
    }

    @EventField
    public String getDeterminismAnalysis() {
        return this.determinismAnalysis;
    }

    @EventField
    public DeterminismAnalysisDetails getDeterminismAnalysisDetails() {
        return this.determinismAnalysisDetails;
    }

    @EventField
    public String getResolveMessage() {
        return this.resolveMessage;
    }

    @EventField
    public QueryInfo getControlQueryInfo() {
        return this.controlQueryInfo;
    }

    @EventField
    public QueryInfo getTestQueryInfo() {
        return this.testQueryInfo;
    }

    @EventField
    public String getErrorCode() {
        return this.errorCode;
    }

    @EventField
    public String getErrorMessage() {
        return this.errorMessage;
    }

    @EventField
    public QueryFailure getFinalQueryFailure() {
        return this.finalQueryFailure;
    }

    @EventField
    public List<QueryFailure> getQueryFailures() {
        return this.queryFailures;
    }

    @EventField
    public int getResubmissionCount() {
        return this.resubmissionCount;
    }

    public static enum EventStatus {
        SUCCEEDED,
        FAILED,
        FAILED_RESOLVED,
        SKIPPED,
        RESUBMITTED;

    }
}

