/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.verifier.checksum;

import com.facebook.presto.common.type.AbstractVarcharType;
import com.facebook.presto.common.type.DoubleType;
import com.facebook.presto.common.type.Type;
import com.facebook.presto.sql.tree.Cast;
import com.facebook.presto.sql.tree.Expression;
import com.facebook.presto.sql.tree.FunctionCall;
import com.facebook.presto.sql.tree.QualifiedName;
import com.facebook.presto.sql.tree.SingleColumn;
import com.facebook.presto.verifier.checksum.ChecksumResult;
import com.facebook.presto.verifier.checksum.ColumnMatchResult;
import com.facebook.presto.verifier.checksum.ColumnValidator;
import com.facebook.presto.verifier.checksum.ColumnValidatorUtil;
import com.facebook.presto.verifier.checksum.FloatingPointColumnChecksum;
import com.facebook.presto.verifier.checksum.FloatingPointColumnValidator;
import com.facebook.presto.verifier.checksum.SimpleColumnChecksum;
import com.facebook.presto.verifier.framework.Column;
import com.facebook.presto.verifier.framework.VerifierConfig;
import com.facebook.presto.verifier.framework.VerifierUtil;
import com.google.common.collect.ImmutableList;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import javax.inject.Inject;

public class SimpleColumnValidator
implements ColumnValidator {
    private final FloatingPointColumnValidator floatingPointValidator;
    private final boolean validateStringAsDouble;

    @Inject
    public SimpleColumnValidator(VerifierConfig config, FloatingPointColumnValidator floatingPointValidator) {
        this.floatingPointValidator = Objects.requireNonNull(floatingPointValidator, "floatingPointValidator is null");
        this.validateStringAsDouble = config.isValidateStringAsDouble();
    }

    @Override
    public List<SingleColumn> generateChecksumColumns(Column column) {
        ImmutableList.Builder columnsBuilder = ImmutableList.builder();
        FunctionCall checksum = new FunctionCall(QualifiedName.of((String)"checksum"), (List)ImmutableList.of((Object)column.getExpression()));
        columnsBuilder.add((Object)new SingleColumn((Expression)checksum, VerifierUtil.delimitedIdentifier(SimpleColumnValidator.getChecksumColumnAlias(column))));
        if (this.shouldValidateStringAsDouble(column)) {
            Column asDoubleColumn = SimpleColumnValidator.getAsDoubleColumn(column);
            columnsBuilder.addAll(this.floatingPointValidator.generateChecksumColumns(asDoubleColumn));
            columnsBuilder.addAll(ColumnValidatorUtil.generateNullCountColumns(column, asDoubleColumn));
        }
        return columnsBuilder.build();
    }

    public List<ColumnMatchResult<SimpleColumnChecksum>> validate(Column column, ChecksumResult controlResult, ChecksumResult testResult) {
        boolean isStringAsDouble = this.shouldValidateStringAsDouble(column) && ColumnValidatorUtil.isStringAsDoubleColumn(column, controlResult, testResult);
        SimpleColumnChecksum controlChecksum = SimpleColumnValidator.toColumnChecksum(column, controlResult, isStringAsDouble);
        SimpleColumnChecksum testChecksum = SimpleColumnValidator.toColumnChecksum(column, testResult, isStringAsDouble);
        if (isStringAsDouble) {
            Column asDoubleColumn = SimpleColumnValidator.getAsDoubleColumn(column);
            ColumnMatchResult<FloatingPointColumnChecksum> asDoubleMatchResult = this.floatingPointValidator.validate(asDoubleColumn, controlChecksum.getAsDoubleChecksum(), testChecksum.getAsDoubleChecksum());
            return ImmutableList.of(new ColumnMatchResult<SimpleColumnChecksum>(asDoubleMatchResult.isMatched(), column, asDoubleMatchResult.getMessage(), controlChecksum, testChecksum));
        }
        return ImmutableList.of(new ColumnMatchResult<SimpleColumnChecksum>(Objects.equals(controlChecksum, testChecksum), column, controlChecksum, testChecksum));
    }

    private static SimpleColumnChecksum toColumnChecksum(Column column, ChecksumResult checksumResult, boolean isStringAsDouble) {
        Object checksum = checksumResult.getChecksum(SimpleColumnValidator.getChecksumColumnAlias(column));
        if (isStringAsDouble) {
            Column asDoubleColumn = SimpleColumnValidator.getAsDoubleColumn(column);
            return new SimpleColumnChecksum(checksum, Optional.of(FloatingPointColumnValidator.toColumnChecksum(asDoubleColumn, checksumResult, checksumResult.getRowCount())));
        }
        return new SimpleColumnChecksum(checksum, Optional.empty());
    }

    private boolean shouldValidateStringAsDouble(Column column) {
        Type columnType = column.getType();
        return this.validateStringAsDouble && columnType instanceof AbstractVarcharType;
    }

    private static Column getAsDoubleColumn(Column column) {
        return Column.create(column.getName() + "_as_double", SimpleColumnValidator.getAsDoubleExpression(column), (Type)DoubleType.DOUBLE);
    }

    private static Expression getAsDoubleExpression(Column column) {
        return new Cast(column.getExpression(), DoubleType.DOUBLE.getDisplayName(), true, false);
    }

    private static String getChecksumColumnAlias(Column column) {
        return column.getName() + "$checksum";
    }
}

