/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.verifier.checksum;

import com.facebook.presto.verifier.checksum.ColumnChecksum;
import com.facebook.presto.verifier.checksum.FloatingPointColumnChecksum;
import com.google.common.base.Preconditions;
import java.util.Objects;
import java.util.Optional;
import javax.annotation.Nullable;

public class SimpleColumnChecksum
extends ColumnChecksum {
    private final Object checksum;
    private final Optional<FloatingPointColumnChecksum> asDoubleChecksum;

    public SimpleColumnChecksum(@Nullable Object checksum, Optional<FloatingPointColumnChecksum> asDoubleChecksum) {
        this.checksum = checksum;
        this.asDoubleChecksum = asDoubleChecksum;
    }

    @Nullable
    public Object getChecksum() {
        return this.checksum;
    }

    public FloatingPointColumnChecksum getAsDoubleChecksum() {
        Preconditions.checkArgument((boolean)this.asDoubleChecksum.isPresent(), (Object)"Expect as-double checksum to be present, but it is not");
        return this.asDoubleChecksum.get();
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        SimpleColumnChecksum o = (SimpleColumnChecksum)obj;
        return Objects.equals(this.checksum, o.checksum) && Objects.equals(this.asDoubleChecksum, o.asDoubleChecksum);
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.checksum, this.asDoubleChecksum);
    }

    @Override
    public String toString() {
        if (this.asDoubleChecksum.isPresent()) {
            return this.asDoubleChecksum.get().toString();
        }
        return String.format("checksum: %s", this.checksum);
    }
}

