/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.verifier.checksum;

import com.facebook.presto.common.type.AbstractVarcharType;
import com.facebook.presto.common.type.ArrayType;
import com.facebook.presto.common.type.DoubleType;
import com.facebook.presto.common.type.MapType;
import com.facebook.presto.common.type.RealType;
import com.facebook.presto.common.type.Type;
import com.facebook.presto.sql.QueryUtil;
import com.facebook.presto.sql.tree.CoalesceExpression;
import com.facebook.presto.sql.tree.Expression;
import com.facebook.presto.sql.tree.LongLiteral;
import com.facebook.presto.sql.tree.SingleColumn;
import com.facebook.presto.verifier.checksum.ArrayColumnValidator;
import com.facebook.presto.verifier.checksum.ChecksumResult;
import com.facebook.presto.verifier.checksum.ColumnMatchResult;
import com.facebook.presto.verifier.checksum.ColumnValidator;
import com.facebook.presto.verifier.checksum.ColumnValidatorUtil;
import com.facebook.presto.verifier.checksum.FloatingPointColumnChecksum;
import com.facebook.presto.verifier.checksum.FloatingPointColumnValidator;
import com.facebook.presto.verifier.checksum.MapColumnChecksum;
import com.facebook.presto.verifier.framework.Column;
import com.facebook.presto.verifier.framework.VerifierConfig;
import com.facebook.presto.verifier.framework.VerifierUtil;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import javax.inject.Inject;

public class MapColumnValidator
implements ColumnValidator {
    private final FloatingPointColumnValidator floatingPointValidator;
    private final boolean validateStringAsDouble;

    @Inject
    public MapColumnValidator(VerifierConfig config, FloatingPointColumnValidator floatingPointValidator) {
        this.floatingPointValidator = Objects.requireNonNull(floatingPointValidator, "floatingPointValidator is null");
        this.validateStringAsDouble = config.isValidateStringAsDouble();
    }

    @Override
    public List<SingleColumn> generateChecksumColumns(Column column) {
        Preconditions.checkArgument((boolean)(column.getType() instanceof MapType), (String)"Expect MapType, found %s", (Object)column.getType().getDisplayName());
        Type keyType = ((MapType)column.getType()).getKeyType();
        Type valueType = ((MapType)column.getType()).getValueType();
        ImmutableList.Builder builder = ImmutableList.builder();
        Expression checksum = QueryUtil.functionCall((String)"checksum", (Expression[])new Expression[]{column.getExpression()});
        Expression keysChecksum = ArrayColumnValidator.generateArrayChecksum(QueryUtil.functionCall((String)"map_keys", (Expression[])new Expression[]{column.getExpression()}), (Type)new ArrayType(keyType));
        Expression mapCardinalityChecksum = QueryUtil.functionCall((String)"checksum", (Expression[])new Expression[]{QueryUtil.functionCall((String)"cardinality", (Expression[])new Expression[]{column.getExpression()})});
        CoalesceExpression mapCardinalitySum = new CoalesceExpression(QueryUtil.functionCall((String)"sum", (Expression[])new Expression[]{QueryUtil.functionCall((String)"cardinality", (Expression[])new Expression[]{column.getExpression()})}), (Expression)new LongLiteral("0"), new Expression[0]);
        builder.add((Object)new SingleColumn(checksum, Optional.of(VerifierUtil.delimitedIdentifier(MapColumnValidator.getChecksumColumnAlias(column)))));
        builder.add((Object)new SingleColumn(keysChecksum, Optional.of(VerifierUtil.delimitedIdentifier(MapColumnValidator.getKeysChecksumColumnAlias(column)))));
        if ((MapColumnValidator.isFloatingPointType(keyType) || this.shouldValidateStringAsDouble(keyType)) && !MapColumnValidator.isFloatingPointType(valueType)) {
            Expression valuesChecksum = ArrayColumnValidator.generateArrayChecksum(QueryUtil.functionCall((String)"map_values", (Expression[])new Expression[]{column.getExpression()}), (Type)new ArrayType(valueType));
            builder.add((Object)new SingleColumn(valuesChecksum, Optional.of(VerifierUtil.delimitedIdentifier(MapColumnValidator.getValuesChecksumColumnAlias(column)))));
        }
        if (this.shouldValidateStringAsDouble(keyType)) {
            Column keysColumn = MapColumnValidator.getKeysColumn(column);
            builder.addAll(ArrayColumnValidator.generateStringArrayChecksumColumns(keysColumn));
        }
        if (this.shouldValidateStringAsDouble(valueType)) {
            Column valuesColumn = MapColumnValidator.getValuesColumn(column);
            builder.addAll(ArrayColumnValidator.generateStringArrayChecksumColumns(valuesColumn));
        }
        builder.add((Object)new SingleColumn(mapCardinalityChecksum, Optional.of(VerifierUtil.delimitedIdentifier(MapColumnValidator.getCardinalityChecksumColumnAlias(column)))));
        builder.add((Object)new SingleColumn((Expression)mapCardinalitySum, Optional.of(VerifierUtil.delimitedIdentifier(MapColumnValidator.getCardinalitySumColumnAlias(column)))));
        return builder.build();
    }

    public List<ColumnMatchResult<MapColumnChecksum>> validate(Column column, ChecksumResult controlResult, ChecksumResult testResult) {
        Preconditions.checkArgument((controlResult.getRowCount() == testResult.getRowCount() ? 1 : 0) != 0, (String)"Test row count (%s) does not match control row count (%s)", (long)testResult.getRowCount(), (long)controlResult.getRowCount());
        Type keyType = ((MapType)column.getType()).getKeyType();
        Type valueType = ((MapType)column.getType()).getValueType();
        Column keysColumn = MapColumnValidator.getKeysColumn(column);
        Column valuesColumn = MapColumnValidator.getValuesColumn(column);
        boolean isDoubleKeyAsString = this.shouldValidateStringAsDouble(keyType) && ColumnValidatorUtil.isStringAsDoubleColumn(keysColumn, controlResult, testResult);
        boolean isDoubleValueAsString = this.shouldValidateStringAsDouble(valueType) && ColumnValidatorUtil.isStringAsDoubleColumn(valuesColumn, controlResult, testResult);
        MapColumnChecksum controlChecksum = this.toColumnChecksum(column, controlResult, isDoubleKeyAsString, isDoubleValueAsString);
        MapColumnChecksum testChecksum = this.toColumnChecksum(column, testResult, isDoubleKeyAsString, isDoubleValueAsString);
        if (!isDoubleKeyAsString && !isDoubleValueAsString) {
            return ImmutableList.of(new ColumnMatchResult<MapColumnChecksum>(Objects.equals(controlChecksum, testChecksum), column, controlChecksum, testChecksum));
        }
        if (!Objects.equals(controlChecksum.getCardinalityChecksum(), testChecksum.getCardinalityChecksum()) || !Objects.equals(controlChecksum.getCardinalitySum(), testChecksum.getCardinalitySum())) {
            return ImmutableList.of(new ColumnMatchResult<MapColumnChecksum>(false, column, Optional.of("cardinality mismatch"), controlChecksum, testChecksum));
        }
        Optional<String> errorMessage = Optional.empty();
        boolean isKeyMatched = Objects.equals(controlChecksum.getKeysChecksum(), testChecksum.getKeysChecksum());
        if (isDoubleKeyAsString) {
            ColumnMatchResult<FloatingPointColumnChecksum> result = this.floatingPointValidator.validate(ArrayColumnValidator.getAsDoubleArrayColumn(keysColumn), controlChecksum.getKeysFloatingPointChecksum(), testChecksum.getKeysFloatingPointChecksum());
            boolean bl = isKeyMatched = isKeyMatched || result.isMatched();
            if (result.getMessage().isPresent()) {
                errorMessage = Optional.of("Map key " + result.getMessage().get());
            }
        }
        boolean isValueMatched = Objects.equals(controlChecksum.getValuesChecksum(), testChecksum.getValuesChecksum());
        if (isDoubleValueAsString) {
            ColumnMatchResult<FloatingPointColumnChecksum> result = this.floatingPointValidator.validate(ArrayColumnValidator.getAsDoubleArrayColumn(valuesColumn), controlChecksum.getValuesFloatingPointChecksum(), testChecksum.getValuesFloatingPointChecksum());
            boolean bl = isValueMatched = isValueMatched || result.isMatched();
            if (result.getMessage().isPresent()) {
                errorMessage = errorMessage.isPresent() ? Optional.of(errorMessage.get() + ", map value " + result.getMessage().get()) : Optional.of("Map value " + result.getMessage().get());
            }
        }
        return ImmutableList.of(new ColumnMatchResult<MapColumnChecksum>(isKeyMatched && isValueMatched, column, errorMessage, controlChecksum, testChecksum));
    }

    private MapColumnChecksum toColumnChecksum(Column column, ChecksumResult checksumResult, boolean isDoubleKeyAsString, boolean isDoubleValueAsString) {
        Type keyType = ((MapType)column.getType()).getKeyType();
        Type valueType = ((MapType)column.getType()).getValueType();
        Optional<FloatingPointColumnChecksum> keysFloatingPointChecksum = Optional.empty();
        if (isDoubleKeyAsString) {
            Column keysColumn = ArrayColumnValidator.getAsDoubleArrayColumn(MapColumnValidator.getKeysColumn(column));
            keysFloatingPointChecksum = Optional.of(FloatingPointColumnValidator.toColumnChecksum(keysColumn, checksumResult, checksumResult.getRowCount()));
        }
        Optional<FloatingPointColumnChecksum> valuesFloatingPointChecksum = Optional.empty();
        if (isDoubleValueAsString) {
            Column valuesColumn = ArrayColumnValidator.getAsDoubleArrayColumn(MapColumnValidator.getValuesColumn(column));
            valuesFloatingPointChecksum = Optional.of(FloatingPointColumnValidator.toColumnChecksum(valuesColumn, checksumResult, checksumResult.getRowCount()));
        }
        Object valuesChecksum = null;
        if ((MapColumnValidator.isFloatingPointType(keyType) || isDoubleKeyAsString) && !MapColumnValidator.isFloatingPointType(valueType)) {
            valuesChecksum = checksumResult.getChecksum(MapColumnValidator.getValuesChecksumColumnAlias(column));
        }
        if (checksumResult.getRowCount() == 0L) {
            return new MapColumnChecksum(null, null, null, keysFloatingPointChecksum, valuesFloatingPointChecksum, null, 0L);
        }
        return new MapColumnChecksum(checksumResult.getChecksum(MapColumnValidator.getChecksumColumnAlias(column)), checksumResult.getChecksum(MapColumnValidator.getKeysChecksumColumnAlias(column)), valuesChecksum, keysFloatingPointChecksum, valuesFloatingPointChecksum, checksumResult.getChecksum(MapColumnValidator.getCardinalityChecksumColumnAlias(column)), (Long)checksumResult.getChecksum(MapColumnValidator.getCardinalitySumColumnAlias(column)));
    }

    private boolean shouldValidateStringAsDouble(Type columnType) {
        return this.validateStringAsDouble && columnType instanceof AbstractVarcharType;
    }

    private static boolean isFloatingPointType(Type type) {
        return type instanceof DoubleType || type instanceof RealType;
    }

    private static Column getKeysColumn(Column column) {
        Preconditions.checkArgument((boolean)(column.getType() instanceof MapType), (String)"Expect MapType, found %s", (Object)column.getType().getDisplayName());
        Type keyType = ((MapType)column.getType()).getKeyType();
        return Column.create(column.getName() + "_key_array", QueryUtil.functionCall((String)"map_keys", (Expression[])new Expression[]{column.getExpression()}), (Type)new ArrayType(keyType));
    }

    private static Column getValuesColumn(Column column) {
        Preconditions.checkArgument((boolean)(column.getType() instanceof MapType), (String)"Expect MapType, found %s", (Object)column.getType().getDisplayName());
        Type valueType = ((MapType)column.getType()).getValueType();
        return Column.create(column.getName() + "_value_array", QueryUtil.functionCall((String)"map_values", (Expression[])new Expression[]{column.getExpression()}), (Type)new ArrayType(valueType));
    }

    private static String getChecksumColumnAlias(Column column) {
        return column.getName() + "$checksum";
    }

    private static String getKeysChecksumColumnAlias(Column column) {
        return column.getName() + "$keys_checksum";
    }

    private static String getValuesChecksumColumnAlias(Column column) {
        return column.getName() + "$values_checksum";
    }

    private static String getCardinalityChecksumColumnAlias(Column column) {
        return column.getName() + "$cardinality_checksum";
    }

    private static String getCardinalitySumColumnAlias(Column column) {
        return column.getName() + "$cardinality_sum";
    }
}

