/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.verifier.checksum;

import com.facebook.presto.verifier.checksum.FloatingPointColumnChecksum;
import com.facebook.presto.verifier.checksum.StructureColumnChecksum;
import com.google.common.base.Preconditions;
import java.util.Objects;
import java.util.Optional;
import javax.annotation.Nullable;

public class MapColumnChecksum
extends StructureColumnChecksum {
    private final Object checksum;
    private final Object keysChecksum;
    private final Object valuesChecksum;
    private final Optional<FloatingPointColumnChecksum> keysFloatingPointChecksum;
    private final Optional<FloatingPointColumnChecksum> valuesFloatingPointChecksum;
    private final Object cardinalityChecksum;
    private final long cardinalitySum;

    public MapColumnChecksum(@Nullable Object checksum, @Nullable Object keysChecksum, @Nullable Object valuesChecksum, Optional<FloatingPointColumnChecksum> keysFloatingPointChecksum, Optional<FloatingPointColumnChecksum> valuesFloatingPointChecksum, @Nullable Object cardinalityChecksum, long cardinalitySum) {
        this.checksum = checksum;
        this.keysChecksum = keysChecksum;
        this.valuesChecksum = valuesChecksum;
        this.keysFloatingPointChecksum = keysFloatingPointChecksum;
        this.valuesFloatingPointChecksum = valuesFloatingPointChecksum;
        this.cardinalityChecksum = cardinalityChecksum;
        this.cardinalitySum = cardinalitySum;
    }

    @Nullable
    public Object getChecksum() {
        return this.checksum;
    }

    @Nullable
    public Object getKeysChecksum() {
        return this.keysChecksum;
    }

    @Nullable
    public Object getValuesChecksum() {
        return this.valuesChecksum;
    }

    public FloatingPointColumnChecksum getKeysFloatingPointChecksum() {
        Preconditions.checkArgument((boolean)this.keysFloatingPointChecksum.isPresent(), (Object)"Expect Floating Point Checksum to be present, but it is not");
        return this.keysFloatingPointChecksum.get();
    }

    public FloatingPointColumnChecksum getValuesFloatingPointChecksum() {
        Preconditions.checkArgument((boolean)this.valuesFloatingPointChecksum.isPresent(), (Object)"Expect Floating Point Checksum to be present, but it is not");
        return this.valuesFloatingPointChecksum.get();
    }

    @Override
    @Nullable
    public Object getCardinalityChecksum() {
        return this.cardinalityChecksum;
    }

    @Override
    public long getCardinalitySum() {
        return this.cardinalitySum;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        MapColumnChecksum o = (MapColumnChecksum)obj;
        return Objects.equals(this.checksum, o.checksum) && Objects.equals(this.keysChecksum, o.keysChecksum) && Objects.equals(this.valuesChecksum, o.valuesChecksum) && Objects.equals(this.keysFloatingPointChecksum, o.keysFloatingPointChecksum) && Objects.equals(this.valuesFloatingPointChecksum, o.valuesFloatingPointChecksum) && Objects.equals(this.cardinalityChecksum, o.cardinalityChecksum) && Objects.equals(this.cardinalitySum, o.cardinalitySum);
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.checksum, this.keysChecksum, this.valuesChecksum, this.keysFloatingPointChecksum, this.valuesFloatingPointChecksum, this.cardinalityChecksum, this.cardinalitySum);
    }

    @Override
    public String toString() {
        String result = String.format("checksum: %s, cardinality_checksum: %s, cardinality_sum: %s", this.checksum, this.cardinalityChecksum, this.cardinalitySum);
        result = result + (this.keysFloatingPointChecksum.isPresent() ? "" : String.format(", keys_checksum: %s", this.keysChecksum));
        result = result + (this.valuesFloatingPointChecksum.isPresent() ? "" : String.format(", values_checksum: %s", this.valuesChecksum));
        result = result + (this.keysFloatingPointChecksum.isPresent() ? String.format(". [keys] %s", this.keysFloatingPointChecksum.get()) : "");
        result = result + (this.valuesFloatingPointChecksum.isPresent() ? String.format(". [values] %s", this.valuesFloatingPointChecksum.get()) : "");
        return result;
    }
}

