/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.verifier.checksum;

import com.facebook.presto.common.type.DoubleType;
import com.facebook.presto.sql.tree.ArithmeticUnaryExpression;
import com.facebook.presto.sql.tree.Cast;
import com.facebook.presto.sql.tree.ComparisonExpression;
import com.facebook.presto.sql.tree.Expression;
import com.facebook.presto.sql.tree.FunctionCall;
import com.facebook.presto.sql.tree.QualifiedName;
import com.facebook.presto.sql.tree.SingleColumn;
import com.facebook.presto.verifier.checksum.ChecksumResult;
import com.facebook.presto.verifier.checksum.ColumnMatchResult;
import com.facebook.presto.verifier.checksum.ColumnValidator;
import com.facebook.presto.verifier.checksum.FloatingPointColumnChecksum;
import com.facebook.presto.verifier.framework.Column;
import com.facebook.presto.verifier.framework.VerifierConfig;
import com.facebook.presto.verifier.framework.VerifierUtil;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import javax.inject.Inject;

public class FloatingPointColumnValidator
implements ColumnValidator {
    private final double relativeErrorMargin;
    private final double absoluteErrorMargin;

    @Inject
    public FloatingPointColumnValidator(VerifierConfig config) {
        this.relativeErrorMargin = config.getRelativeErrorMargin();
        this.absoluteErrorMargin = config.getAbsoluteErrorMargin();
    }

    @Override
    public List<SingleColumn> generateChecksumColumns(Column column) {
        Expression doubleColumn = column.getType().equals(DoubleType.DOUBLE) ? column.getExpression() : new Cast(column.getExpression(), DoubleType.DOUBLE.getDisplayName());
        FunctionCall positiveInfinity = new FunctionCall(QualifiedName.of((String)"infinity"), (List)ImmutableList.of());
        ArithmeticUnaryExpression negativeInfinity = new ArithmeticUnaryExpression(ArithmeticUnaryExpression.Sign.MINUS, (Expression)positiveInfinity);
        return ImmutableList.of((Object)new SingleColumn((Expression)new FunctionCall(QualifiedName.of((String)"sum"), Optional.empty(), Optional.of(new FunctionCall(QualifiedName.of((String)"is_finite"), (List)ImmutableList.of((Object)column.getExpression()))), Optional.empty(), false, (List)ImmutableList.of((Object)doubleColumn)), Optional.of(VerifierUtil.delimitedIdentifier(FloatingPointColumnValidator.getSumColumnAlias(column)))), (Object)new SingleColumn((Expression)new FunctionCall(QualifiedName.of((String)"count"), Optional.empty(), Optional.of(new FunctionCall(QualifiedName.of((String)"is_nan"), (List)ImmutableList.of((Object)column.getExpression()))), Optional.empty(), false, (List)ImmutableList.of((Object)column.getExpression())), Optional.of(VerifierUtil.delimitedIdentifier(FloatingPointColumnValidator.getNanCountColumnAlias(column)))), (Object)new SingleColumn((Expression)new FunctionCall(QualifiedName.of((String)"count"), Optional.empty(), Optional.of(new ComparisonExpression(ComparisonExpression.Operator.EQUAL, column.getExpression(), (Expression)positiveInfinity)), Optional.empty(), false, (List)ImmutableList.of((Object)column.getExpression())), Optional.of(VerifierUtil.delimitedIdentifier(FloatingPointColumnValidator.getPositiveInfinityCountColumnAlias(column)))), (Object)new SingleColumn((Expression)new FunctionCall(QualifiedName.of((String)"count"), Optional.empty(), Optional.of(new ComparisonExpression(ComparisonExpression.Operator.EQUAL, column.getExpression(), (Expression)negativeInfinity)), Optional.empty(), false, (List)ImmutableList.of((Object)column.getExpression())), Optional.of(VerifierUtil.delimitedIdentifier(FloatingPointColumnValidator.getNegativeInfinityCountColumnAlias(column)))));
    }

    public static FloatingPointColumnChecksum toColumnChecksum(Column column, ChecksumResult checksumResult, long rowCount) {
        Object nanCount = checksumResult.getChecksum(FloatingPointColumnValidator.getNanCountColumnAlias(column));
        if (Objects.isNull(nanCount)) {
            return new FloatingPointColumnChecksum(null, 0L, 0L, 0L, 0L);
        }
        return new FloatingPointColumnChecksum(checksumResult.getChecksum(FloatingPointColumnValidator.getSumColumnAlias(column)), (Long)nanCount, (Long)checksumResult.getChecksum(FloatingPointColumnValidator.getPositiveInfinityCountColumnAlias(column)), (Long)checksumResult.getChecksum(FloatingPointColumnValidator.getNegativeInfinityCountColumnAlias(column)), rowCount);
    }

    public List<ColumnMatchResult<FloatingPointColumnChecksum>> validate(Column column, ChecksumResult controlResult, ChecksumResult testResult) {
        Preconditions.checkArgument((controlResult.getRowCount() == testResult.getRowCount() ? 1 : 0) != 0, (String)"Test row count (%s) does not match control row count (%s)", (long)testResult.getRowCount(), (long)controlResult.getRowCount());
        long rowCount = controlResult.getRowCount();
        FloatingPointColumnChecksum controlChecksum = FloatingPointColumnValidator.toColumnChecksum(column, controlResult, rowCount);
        FloatingPointColumnChecksum testChecksum = FloatingPointColumnValidator.toColumnChecksum(column, testResult, rowCount);
        return ImmutableList.of(this.validate(column, controlChecksum, testChecksum));
    }

    public ColumnMatchResult<FloatingPointColumnChecksum> validate(Column column, FloatingPointColumnChecksum controlChecksum, FloatingPointColumnChecksum testChecksum) {
        if (!(Objects.equals(controlChecksum.getNanCount(), testChecksum.getNanCount()) && Objects.equals(controlChecksum.getPositiveInfinityCount(), testChecksum.getPositiveInfinityCount()) && Objects.equals(controlChecksum.getNegativeInfinityCount(), testChecksum.getNegativeInfinityCount()))) {
            return new ColumnMatchResult<FloatingPointColumnChecksum>(false, column, controlChecksum, testChecksum);
        }
        if (controlChecksum.getSum() == null || testChecksum.getSum() == null) {
            return new ColumnMatchResult<FloatingPointColumnChecksum>(controlChecksum.getSum() == null && testChecksum.getSum() == null, column, controlChecksum, testChecksum);
        }
        double controlSum = (Double)controlChecksum.getSum();
        double testSum = (Double)testChecksum.getSum();
        if (Double.isNaN(controlSum) || Double.isNaN(testSum) || Double.isInfinite(controlSum) || Double.isInfinite(testSum)) {
            return new ColumnMatchResult<FloatingPointColumnChecksum>(false, column, controlChecksum, testChecksum);
        }
        double controlMean = controlSum / (double)controlChecksum.getRowCount();
        double testMean = testSum / (double)testChecksum.getRowCount();
        if (Math.abs(controlMean) < this.absoluteErrorMargin || Math.abs(testMean) < this.absoluteErrorMargin) {
            return new ColumnMatchResult<FloatingPointColumnChecksum>(Math.abs(controlMean) < this.absoluteErrorMargin && Math.abs(testMean) < this.absoluteErrorMargin, column, controlChecksum, testChecksum);
        }
        double difference = Math.abs(controlSum - testSum);
        double relativeError = difference / Math.min((Math.abs(controlSum) + Math.abs(testSum)) / 2.0, Double.MAX_VALUE);
        return new ColumnMatchResult<FloatingPointColumnChecksum>(relativeError < this.relativeErrorMargin, column, Optional.of("relative error: " + relativeError), controlChecksum, testChecksum);
    }

    public static String getSumColumnAlias(Column column) {
        return column.getName() + "$sum";
    }

    public static String getNanCountColumnAlias(Column column) {
        return column.getName() + "$nan_count";
    }

    public static String getPositiveInfinityCountColumnAlias(Column column) {
        return column.getName() + "$pos_inf_count";
    }

    public static String getNegativeInfinityCountColumnAlias(Column column) {
        return column.getName() + "$neg_inf_count";
    }
}

