/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.verifier.checksum;

import com.facebook.airlift.log.Logger;
import com.facebook.presto.common.type.ArrayType;
import com.facebook.presto.sql.QueryUtil;
import com.facebook.presto.sql.tree.Expression;
import com.facebook.presto.sql.tree.IsNullPredicate;
import com.facebook.presto.sql.tree.LambdaArgumentDeclaration;
import com.facebook.presto.sql.tree.LambdaExpression;
import com.facebook.presto.sql.tree.SingleColumn;
import com.facebook.presto.verifier.checksum.ChecksumResult;
import com.facebook.presto.verifier.framework.Column;
import com.facebook.presto.verifier.framework.VerifierUtil;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import java.util.List;
import java.util.Objects;

public class ColumnValidatorUtil {
    private static final Logger LOG = Logger.get(ColumnValidatorUtil.class);

    private ColumnValidatorUtil() {
    }

    public static List<SingleColumn> generateNullCountColumns(Column column, Column asDoubleColumn) {
        if (column.getType() instanceof ArrayType) {
            Preconditions.checkArgument((boolean)(asDoubleColumn.getType() instanceof ArrayType), (String)"Expect ArrayType, found %s", (Object)asDoubleColumn.getType().getDisplayName());
            return ImmutableList.of((Object)new SingleColumn(QueryUtil.functionCall((String)"sum", (Expression[])new Expression[]{QueryUtil.functionCall((String)"cardinality", (Expression[])new Expression[]{QueryUtil.functionCall((String)"filter", (Expression[])new Expression[]{column.getExpression(), new LambdaExpression((List)ImmutableList.of((Object)new LambdaArgumentDeclaration(QueryUtil.identifier((String)"x"))), (Expression)new IsNullPredicate((Expression)QueryUtil.identifier((String)"x")))})})}), VerifierUtil.delimitedIdentifier(ColumnValidatorUtil.getNullCountColumnAlias(column))), (Object)new SingleColumn(QueryUtil.functionCall((String)"sum", (Expression[])new Expression[]{QueryUtil.functionCall((String)"cardinality", (Expression[])new Expression[]{QueryUtil.functionCall((String)"filter", (Expression[])new Expression[]{asDoubleColumn.getExpression(), new LambdaExpression((List)ImmutableList.of((Object)new LambdaArgumentDeclaration(QueryUtil.identifier((String)"x"))), (Expression)new IsNullPredicate((Expression)QueryUtil.identifier((String)"x")))})})}), VerifierUtil.delimitedIdentifier(ColumnValidatorUtil.getNullCountColumnAlias(asDoubleColumn))));
        }
        return ImmutableList.of((Object)new SingleColumn(QueryUtil.functionCall((String)"count_if", (Expression[])new Expression[]{new IsNullPredicate(column.getExpression())}), VerifierUtil.delimitedIdentifier(ColumnValidatorUtil.getNullCountColumnAlias(column))), (Object)new SingleColumn(QueryUtil.functionCall((String)"count_if", (Expression[])new Expression[]{new IsNullPredicate(asDoubleColumn.getExpression())}), VerifierUtil.delimitedIdentifier(ColumnValidatorUtil.getNullCountColumnAlias(asDoubleColumn))));
    }

    public static boolean isStringAsDoubleColumn(Column column, ChecksumResult controlResult, ChecksumResult testResult) {
        return Objects.equals(controlResult.getChecksum(ColumnValidatorUtil.getNullCountColumnAlias(column)), controlResult.getChecksum(ColumnValidatorUtil.getAsDoubleNullCountColumnAlias(column))) && Objects.equals(testResult.getChecksum(ColumnValidatorUtil.getNullCountColumnAlias(column)), testResult.getChecksum(ColumnValidatorUtil.getAsDoubleNullCountColumnAlias(column)));
    }

    public static String getNullCountColumnAlias(Column column) {
        return column.getName() + "$null_count";
    }

    public static String getAsDoubleNullCountColumnAlias(Column column) {
        return column.getName() + "_as_double$null_count";
    }
}

