/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.verifier.checksum;

import com.facebook.presto.sql.QueryUtil;
import com.facebook.presto.sql.tree.Expression;
import com.facebook.presto.sql.tree.FunctionCall;
import com.facebook.presto.sql.tree.GroupBy;
import com.facebook.presto.sql.tree.Identifier;
import com.facebook.presto.sql.tree.OrderBy;
import com.facebook.presto.sql.tree.QualifiedName;
import com.facebook.presto.sql.tree.Query;
import com.facebook.presto.sql.tree.Relation;
import com.facebook.presto.sql.tree.Select;
import com.facebook.presto.sql.tree.SimpleGroupBy;
import com.facebook.presto.sql.tree.SingleColumn;
import com.facebook.presto.sql.tree.SortItem;
import com.facebook.presto.sql.tree.Table;
import com.facebook.presto.verifier.checksum.ChecksumResult;
import com.facebook.presto.verifier.checksum.ColumnMatchResult;
import com.facebook.presto.verifier.checksum.ColumnValidator;
import com.facebook.presto.verifier.framework.Column;
import com.google.common.collect.ImmutableList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import javax.inject.Inject;
import javax.inject.Provider;

public class ChecksumValidator {
    private final Map<Column.Category, Provider<ColumnValidator>> columnValidators;

    @Inject
    public ChecksumValidator(Map<Column.Category, Provider<ColumnValidator>> columnValidators) {
        this.columnValidators = columnValidators;
    }

    public Query generateChecksumQuery(QualifiedName tableName, List<Column> columns, Optional<Expression> partitionPredicate) {
        ImmutableList.Builder selectItems = ImmutableList.builder();
        selectItems.add((Object)new SingleColumn((Expression)new FunctionCall(QualifiedName.of((String)"count"), (List)ImmutableList.of())));
        for (Column column : columns) {
            selectItems.addAll(((ColumnValidator)this.columnValidators.get((Object)column.getCategory()).get()).generateChecksumColumns(column));
        }
        return QueryUtil.simpleQuery((Select)new Select(false, (List)selectItems.build()), (Relation)new Table(tableName), partitionPredicate, Optional.empty());
    }

    public Query generatePartitionChecksumQuery(QualifiedName tableName, List<Column> dataColumns, List<Column> partitionColumns, Optional<Expression> partitionPredicate) {
        ImmutableList.Builder selectItems = ImmutableList.builder();
        selectItems.add((Object)new SingleColumn((Expression)new FunctionCall(QualifiedName.of((String)"count"), (List)ImmutableList.of())));
        for (Column column : dataColumns) {
            selectItems.addAll(((ColumnValidator)this.columnValidators.get((Object)column.getCategory()).get()).generateChecksumColumns(column));
        }
        ImmutableList.Builder groupByList = ImmutableList.builder();
        ImmutableList.Builder orderByList = ImmutableList.builder();
        for (Column partitionColumn : partitionColumns) {
            orderByList.add((Object)new SortItem((Expression)new Identifier(partitionColumn.getName()), SortItem.Ordering.ASCENDING, SortItem.NullOrdering.UNDEFINED));
            groupByList.add((Object)new SimpleGroupBy((List)ImmutableList.of((Object)new Identifier(partitionColumn.getName()))));
        }
        return QueryUtil.simpleQuery((Select)new Select(false, (List)selectItems.build()), (Relation)new Table(tableName), partitionPredicate, Optional.of(new GroupBy(false, (List)groupByList.build())), Optional.empty(), Optional.of(new OrderBy((List)orderByList.build())), Optional.empty(), Optional.empty());
    }

    public Query generateBucketChecksumQuery(QualifiedName tableName, List<Column> partitionColumns, List<Column> dataColumns, Optional<Expression> partitionPredicate) {
        ImmutableList.Builder selectItems = ImmutableList.builder();
        selectItems.add((Object)new SingleColumn((Expression)new FunctionCall(QualifiedName.of((String)"count"), (List)ImmutableList.of())));
        for (Column column : dataColumns) {
            selectItems.addAll(((ColumnValidator)this.columnValidators.get((Object)column.getCategory()).get()).generateChecksumColumns(column));
        }
        ImmutableList.Builder groupByList = ImmutableList.builder();
        ImmutableList.Builder orderByList = ImmutableList.builder();
        for (Column partitionColumn : partitionColumns) {
            orderByList.add((Object)new SortItem((Expression)new Identifier(partitionColumn.getName()), SortItem.Ordering.ASCENDING, SortItem.NullOrdering.UNDEFINED));
            groupByList.add((Object)new SimpleGroupBy((List)ImmutableList.of((Object)new Identifier(partitionColumn.getName()))));
        }
        orderByList.add((Object)new SortItem((Expression)new Identifier("$bucket"), SortItem.Ordering.ASCENDING, SortItem.NullOrdering.UNDEFINED));
        groupByList.add((Object)new SimpleGroupBy((List)ImmutableList.of((Object)new Identifier("$bucket"))));
        return QueryUtil.simpleQuery((Select)new Select(false, (List)selectItems.build()), (Relation)new Table(tableName), partitionPredicate, Optional.of(new GroupBy(false, (List)groupByList.build())), Optional.empty(), Optional.of(new OrderBy((List)orderByList.build())), Optional.empty(), Optional.empty());
    }

    public List<ColumnMatchResult<?>> getMismatchedColumns(List<Column> columns, ChecksumResult controlChecksum, ChecksumResult testChecksum) {
        return (List)columns.stream().flatMap(column -> ((ColumnValidator)this.columnValidators.get((Object)column.getCategory()).get()).validate((Column)column, controlChecksum, testChecksum).stream()).filter(columnMatchResult -> !columnMatchResult.isMatched()).collect(ImmutableList.toImmutableList());
    }
}

