/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.verifier.checksum;

import com.facebook.presto.common.type.AbstractVarcharType;
import com.facebook.presto.common.type.ArrayType;
import com.facebook.presto.common.type.DoubleType;
import com.facebook.presto.common.type.RowType;
import com.facebook.presto.common.type.Type;
import com.facebook.presto.sql.QueryUtil;
import com.facebook.presto.sql.tree.ArithmeticUnaryExpression;
import com.facebook.presto.sql.tree.Cast;
import com.facebook.presto.sql.tree.CoalesceExpression;
import com.facebook.presto.sql.tree.ComparisonExpression;
import com.facebook.presto.sql.tree.Expression;
import com.facebook.presto.sql.tree.Identifier;
import com.facebook.presto.sql.tree.LambdaArgumentDeclaration;
import com.facebook.presto.sql.tree.LambdaExpression;
import com.facebook.presto.sql.tree.LongLiteral;
import com.facebook.presto.sql.tree.SingleColumn;
import com.facebook.presto.sql.tree.TryExpression;
import com.facebook.presto.verifier.checksum.ArrayColumnChecksum;
import com.facebook.presto.verifier.checksum.ChecksumResult;
import com.facebook.presto.verifier.checksum.ColumnMatchResult;
import com.facebook.presto.verifier.checksum.ColumnValidator;
import com.facebook.presto.verifier.checksum.ColumnValidatorUtil;
import com.facebook.presto.verifier.checksum.FloatingPointColumnChecksum;
import com.facebook.presto.verifier.checksum.FloatingPointColumnValidator;
import com.facebook.presto.verifier.framework.Column;
import com.facebook.presto.verifier.framework.VerifierConfig;
import com.facebook.presto.verifier.framework.VerifierUtil;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import javax.inject.Inject;

public class ArrayColumnValidator
implements ColumnValidator {
    private final FloatingPointColumnValidator floatingPointValidator;
    private final boolean useErrorMarginForFloatingPointArrays;
    private final boolean validateStringAsDouble;

    @Inject
    public ArrayColumnValidator(VerifierConfig config, FloatingPointColumnValidator floatingPointValidator) {
        this.floatingPointValidator = Objects.requireNonNull(floatingPointValidator, "floatingPointValidator is null");
        this.useErrorMarginForFloatingPointArrays = config.isUseErrorMarginForFloatingPointArrays();
        this.validateStringAsDouble = config.isValidateStringAsDouble();
    }

    @Override
    public List<SingleColumn> generateChecksumColumns(Column column) {
        Type columnType = column.getType();
        ImmutableList.Builder builder = ImmutableList.builder();
        Expression checksum = ArrayColumnValidator.generateArrayChecksum(column.getExpression(), columnType);
        Expression arrayCardinalityChecksum = QueryUtil.functionCall((String)"checksum", (Expression[])new Expression[]{QueryUtil.functionCall((String)"cardinality", (Expression[])new Expression[]{column.getExpression()})});
        CoalesceExpression arrayCardinalitySum = new CoalesceExpression(QueryUtil.functionCall((String)"sum", (Expression[])new Expression[]{QueryUtil.functionCall((String)"cardinality", (Expression[])new Expression[]{column.getExpression()})}), (Expression)new LongLiteral("0"), new Expression[0]);
        if (this.useFloatingPointPath(column)) {
            builder.addAll(ArrayColumnValidator.generateFloatingPointArrayChecksumColumns(column));
        } else if (this.useStringAsDoublePath(column)) {
            builder.add((Object)new SingleColumn(checksum, VerifierUtil.delimitedIdentifier(ArrayColumnValidator.getChecksumColumnAlias(column))));
            builder.addAll(ArrayColumnValidator.generateStringArrayChecksumColumns(column));
        } else {
            builder.add((Object)new SingleColumn(checksum, VerifierUtil.delimitedIdentifier(ArrayColumnValidator.getChecksumColumnAlias(column))));
        }
        builder.add((Object)new SingleColumn(arrayCardinalityChecksum, VerifierUtil.delimitedIdentifier(ArrayColumnValidator.getCardinalityChecksumColumnAlias(column))));
        builder.add((Object)new SingleColumn((Expression)arrayCardinalitySum, VerifierUtil.delimitedIdentifier(ArrayColumnValidator.getCardinalitySumColumnAlias(column))));
        return builder.build();
    }

    public List<ColumnMatchResult<ArrayColumnChecksum>> validate(Column column, ChecksumResult controlResult, ChecksumResult testResult) {
        Preconditions.checkArgument((controlResult.getRowCount() == testResult.getRowCount() ? 1 : 0) != 0, (String)"Test row count (%s) does not match control row count (%s)", (long)testResult.getRowCount(), (long)controlResult.getRowCount());
        boolean useFloatingPointPath = this.useFloatingPointPath(column);
        boolean useStringAsDoublePath = this.useStringAsDoublePath(column) && ColumnValidatorUtil.isStringAsDoubleColumn(column, controlResult, testResult);
        ArrayColumnChecksum controlChecksum = ArrayColumnValidator.toColumnChecksum(column, controlResult, useFloatingPointPath, useStringAsDoublePath);
        ArrayColumnChecksum testChecksum = ArrayColumnValidator.toColumnChecksum(column, testResult, useFloatingPointPath, useStringAsDoublePath);
        if (!Objects.equals(controlChecksum.getCardinalityChecksum(), testChecksum.getCardinalityChecksum()) || !Objects.equals(controlChecksum.getCardinalitySum(), testChecksum.getCardinalitySum())) {
            return ImmutableList.of(new ColumnMatchResult<ArrayColumnChecksum>(false, column, Optional.of("cardinality mismatch"), controlChecksum, testChecksum));
        }
        if (useFloatingPointPath) {
            ColumnMatchResult<FloatingPointColumnChecksum> result = this.floatingPointValidator.validate(column, controlChecksum.getFloatingPointChecksum(), testChecksum.getFloatingPointChecksum());
            return ImmutableList.of(new ColumnMatchResult<ArrayColumnChecksum>(result.isMatched(), column, result.getMessage(), controlChecksum, testChecksum));
        }
        if (useStringAsDoublePath) {
            Column asDoubleArrayColumn = ArrayColumnValidator.getAsDoubleArrayColumn(column);
            ColumnMatchResult<FloatingPointColumnChecksum> result = this.floatingPointValidator.validate(asDoubleArrayColumn, controlChecksum.getFloatingPointChecksum(), testChecksum.getFloatingPointChecksum());
            return ImmutableList.of(new ColumnMatchResult<ArrayColumnChecksum>(result.isMatched(), column, result.getMessage(), controlChecksum, testChecksum));
        }
        return ImmutableList.of(new ColumnMatchResult<ArrayColumnChecksum>(Objects.equals(controlChecksum, testChecksum), column, controlChecksum, testChecksum));
    }

    public static List<SingleColumn> generateFloatingPointArrayChecksumColumns(Column column) {
        Preconditions.checkArgument((boolean)(column.getType() instanceof ArrayType), (String)"Expect ArrayType, found %s", (Object)column.getType().getDisplayName());
        Type elementType = ((ArrayType)column.getType()).getElementType();
        Preconditions.checkArgument((boolean)Column.FLOATING_POINT_TYPES.contains(elementType), (String)"Expect Double or Real, found %s", (Object)elementType.getDisplayName());
        Expression expression = elementType.equals(DoubleType.DOUBLE) ? column.getExpression() : new Cast(column.getExpression(), new ArrayType((Type)DoubleType.DOUBLE).getDisplayName());
        Expression sum = QueryUtil.functionCall((String)"sum", (Expression[])new Expression[]{QueryUtil.functionCall((String)"array_sum", (Expression[])new Expression[]{QueryUtil.functionCall((String)"filter", (Expression[])new Expression[]{expression, ArrayColumnValidator.generateLambdaExpression("is_finite")})})});
        Expression nanCount = QueryUtil.functionCall((String)"sum", (Expression[])new Expression[]{QueryUtil.functionCall((String)"cardinality", (Expression[])new Expression[]{QueryUtil.functionCall((String)"filter", (Expression[])new Expression[]{expression, ArrayColumnValidator.generateLambdaExpression("is_nan")})})});
        Expression posInfCount = QueryUtil.functionCall((String)"sum", (Expression[])new Expression[]{QueryUtil.functionCall((String)"cardinality", (Expression[])new Expression[]{QueryUtil.functionCall((String)"filter", (Expression[])new Expression[]{expression, ArrayColumnValidator.generateInfinityLambdaExpression(ArithmeticUnaryExpression.Sign.PLUS)})})});
        Expression negInfCount = QueryUtil.functionCall((String)"sum", (Expression[])new Expression[]{QueryUtil.functionCall((String)"cardinality", (Expression[])new Expression[]{QueryUtil.functionCall((String)"filter", (Expression[])new Expression[]{expression, ArrayColumnValidator.generateInfinityLambdaExpression(ArithmeticUnaryExpression.Sign.MINUS)})})});
        return ImmutableList.of((Object)new SingleColumn(sum, Optional.of(VerifierUtil.delimitedIdentifier(FloatingPointColumnValidator.getSumColumnAlias(column)))), (Object)new SingleColumn(nanCount, Optional.of(VerifierUtil.delimitedIdentifier(FloatingPointColumnValidator.getNanCountColumnAlias(column)))), (Object)new SingleColumn(posInfCount, Optional.of(VerifierUtil.delimitedIdentifier(FloatingPointColumnValidator.getPositiveInfinityCountColumnAlias(column)))), (Object)new SingleColumn(negInfCount, Optional.of(VerifierUtil.delimitedIdentifier(FloatingPointColumnValidator.getNegativeInfinityCountColumnAlias(column)))));
    }

    public static List<SingleColumn> generateStringArrayChecksumColumns(Column column) {
        Preconditions.checkArgument((boolean)(column.getType() instanceof ArrayType), (String)"Expect ArrayType, found %s", (Object)column.getType().getDisplayName());
        Type elementType = ((ArrayType)column.getType()).getElementType();
        Preconditions.checkArgument((boolean)(elementType instanceof AbstractVarcharType), (String)"Expect VarcharType, found %s", (Object)elementType.getDisplayName());
        Column asDoubleArrayColumn = ArrayColumnValidator.getAsDoubleArrayColumn(column);
        return ImmutableList.builder().addAll(ArrayColumnValidator.generateFloatingPointArrayChecksumColumns(asDoubleArrayColumn)).addAll(ColumnValidatorUtil.generateNullCountColumns(column, asDoubleArrayColumn)).build();
    }

    public static Expression generateArrayChecksum(Expression column, Type type) {
        Preconditions.checkArgument((boolean)(type instanceof ArrayType), (String)"Expect ArrayType, found %s", (Object)type.getDisplayName());
        Type elementType = ((ArrayType)type).getElementType();
        if (elementType.isOrderable()) {
            Expression arraySort = QueryUtil.functionCall((String)"array_sort", (Expression[])new Expression[]{column});
            if (elementType instanceof ArrayType || elementType instanceof RowType) {
                return new CoalesceExpression(QueryUtil.functionCall((String)"checksum", (Expression[])new Expression[]{new TryExpression(arraySort)}), QueryUtil.functionCall((String)"checksum", (Expression[])new Expression[]{column}), new Expression[0]);
            }
            return QueryUtil.functionCall((String)"checksum", (Expression[])new Expression[]{arraySort});
        }
        return QueryUtil.functionCall((String)"checksum", (Expression[])new Expression[]{column});
    }

    private static Expression generateInfinityLambdaExpression(ArithmeticUnaryExpression.Sign sign) {
        ComparisonExpression lambdaBody = new ComparisonExpression(ComparisonExpression.Operator.EQUAL, (Expression)new Identifier("x"), (Expression)new ArithmeticUnaryExpression(sign, QueryUtil.functionCall((String)"infinity", (Expression[])new Expression[0])));
        return new LambdaExpression((List)ImmutableList.of((Object)new LambdaArgumentDeclaration(QueryUtil.identifier((String)"x"))), (Expression)lambdaBody);
    }

    private static Expression generateLambdaExpression(String functionName) {
        return new LambdaExpression((List)ImmutableList.of((Object)new LambdaArgumentDeclaration(QueryUtil.identifier((String)"x"))), QueryUtil.functionCall((String)functionName, (Expression[])new Expression[]{new Identifier("x")}));
    }

    private static ArrayColumnChecksum toColumnChecksum(Column column, ChecksumResult checksumResult, boolean useFloatingPointPath, boolean useStringAsDoublePath) {
        if (checksumResult.getRowCount() == 0L) {
            return new ArrayColumnChecksum(null, null, 0L, useFloatingPointPath || useStringAsDoublePath ? Optional.of(new FloatingPointColumnChecksum(null, 0L, 0L, 0L, 0L)) : Optional.empty());
        }
        Object cardinalityChecksum = checksumResult.getChecksum(ArrayColumnValidator.getCardinalityChecksumColumnAlias(column));
        long cardinalitySum = (Long)checksumResult.getChecksum(ArrayColumnValidator.getCardinalitySumColumnAlias(column));
        if (useFloatingPointPath) {
            return new ArrayColumnChecksum(null, cardinalityChecksum, cardinalitySum, Optional.of(FloatingPointColumnValidator.toColumnChecksum(column, checksumResult, checksumResult.getRowCount())));
        }
        Object checksum = checksumResult.getChecksum(ArrayColumnValidator.getChecksumColumnAlias(column));
        if (useStringAsDoublePath) {
            Column asDoubleArrayColumn = ArrayColumnValidator.getAsDoubleArrayColumn(column);
            return new ArrayColumnChecksum(null, cardinalityChecksum, cardinalitySum, Optional.of(FloatingPointColumnValidator.toColumnChecksum(asDoubleArrayColumn, checksumResult, checksumResult.getRowCount())));
        }
        return new ArrayColumnChecksum(checksum, cardinalityChecksum, cardinalitySum, Optional.empty());
    }

    private boolean useFloatingPointPath(Column column) {
        Type columnType = column.getType();
        Preconditions.checkArgument((boolean)(columnType instanceof ArrayType), (String)"Expect ArrayType, found %s", (Object)columnType.getDisplayName());
        Type elementType = ((ArrayType)columnType).getElementType();
        return this.useErrorMarginForFloatingPointArrays && Column.FLOATING_POINT_TYPES.contains(elementType);
    }

    private boolean useStringAsDoublePath(Column column) {
        Type columnType = column.getType();
        Preconditions.checkArgument((boolean)(columnType instanceof ArrayType), (String)"Expect ArrayType, found %s", (Object)columnType.getDisplayName());
        Type elementType = ((ArrayType)columnType).getElementType();
        return this.validateStringAsDouble && elementType instanceof AbstractVarcharType;
    }

    public static Column getAsDoubleArrayColumn(Column column) {
        return Column.create(column.getName() + "_as_double", ArrayColumnValidator.getAsDoubleArrayExpression(column), (Type)new ArrayType((Type)DoubleType.DOUBLE));
    }

    private static Expression getAsDoubleArrayExpression(Column column) {
        return QueryUtil.functionCall((String)"transform", (Expression[])new Expression[]{column.getExpression(), new LambdaExpression((List)ImmutableList.of((Object)new LambdaArgumentDeclaration(QueryUtil.identifier((String)"x"))), (Expression)new Cast((Expression)QueryUtil.identifier((String)"x"), DoubleType.DOUBLE.getDisplayName(), true, false))});
    }

    private static String getChecksumColumnAlias(Column column) {
        return column.getName() + "$checksum";
    }

    private static String getCardinalityChecksumColumnAlias(Column column) {
        return column.getName() + "$cardinality_checksum";
    }

    private static String getCardinalitySumColumnAlias(Column column) {
        return column.getName() + "$cardinality_sum";
    }
}

