/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.verifier.source;

import com.facebook.presto.verifier.framework.SnapshotQuery;
import com.facebook.presto.verifier.framework.SourceQuery;
import com.facebook.presto.verifier.source.StringToStringMapColumnMapper;
import java.util.List;
import org.jdbi.v3.sqlobject.config.RegisterColumnMapper;
import org.jdbi.v3.sqlobject.config.RegisterConstructorMapper;
import org.jdbi.v3.sqlobject.customizer.Bind;
import org.jdbi.v3.sqlobject.customizer.Define;
import org.jdbi.v3.sqlobject.statement.SqlQuery;
import org.jdbi.v3.sqlobject.statement.SqlUpdate;

@RegisterColumnMapper(value=StringToStringMapColumnMapper.class)
public interface VerifierDao {
    @SqlUpdate(value="CREATE TABLE <table_name> (\n  id int(11) unsigned NOT NULL PRIMARY KEY AUTO_INCREMENT,\n  suite varchar(256) NOT NULL,\n  name varchar(256) DEFAULT NULL,\n  control_catalog varchar(256) NOT NULL,\n  control_schema varchar(256) NOT NULL,\n  control_query text NOT NULL,\n  control_username varchar(256) DEFAULT NULL,\n  control_password varchar(256) DEFAULT NULL,\n  control_session_properties text DEFAULT NULL,\n  test_catalog varchar(256) NOT NULL,\n  test_schema varchar(256) NOT NULL,\n  test_query text NOT NULL,\n  test_username varchar(256) DEFAULT NULL,\n  test_password varchar(256) DEFAULT NULL,\n  test_session_properties text DEFAULT NULL)")
    public void createVerifierQueriesTable(@Define(value="table_name") String var1);

    @SqlQuery(value="SELECT\n  suite,\n  name,\n  control_query,\n  control_catalog,\n  control_schema,\n  control_username,\n  control_password,\n  control_session_properties,\n  test_query,\n  test_catalog,\n  test_schema,\n  test_username,\n  test_password,\n  test_session_properties\nFROM\n  <table_name>\nWHERE\n  suite  = :suite\nORDER BY\n  id\nLIMIT\n  :limit")
    @RegisterConstructorMapper(value=SourceQuery.class)
    public List<SourceQuery> getSourceQueries(@Define(value="table_name") String var1, @Bind(value="suite") String var2, @Bind(value="limit") int var3);

    @SqlUpdate(value="CREATE TABLE <table_name> (\n  id int(11) unsigned NOT NULL PRIMARY KEY AUTO_INCREMENT,\n  suite varchar(256) NOT NULL,\n  name varchar(256) NOT NULL DEFAULT '.',  -- default to '.' to make UNIQUE constraint happy if name is not provided.\n  is_explain BOOLEAN NOT NULL DEFAULT false,\n  snapshot json NOT NULL,\n  updated_at datetime NOT NULL DEFAULT now(),\n  UNIQUE(suite, name, is_explain)\n)")
    public void createVerifierSnapshotsTable(@Define(value="table_name") String var1);

    @SqlQuery(value="SELECT\n  suite,\n  name,\n  is_explain,\n  snapshot\nFROM <table_name>\nWHERE\n  suite  = :suite\nORDER BY\n  id\nLIMIT\n  :limit")
    @RegisterConstructorMapper(value=SnapshotQuery.class)
    public List<SnapshotQuery> getSnapshotQueries(@Define(value="table_name") String var1, @Bind(value="suite") String var2, @Bind(value="limit") int var3);

    @SqlUpdate(value="INSERT INTO <table_name>\n  (suite,\n  name,\n  is_explain,\n  snapshot,\n  updated_at)\nVALUES(:suite,\n  :name,\n  :is_explain,\n  :snapshot,\n  now())\nON DUPLICATE KEY UPDATE\n  snapshot = :snapshot,\n  updated_at = now()")
    public void saveSnapShot(@Define(value="table_name") String var1, @Bind(value="suite") String var2, @Bind(value="name") String var3, @Bind(value="is_explain") boolean var4, @Bind(value="snapshot") String var5);
}

