/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.verifier.source;

import com.facebook.airlift.configuration.AbstractConfigurationAwareModule;
import com.facebook.airlift.configuration.ConfigBinder;
import com.facebook.presto.verifier.framework.VerifierConfig;
import com.facebook.presto.verifier.source.MySqlSourceQueryConfig;
import com.facebook.presto.verifier.source.MySqlSourceQuerySupplier;
import com.facebook.presto.verifier.source.MysqlSnapshotQueryConsumer;
import com.facebook.presto.verifier.source.MysqlSnapshotQuerySupplier;
import com.facebook.presto.verifier.source.PrestoQuerySourceQueryConfig;
import com.facebook.presto.verifier.source.PrestoQuerySourceQuerySupplier;
import com.facebook.presto.verifier.source.SnapshotQueryConsumer;
import com.facebook.presto.verifier.source.SnapshotQuerySupplier;
import com.facebook.presto.verifier.source.SourceQuerySupplier;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableSet;
import com.google.inject.Binder;
import com.google.inject.Scopes;
import java.util.Set;

public class SourceQueryModule
extends AbstractConfigurationAwareModule {
    private static final String SOURCE_QUERY_CONFIG_PREFIX = "source-query";
    private final Set<String> supportedSourceQuerySupplierTypes;

    public SourceQueryModule(Set<String> customSourceQuerySupplierTypes) {
        this.supportedSourceQuerySupplierTypes = ImmutableSet.builder().add((Object)"mysql").add((Object)"presto-query").addAll(customSourceQuerySupplierTypes).build();
    }

    protected void setup(Binder binder) {
        String sourceQuerySupplierType = ((VerifierConfig)this.buildConfigObject(VerifierConfig.class)).getSourceQuerySupplier();
        Preconditions.checkArgument((boolean)this.supportedSourceQuerySupplierTypes.contains(sourceQuerySupplierType), (String)"Unsupported SourceQuerySupplier: %s", (Object)sourceQuerySupplierType);
        ConfigBinder.configBinder((Binder)binder).bindConfig(MySqlSourceQueryConfig.class, SOURCE_QUERY_CONFIG_PREFIX);
        binder.bind(SnapshotQuerySupplier.class).to(MysqlSnapshotQuerySupplier.class).in(Scopes.SINGLETON);
        binder.bind(SnapshotQueryConsumer.class).to(MysqlSnapshotQueryConsumer.class).in(Scopes.SINGLETON);
        if ("mysql".equals(sourceQuerySupplierType)) {
            binder.bind(SourceQuerySupplier.class).to(MySqlSourceQuerySupplier.class).in(Scopes.SINGLETON);
        }
        if ("presto-query".equals(sourceQuerySupplierType)) {
            ConfigBinder.configBinder((Binder)binder).bindConfig(PrestoQuerySourceQueryConfig.class, SOURCE_QUERY_CONFIG_PREFIX);
            binder.bind(SourceQuerySupplier.class).to(PrestoQuerySourceQuerySupplier.class).in(Scopes.SINGLETON);
        }
    }
}

