/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.verifier.source;

import com.facebook.presto.verifier.framework.SnapshotQuery;
import com.facebook.presto.verifier.source.SnapshotQuerySupplier;
import com.facebook.presto.verifier.source.VerifierDao;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import javax.inject.Provider;
import org.jdbi.v3.core.Handle;
import org.jdbi.v3.core.Jdbi;

public abstract class AbstractJdbiSnapshotQuerySupplier
implements SnapshotQuerySupplier {
    public static final String VERIFIER_SNAPSHOT_KEY_PATTERN = "SUITE_%s_@TEST_%s_@EXPLAIN_%s";
    private final Provider<Jdbi> jdbiProvider;
    private final String tableName;
    private final List<String> suites;
    private final int maxQueriesPerSuite;

    public AbstractJdbiSnapshotQuerySupplier(Provider<Jdbi> jdbiProvider, String tableName, List<String> suites, int maxQueriesPerSuite) {
        this.jdbiProvider = Objects.requireNonNull(jdbiProvider, "jdbiProvider is null");
        this.tableName = Objects.requireNonNull(tableName, "tableName is null");
        this.suites = ImmutableList.copyOf(suites);
        this.maxQueriesPerSuite = maxQueriesPerSuite;
    }

    @Override
    public Map<String, SnapshotQuery> get() {
        ImmutableMap.Builder snapshotQueriesMap = ImmutableMap.builder();
        try (Handle handle = ((Jdbi)this.jdbiProvider.get()).open();){
            VerifierDao verifierDao = (VerifierDao)handle.attach(VerifierDao.class);
            for (String suite : this.suites) {
                for (SnapshotQuery snapshotQuery : verifierDao.getSnapshotQueries(this.tableName, suite, this.maxQueriesPerSuite)) {
                    String key = String.format(VERIFIER_SNAPSHOT_KEY_PATTERN, snapshotQuery.getSuite(), snapshotQuery.getName(), snapshotQuery.isExplain());
                    snapshotQueriesMap.put((Object)key, (Object)snapshotQuery);
                }
            }
        }
        return snapshotQueriesMap.build();
    }
}

