/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.verifier.prestoaction;

import com.facebook.airlift.configuration.Config;
import com.facebook.airlift.configuration.ConfigDescription;
import com.facebook.presto.verifier.prestoaction.PrestoAddress;
import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.common.base.Splitter;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import io.airlift.units.Duration;
import io.airlift.units.MinDuration;
import java.io.IOException;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.TimeUnit;
import javax.validation.constraints.Max;
import javax.validation.constraints.Min;
import javax.validation.constraints.NotNull;

public class PrestoActionConfig
implements PrestoAddress {
    private static final Splitter HOST_SPLITTER = Splitter.on((String)",");
    private List<String> hosts = ImmutableList.of();
    private int jdbcPort;
    private Optional<Integer> httpPort = Optional.empty();
    private Map<String, String> jdbcUrlParameters = ImmutableMap.of();
    private Duration queryTimeout = new Duration(60.0, TimeUnit.MINUTES);
    private String applicationName = "verifier-test";
    private boolean removeMemoryRelatedSessionProperties = true;

    @Override
    @NotNull
    public List<String> getHosts() {
        return this.hosts;
    }

    @Config(value="hosts")
    @ConfigDescription(value="Comma-separated list of the cluster hostnames or IP addresses.")
    public PrestoActionConfig setHosts(String hosts) {
        if (hosts != null) {
            this.hosts = ImmutableList.copyOf((Collection)HOST_SPLITTER.splitToList((CharSequence)hosts));
        }
        return this;
    }

    @Override
    @Min(value=0L)
    @Max(value=65535L)
    public @Min(value=0L) @Max(value=65535L) int getJdbcPort() {
        return this.jdbcPort;
    }

    @Config(value="jdbc-port")
    public PrestoActionConfig setJdbcPort(int jdbcPort) {
        this.jdbcPort = jdbcPort;
        return this;
    }

    @Override
    @NotNull
    public Optional<Integer> getHttpPort() {
        return this.httpPort;
    }

    @Config(value="http-port")
    public PrestoActionConfig setHttpPort(Integer httpPort) {
        this.httpPort = Optional.ofNullable(httpPort);
        return this;
    }

    @Override
    @NotNull
    public Map<String, String> getJdbcUrlParameters() {
        return this.jdbcUrlParameters;
    }

    @Config(value="jdbc-url-parameters")
    public PrestoActionConfig setJdbcUrlParameters(String jdbcUrlParameters) {
        if (jdbcUrlParameters == null) {
            return this;
        }
        try {
            this.jdbcUrlParameters = (Map)new ObjectMapper().readValue(jdbcUrlParameters, (TypeReference)new TypeReference<Map<String, String>>(){});
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        return this;
    }

    @MinDuration(value="1s")
    public Duration getQueryTimeout() {
        return this.queryTimeout;
    }

    @Config(value="query-timeout")
    public PrestoActionConfig setQueryTimeout(Duration queryTimeout) {
        this.queryTimeout = queryTimeout;
        return this;
    }

    @NotNull
    public String getApplicationName() {
        return this.applicationName;
    }

    @Config(value="application-name")
    public PrestoActionConfig setApplicationName(String applicationName) {
        this.applicationName = applicationName;
        return this;
    }

    public boolean isRemoveMemoryRelatedSessionProperties() {
        return this.removeMemoryRelatedSessionProperties;
    }

    @Config(value="remove-memory-related-session-properties")
    public PrestoActionConfig setRemoveMemoryRelatedSessionProperties(boolean removeMemoryRelatedSessionProperties) {
        this.removeMemoryRelatedSessionProperties = removeMemoryRelatedSessionProperties;
        return this;
    }
}

