/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.verifier.framework;

import com.facebook.airlift.concurrent.Threads;
import com.facebook.airlift.configuration.AbstractConfigurationAwareModule;
import com.facebook.airlift.configuration.ConfigBinder;
import com.facebook.presto.common.block.BlockEncoding;
import com.facebook.presto.common.block.BlockEncodingManager;
import com.facebook.presto.common.block.BlockEncodingSerde;
import com.facebook.presto.common.type.Type;
import com.facebook.presto.common.type.TypeManager;
import com.facebook.presto.metadata.CatalogManager;
import com.facebook.presto.metadata.FunctionAndTypeManager;
import com.facebook.presto.metadata.HandleJsonModule;
import com.facebook.presto.sql.analyzer.FeaturesConfig;
import com.facebook.presto.sql.parser.SqlParser;
import com.facebook.presto.sql.parser.SqlParserOptions;
import com.facebook.presto.transaction.ForTransactionManager;
import com.facebook.presto.transaction.InMemoryTransactionManager;
import com.facebook.presto.transaction.TransactionManager;
import com.facebook.presto.transaction.TransactionManagerConfig;
import com.facebook.presto.verifier.annotation.ForControl;
import com.facebook.presto.verifier.annotation.ForTest;
import com.facebook.presto.verifier.checksum.ArrayColumnValidator;
import com.facebook.presto.verifier.checksum.ChecksumValidator;
import com.facebook.presto.verifier.checksum.ColumnValidator;
import com.facebook.presto.verifier.checksum.FloatingPointColumnValidator;
import com.facebook.presto.verifier.checksum.MapColumnValidator;
import com.facebook.presto.verifier.checksum.RowColumnValidator;
import com.facebook.presto.verifier.checksum.SimpleColumnValidator;
import com.facebook.presto.verifier.framework.Column;
import com.facebook.presto.verifier.framework.DeterminismAnalyzerConfig;
import com.facebook.presto.verifier.framework.QueryConfigurationOverrides;
import com.facebook.presto.verifier.framework.QueryConfigurationOverridesConfig;
import com.facebook.presto.verifier.framework.SourceQuery;
import com.facebook.presto.verifier.framework.VerificationFactory;
import com.facebook.presto.verifier.framework.VerificationManager;
import com.facebook.presto.verifier.framework.VerifierConfig;
import com.facebook.presto.verifier.prestoaction.ClientInfoFactory;
import com.facebook.presto.verifier.resolver.FailureResolverModule;
import com.facebook.presto.verifier.rewrite.VerificationQueryRewriterModule;
import com.google.common.collect.ImmutableList;
import com.google.inject.Binder;
import com.google.inject.Inject;
import com.google.inject.Injector;
import com.google.inject.Key;
import com.google.inject.Module;
import com.google.inject.Provides;
import com.google.inject.Scopes;
import com.google.inject.TypeLiteral;
import com.google.inject.multibindings.MapBinder;
import com.google.inject.multibindings.Multibinder;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.function.Predicate;
import javax.inject.Provider;
import javax.inject.Singleton;

public class VerifierModule
extends AbstractConfigurationAwareModule {
    private final SqlParserOptions sqlParserOptions;
    private final List<Class<? extends Predicate<SourceQuery>>> customQueryFilterClasses;
    private final Class<? extends ClientInfoFactory> clientInfoFactory;

    public VerifierModule(SqlParserOptions sqlParserOptions, List<Class<? extends Predicate<SourceQuery>>> customQueryFilterClasses, Class<? extends ClientInfoFactory> clientInfoFactory) {
        this.sqlParserOptions = Objects.requireNonNull(sqlParserOptions, "sqlParserOptions is null");
        this.customQueryFilterClasses = ImmutableList.copyOf(customQueryFilterClasses);
        this.clientInfoFactory = Objects.requireNonNull(clientInfoFactory, "clientInfoFactory is null");
    }

    protected final void setup(Binder binder) {
        ConfigBinder.configBinder((Binder)binder).bindConfig(VerifierConfig.class);
        ConfigBinder.configBinder((Binder)binder).bindConfig(DeterminismAnalyzerConfig.class);
        ConfigBinder.configBinder((Binder)binder).bindConfig(QueryConfigurationOverridesConfig.class, ForControl.class, "control");
        ConfigBinder.configBinder((Binder)binder).bindConfig(QueryConfigurationOverridesConfig.class, ForTest.class, "test");
        binder.bind(QueryConfigurationOverrides.class).annotatedWith(ForControl.class).to(Key.get(QueryConfigurationOverridesConfig.class, ForControl.class)).in(Scopes.SINGLETON);
        binder.bind(QueryConfigurationOverrides.class).annotatedWith(ForTest.class).to(Key.get(QueryConfigurationOverridesConfig.class, ForTest.class)).in(Scopes.SINGLETON);
        for (Class<? extends Predicate<SourceQuery>> customQueryFilterClass : this.customQueryFilterClasses) {
            binder.bind(customQueryFilterClass).in(Scopes.SINGLETON);
        }
        binder.bind(BlockEncodingSerde.class).to(BlockEncodingManager.class).in(Scopes.SINGLETON);
        Multibinder.newSetBinder((Binder)binder, BlockEncoding.class);
        binder.bind(CatalogManager.class).in(Scopes.SINGLETON);
        binder.bind(FunctionAndTypeManager.class).in(Scopes.SINGLETON);
        binder.install((Module)new HandleJsonModule());
        binder.bind(SqlParserOptions.class).toInstance((Object)this.sqlParserOptions);
        binder.bind(ClientInfoFactory.class).to(this.clientInfoFactory).in(Scopes.SINGLETON);
        binder.bind(SqlParser.class).in(Scopes.SINGLETON);
        ConfigBinder.configBinder((Binder)binder).bindConfig(TransactionManagerConfig.class);
        ConfigBinder.configBinder((Binder)binder).bindConfig(FeaturesConfig.class);
        binder.bind(TypeManager.class).to(FunctionAndTypeManager.class).in(Scopes.SINGLETON);
        Multibinder.newSetBinder((Binder)binder, Type.class);
        this.install(new VerificationQueryRewriterModule());
        this.install((Module)FailureResolverModule.BUILT_IN);
        binder.bind(VerificationManager.class).in(Scopes.SINGLETON);
        binder.bind(VerificationFactory.class).in(Scopes.SINGLETON);
        binder.bind(ChecksumValidator.class).in(Scopes.SINGLETON);
        binder.bind(FloatingPointColumnValidator.class).in(Scopes.SINGLETON);
        MapBinder columnValidatorBinder = MapBinder.newMapBinder((Binder)binder, Column.Category.class, ColumnValidator.class);
        columnValidatorBinder.addBinding((Object)Column.Category.SIMPLE).to(SimpleColumnValidator.class).in(Scopes.SINGLETON);
        columnValidatorBinder.addBinding((Object)Column.Category.FLOATING_POINT).to(FloatingPointColumnValidator.class).in(Scopes.SINGLETON);
        columnValidatorBinder.addBinding((Object)Column.Category.ARRAY).to(ArrayColumnValidator.class).in(Scopes.SINGLETON);
        columnValidatorBinder.addBinding((Object)Column.Category.ROW).to(RowColumnValidator.class).in(Scopes.SINGLETON);
        columnValidatorBinder.addBinding((Object)Column.Category.MAP).to(MapColumnValidator.class).in(Scopes.SINGLETON);
        binder.bind((TypeLiteral)new TypeLiteral<List<Predicate<SourceQuery>>>(){}).toProvider((Provider)new CustomQueryFilterProvider(this.customQueryFilterClasses));
    }

    @Provides
    @Singleton
    public static ScheduledExecutorService createScheduledExecutorService() {
        return Executors.newSingleThreadScheduledExecutor(Threads.daemonThreadsNamed((String)"verifier-scheduled-executor-service"));
    }

    @Provides
    @Singleton
    @ForTransactionManager
    public static ScheduledExecutorService createTransactionIdleCheckExecutor() {
        return Executors.newSingleThreadScheduledExecutor(Threads.daemonThreadsNamed((String)"transaction-idle-check"));
    }

    @Provides
    @Singleton
    @ForTransactionManager
    public static ExecutorService createTransactionFinishingExecutor() {
        return Executors.newCachedThreadPool(Threads.daemonThreadsNamed((String)"transaction-finishing-%s"));
    }

    @Provides
    @Singleton
    public static TransactionManager createTransactionManager(TransactionManagerConfig config, CatalogManager catalogManager, @ForTransactionManager ScheduledExecutorService idleCheckExecutor, @ForTransactionManager ExecutorService finishingExecutor) {
        return InMemoryTransactionManager.create((TransactionManagerConfig)config, (ScheduledExecutorService)idleCheckExecutor, (CatalogManager)catalogManager, (ExecutorService)finishingExecutor);
    }

    private static class CustomQueryFilterProvider
    implements Provider<List<Predicate<SourceQuery>>> {
        private final List<Class<? extends Predicate<SourceQuery>>> customQueryFilterClasses;
        private Injector injector;

        public CustomQueryFilterProvider(List<Class<? extends Predicate<SourceQuery>>> customQueryFilterClasses) {
            this.customQueryFilterClasses = ImmutableList.copyOf(customQueryFilterClasses);
        }

        @Inject
        public void setInjector(Injector injector) {
            this.injector = injector;
        }

        public List<Predicate<SourceQuery>> get() {
            ImmutableList.Builder customVerificationFilters = ImmutableList.builder();
            for (Class<? extends Predicate<SourceQuery>> filterClass : this.customQueryFilterClasses) {
                customVerificationFilters.add(this.injector.getInstance(filterClass));
            }
            return customVerificationFilters.build();
        }
    }
}

