/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.verifier.framework;

import com.facebook.airlift.configuration.Config;
import com.facebook.airlift.configuration.ConfigDescription;
import com.facebook.presto.verifier.framework.QueryConfigurationOverrides;
import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.common.base.Splitter;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import java.io.IOException;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import javax.validation.constraints.NotNull;

public class QueryConfigurationOverridesConfig
implements QueryConfigurationOverrides {
    private Optional<String> catalogOverride = Optional.empty();
    private Optional<String> schemaOverride = Optional.empty();
    private Optional<String> usernameOverride = Optional.empty();
    private Optional<String> passwordOverride = Optional.empty();
    private QueryConfigurationOverrides.SessionPropertiesOverrideStrategy sessionPropertiesOverrideStrategy = QueryConfigurationOverrides.SessionPropertiesOverrideStrategy.NO_ACTION;
    private Map<String, String> sessionPropertiesOverride = ImmutableMap.of();
    private Set<String> sessionPropertiesToRemove = ImmutableSet.of();

    @Override
    public Optional<String> getCatalogOverride() {
        return this.catalogOverride;
    }

    @ConfigDescription(value="Overrides the catalog for all the queries")
    @Config(value="catalog-override")
    public QueryConfigurationOverridesConfig setCatalogOverride(String catalogOverride) {
        this.catalogOverride = Optional.ofNullable(catalogOverride);
        return this;
    }

    @Override
    public Optional<String> getSchemaOverride() {
        return this.schemaOverride;
    }

    @ConfigDescription(value="Overrides the schema for all the queries")
    @Config(value="schema-override")
    public QueryConfigurationOverridesConfig setSchemaOverride(String schemaOverride) {
        this.schemaOverride = Optional.ofNullable(schemaOverride);
        return this;
    }

    @Override
    public Optional<String> getUsernameOverride() {
        return this.usernameOverride;
    }

    @ConfigDescription(value="Overrides the username for all the queries")
    @Config(value="username-override")
    public QueryConfigurationOverridesConfig setUsernameOverride(String usernameOverride) {
        this.usernameOverride = Optional.ofNullable(usernameOverride);
        return this;
    }

    @Override
    public Optional<String> getPasswordOverride() {
        return this.passwordOverride;
    }

    @ConfigDescription(value="Overrides the password for all the queries")
    @Config(value="password-override")
    public QueryConfigurationOverridesConfig setPasswordOverride(String passwordOverride) {
        this.passwordOverride = Optional.ofNullable(passwordOverride);
        return this;
    }

    @Override
    @NotNull
    public QueryConfigurationOverrides.SessionPropertiesOverrideStrategy getSessionPropertiesOverrideStrategy() {
        return this.sessionPropertiesOverrideStrategy;
    }

    @Config(value="session-properties-override-strategy")
    public QueryConfigurationOverridesConfig setSessionPropertiesOverrideStrategy(QueryConfigurationOverrides.SessionPropertiesOverrideStrategy sessionPropertiesOverrideStrategy) {
        this.sessionPropertiesOverrideStrategy = sessionPropertiesOverrideStrategy;
        return this;
    }

    @Override
    public Set<String> getSessionPropertiesToRemove() {
        return this.sessionPropertiesToRemove;
    }

    @Config(value="session-properties-removal")
    public QueryConfigurationOverridesConfig setSessionPropertiesToRemove(String sessionPropertiesToRemove) {
        if (sessionPropertiesToRemove == null) {
            return this;
        }
        this.sessionPropertiesToRemove = ImmutableSet.copyOf((Iterable)Splitter.on((char)',').trimResults().omitEmptyStrings().split((CharSequence)sessionPropertiesToRemove));
        return this;
    }

    @Override
    public Map<String, String> getSessionPropertiesOverride() {
        return this.sessionPropertiesOverride;
    }

    @Config(value="session-properties-override")
    public QueryConfigurationOverridesConfig setSessionPropertiesOverride(String sessionPropertyOverride) {
        if (sessionPropertyOverride == null) {
            return this;
        }
        try {
            this.sessionPropertiesOverride = (Map)new ObjectMapper().readValue(sessionPropertyOverride, (TypeReference)new TypeReference<Map<String, String>>(){});
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        return this;
    }
}

