/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.verifier.framework;

import com.facebook.presto.common.type.TypeManager;
import com.facebook.presto.jdbc.QueryStats;
import com.facebook.presto.sql.tree.AstVisitor;
import com.facebook.presto.sql.tree.Node;
import com.facebook.presto.sql.tree.Query;
import com.facebook.presto.sql.tree.Statement;
import com.facebook.presto.sql.tree.Table;
import com.facebook.presto.verifier.checksum.ChecksumResult;
import com.facebook.presto.verifier.checksum.ChecksumValidator;
import com.facebook.presto.verifier.event.DeterminismAnalysisDetails;
import com.facebook.presto.verifier.event.DeterminismAnalysisRun;
import com.facebook.presto.verifier.framework.ClusterType;
import com.facebook.presto.verifier.framework.Column;
import com.facebook.presto.verifier.framework.DataMatchResult;
import com.facebook.presto.verifier.framework.DataVerificationUtil;
import com.facebook.presto.verifier.framework.DeterminismAnalysis;
import com.facebook.presto.verifier.framework.DeterminismAnalyzerConfig;
import com.facebook.presto.verifier.framework.LimitQueryDeterminismAnalysis;
import com.facebook.presto.verifier.framework.LimitQueryDeterminismAnalyzer;
import com.facebook.presto.verifier.framework.QueryBundle;
import com.facebook.presto.verifier.framework.QueryException;
import com.facebook.presto.verifier.framework.QueryObjectBundle;
import com.facebook.presto.verifier.framework.QueryStage;
import com.facebook.presto.verifier.framework.SourceQuery;
import com.facebook.presto.verifier.framework.VerifierUtil;
import com.facebook.presto.verifier.prestoaction.PrestoAction;
import com.facebook.presto.verifier.rewrite.QueryRewriter;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Iterables;
import java.util.HashMap;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.atomic.AtomicBoolean;

public class DeterminismAnalyzer {
    private final SourceQuery sourceQuery;
    private final PrestoAction prestoAction;
    private final QueryRewriter queryRewriter;
    private final ChecksumValidator checksumValidator;
    private final TypeManager typeManager;
    private final boolean runTeardown;
    private final int maxAnalysisRuns;
    private final Set<String> nonDeterministicCatalogs;
    private final boolean handleLimitQuery;

    public DeterminismAnalyzer(SourceQuery sourceQuery, PrestoAction prestoAction, QueryRewriter queryRewriter, ChecksumValidator checksumValidator, TypeManager typeManager, DeterminismAnalyzerConfig config) {
        this.sourceQuery = Objects.requireNonNull(sourceQuery, "sourceQuery is null");
        this.prestoAction = Objects.requireNonNull(prestoAction, "prestoAction is null");
        this.queryRewriter = Objects.requireNonNull(queryRewriter, "queryRewriter is null");
        this.checksumValidator = Objects.requireNonNull(checksumValidator, "checksumValidator is null");
        this.typeManager = Objects.requireNonNull(typeManager, "typeManager is null");
        this.runTeardown = config.isRunTeardown();
        this.maxAnalysisRuns = config.getMaxAnalysisRuns();
        this.nonDeterministicCatalogs = ImmutableSet.copyOf(config.getNonDeterministicCatalogs());
        this.handleLimitQuery = config.isHandleLimitQuery();
    }

    protected DeterminismAnalysisDetails analyze(QueryObjectBundle control, ChecksumResult controlChecksum) {
        DeterminismAnalysisDetails.Builder determinismAnalysisDetails = DeterminismAnalysisDetails.builder();
        DeterminismAnalysis analysis = this.analyze(control, controlChecksum, determinismAnalysisDetails);
        return determinismAnalysisDetails.build(analysis);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private DeterminismAnalysis analyze(QueryObjectBundle control, ChecksumResult controlChecksum, DeterminismAnalysisDetails.Builder determinismAnalysisDetails) {
        if (this.isNonDeterministicCatalogReferenced(control.getQuery())) {
            return DeterminismAnalysis.NON_DETERMINISTIC_CATALOG;
        }
        LimitQueryDeterminismAnalysis limitQueryAnalysis = new LimitQueryDeterminismAnalyzer(this.prestoAction, this.handleLimitQuery, control.getQuery(), controlChecksum.getRowCount(), determinismAnalysisDetails).analyze();
        switch (limitQueryAnalysis) {
            case NOT_RUN: 
            case FAILED_QUERY_FAILURE: 
            case DETERMINISTIC: {
                break;
            }
            case NON_DETERMINISTIC: {
                return DeterminismAnalysis.NON_DETERMINISTIC_LIMIT_CLAUSE;
            }
            case FAILED_DATA_CHANGED: {
                return DeterminismAnalysis.ANALYSIS_FAILED_DATA_CHANGED;
            }
            default: {
                throw new IllegalArgumentException(String.format("Invalid limitQueryAnalysis: %s", new Object[]{limitQueryAnalysis}));
            }
        }
        List<Column> columns = DataVerificationUtil.getColumns(this.prestoAction, this.typeManager, control.getObjectName());
        HashMap<QueryBundle, DeterminismAnalysisRun.Builder> queryRuns = new HashMap<QueryBundle, DeterminismAnalysisRun.Builder>();
        try {
            for (int i = 0; i < this.maxAnalysisRuns; ++i) {
                QueryObjectBundle queryBundle2 = this.queryRewriter.rewriteQuery(this.sourceQuery.getQuery(ClusterType.CONTROL), ClusterType.CONTROL);
                DeterminismAnalysisRun.Builder run2 = determinismAnalysisDetails.addRun().setTableName(queryBundle2.getObjectName().toString());
                queryRuns.put(queryBundle2, run2);
                queryBundle2.getSetupQueries().forEach(query -> VerifierUtil.runAndConsume(() -> this.prestoAction.execute((Statement)query, QueryStage.DETERMINISM_ANALYSIS_SETUP), stats -> stats.getQueryStats().map(QueryStats::getQueryId).ifPresent(run2::addSetupQueryId)));
                VerifierUtil.runAndConsume(() -> this.prestoAction.execute(queryBundle2.getQuery(), QueryStage.DETERMINISM_ANALYSIS_MAIN), stats -> stats.getQueryStats().map(QueryStats::getQueryId).ifPresent(run2::setQueryId));
                Query checksumQuery = this.checksumValidator.generateChecksumQuery(queryBundle2.getObjectName(), columns);
                ChecksumResult testChecksum = (ChecksumResult)Iterables.getOnlyElement(VerifierUtil.callAndConsume(() -> this.prestoAction.execute((Statement)checksumQuery, QueryStage.DETERMINISM_ANALYSIS_CHECKSUM, ChecksumResult::fromResultSet), stats -> stats.getQueryStats().map(QueryStats::getQueryId).ifPresent(run2::setChecksumQueryId)).getResults());
                DeterminismAnalysis analysis = this.matchResultToDeterminism(DataVerificationUtil.match(DataMatchResult.DataType.DATA, this.checksumValidator, columns, columns, controlChecksum, testChecksum));
                if (analysis == DeterminismAnalysis.DETERMINISTIC) continue;
                DeterminismAnalysis determinismAnalysis = analysis;
                return determinismAnalysis;
            }
            DeterminismAnalysis i = DeterminismAnalysis.DETERMINISTIC;
            return i;
        }
        catch (QueryException qe) {
            DeterminismAnalysis determinismAnalysis = DeterminismAnalysis.ANALYSIS_FAILED_QUERY_FAILURE;
            return determinismAnalysis;
        }
        finally {
            if (this.runTeardown) {
                queryRuns.forEach((queryBundle, run) -> DataVerificationUtil.teardownSafely(this.prestoAction, Optional.of(queryBundle), queryStats -> queryStats.getQueryStats().map(QueryStats::getQueryId).ifPresent(run::addTeardownQueryId)));
            }
        }
    }

    private DeterminismAnalysis matchResultToDeterminism(DataMatchResult matchResult) {
        switch (matchResult.getMatchType()) {
            case MATCH: {
                return DeterminismAnalysis.DETERMINISTIC;
            }
            case SCHEMA_MISMATCH: {
                return DeterminismAnalysis.ANALYSIS_FAILED_INCONSISTENT_SCHEMA;
            }
            case ROW_COUNT_MISMATCH: {
                return DeterminismAnalysis.NON_DETERMINISTIC_ROW_COUNT;
            }
            case COLUMN_MISMATCH: {
                return DeterminismAnalysis.NON_DETERMINISTIC_COLUMNS;
            }
        }
        throw new IllegalArgumentException(String.format("Invalid MatchResult: %s", matchResult));
    }

    @VisibleForTesting
    boolean isNonDeterministicCatalogReferenced(Statement statement) {
        if (this.nonDeterministicCatalogs.isEmpty()) {
            return false;
        }
        AtomicBoolean nonDeterministicCatalogReferenced = new AtomicBoolean();
        new NonDeterministicCatalogVisitor().process((Node)statement, nonDeterministicCatalogReferenced);
        return nonDeterministicCatalogReferenced.get();
    }

    private class NonDeterministicCatalogVisitor
    extends AstVisitor<Void, AtomicBoolean> {
        private NonDeterministicCatalogVisitor() {
        }

        protected Void visitNode(Node node, AtomicBoolean context) {
            node.getChildren().forEach(child -> {
                Void cfr_ignored_0 = (Void)this.process((Node)child, context);
            });
            return null;
        }

        protected Void visitTable(Table node, AtomicBoolean nonDeterministicCatalogReferenced) {
            if (node.getName().getParts().size() == 3 && DeterminismAnalyzer.this.nonDeterministicCatalogs.contains(node.getName().getParts().get(0))) {
                nonDeterministicCatalogReferenced.set(true);
            }
            return null;
        }
    }
}

