/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.verifier.framework;

import com.facebook.presto.jdbc.QueryStats;
import com.facebook.presto.sql.parser.ParsingException;
import com.facebook.presto.sql.parser.SqlParser;
import com.facebook.presto.sql.tree.Statement;
import com.facebook.presto.verifier.event.DeterminismAnalysisDetails;
import com.facebook.presto.verifier.framework.AbstractVerification;
import com.facebook.presto.verifier.framework.ChecksumQueryContext;
import com.facebook.presto.verifier.framework.DdlMatchResult;
import com.facebook.presto.verifier.framework.QueryObjectBundle;
import com.facebook.presto.verifier.framework.QueryResult;
import com.facebook.presto.verifier.framework.QueryStage;
import com.facebook.presto.verifier.framework.SnapshotQuery;
import com.facebook.presto.verifier.framework.SourceQuery;
import com.facebook.presto.verifier.framework.VerificationContext;
import com.facebook.presto.verifier.framework.VerifierConfig;
import com.facebook.presto.verifier.framework.VerifierUtil;
import com.facebook.presto.verifier.prestoaction.PrestoAction;
import com.facebook.presto.verifier.prestoaction.QueryActions;
import com.facebook.presto.verifier.prestoaction.SqlExceptionClassifier;
import com.facebook.presto.verifier.source.SnapshotQueryConsumer;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.common.collect.Iterables;
import com.google.common.util.concurrent.ListeningExecutorService;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;

public abstract class DdlVerification<S extends Statement>
extends AbstractVerification<QueryObjectBundle, DdlMatchResult, Void> {
    private final SqlParser sqlParser;
    private final PrestoAction.ResultSetConverter<String> checksumConverter;

    public DdlVerification(SqlParser sqlParser, QueryActions queryActions, SourceQuery sourceQuery, SqlExceptionClassifier exceptionClassifier, VerificationContext verificationContext, VerifierConfig verifierConfig, PrestoAction.ResultSetConverter<String> checksumConverter, ListeningExecutorService executor, SnapshotQueryConsumer snapshotQueryConsumer, Map<String, SnapshotQuery> snapshotQueries) {
        super(queryActions, sourceQuery, exceptionClassifier, verificationContext, Optional.empty(), verifierConfig, executor, snapshotQueryConsumer, snapshotQueries);
        this.sqlParser = Objects.requireNonNull(sqlParser, "sqlParser");
        this.checksumConverter = Objects.requireNonNull(checksumConverter, "checksumConverter is null");
    }

    protected abstract Statement getChecksumQuery(QueryObjectBundle var1);

    protected abstract boolean match(S var1, S var2, QueryObjectBundle var3, QueryObjectBundle var4);

    @Override
    protected DdlMatchResult verify(QueryObjectBundle control, QueryObjectBundle test, Optional<QueryResult<Void>> controlQueryResult, Optional<QueryResult<Void>> testQueryResult, ChecksumQueryContext controlChecksumQueryContext, ChecksumQueryContext testChecksumQueryContext) {
        Statement testObject;
        Statement controlObject;
        String controlChecksum = null;
        if (this.isControlEnabled()) {
            Statement controlChecksumQuery = this.getChecksumQuery(control);
            controlChecksumQueryContext.setChecksumQuery(DdlVerification.formatSql(controlChecksumQuery));
            controlChecksum = (String)Iterables.getOnlyElement(VerifierUtil.callAndConsume(() -> this.getHelperAction().execute(controlChecksumQuery, QueryStage.CONTROL_CHECKSUM, this.checksumConverter), stats -> stats.getQueryStats().map(QueryStats::getQueryId).ifPresent(controlChecksumQueryContext::setChecksumQueryId)).getResults());
            if (this.saveSnapshot) {
                try {
                    ObjectMapper objectMapper = new ObjectMapper();
                    String snapshot = objectMapper.writeValueAsString((Object)controlChecksum);
                    this.snapshotQueryConsumer.accept(new SnapshotQuery(this.getSourceQuery().getSuite(), this.getSourceQuery().getName(), this.isExplain, snapshot));
                    return new DdlMatchResult(DdlMatchResult.MatchType.MATCH, Optional.empty(), "", "");
                }
                catch (JsonProcessingException exception) {
                    throw new RuntimeException("Unable to save snapshot \"" + controlChecksum + "\".");
                }
            }
        } else if ("query-bank".equals(this.runningMode)) {
            String key = String.format("SUITE_%s_@TEST_%s_@EXPLAIN_%s", this.getSourceQuery().getSuite(), this.getSourceQuery().getName(), this.isExplain);
            SnapshotQuery snapshotQuery = (SnapshotQuery)this.snapshotQueries.get(key);
            if (snapshotQuery != null) {
                ObjectMapper objectMapper = new ObjectMapper();
                String snapshotJson = snapshotQuery.getSnapshot();
                try {
                    controlChecksum = (String)objectMapper.readValue(snapshotJson, String.class);
                }
                catch (JsonProcessingException exception) {
                    throw new RuntimeException("Unable to restore snapshot \"" + snapshotJson + "\".");
                }
            } else {
                return new DdlMatchResult(DdlMatchResult.MatchType.SNAPSHOT_DOES_NOT_EXIST, Optional.empty(), "", "");
            }
        }
        Statement testChecksumQuery = this.getChecksumQuery(test);
        testChecksumQueryContext.setChecksumQuery(DdlVerification.formatSql(testChecksumQuery));
        String testChecksum = (String)Iterables.getOnlyElement(VerifierUtil.callAndConsume(() -> this.getHelperAction().execute(testChecksumQuery, QueryStage.TEST_CHECKSUM, this.checksumConverter), stats -> stats.getQueryStats().map(QueryStats::getQueryId).ifPresent(testChecksumQueryContext::setChecksumQueryId)).getResults());
        try {
            controlObject = this.sqlParser.createStatement(controlChecksum, VerifierUtil.PARSING_OPTIONS);
        }
        catch (ParsingException e) {
            return new DdlMatchResult(DdlMatchResult.MatchType.CONTROL_NOT_PARSABLE, Optional.of(e), controlChecksum, testChecksum);
        }
        try {
            testObject = this.sqlParser.createStatement(testChecksum, VerifierUtil.PARSING_OPTIONS);
        }
        catch (ParsingException e) {
            return new DdlMatchResult(DdlMatchResult.MatchType.TEST_NOT_PARSABLE, Optional.of(e), controlChecksum, testChecksum);
        }
        return new DdlMatchResult(this.match(controlObject, testObject, control, test) ? DdlMatchResult.MatchType.MATCH : DdlMatchResult.MatchType.MISMATCH, Optional.empty(), controlChecksum, testChecksum);
    }

    @Override
    protected DeterminismAnalysisDetails analyzeDeterminism(QueryObjectBundle control, DdlMatchResult matchResult) {
        throw new UnsupportedOperationException("analyzeDeterminism is not supported for DdlVerification");
    }

    @Override
    protected Optional<String> resolveFailure(Optional<QueryObjectBundle> control, Optional<QueryObjectBundle> test, AbstractVerification.QueryContext controlQueryContext, Optional<DdlMatchResult> matchResult, Optional<Throwable> throwable) {
        return Optional.empty();
    }
}

