/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.verifier.framework;

import com.facebook.presto.verifier.checksum.ChecksumResult;
import com.facebook.presto.verifier.checksum.ColumnMatchResult;
import com.facebook.presto.verifier.framework.MatchResult;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.OptionalLong;

public class DataMatchResult
implements MatchResult {
    private final DataType dataType;
    private final MatchType matchType;
    private final Optional<ChecksumResult> controlChecksum;
    private final OptionalLong controlRowCount;
    private final OptionalLong testRowCount;
    private final List<ColumnMatchResult<?>> mismatchedColumns;

    public DataMatchResult(DataType dataType, MatchType matchType, Optional<ChecksumResult> controlChecksum, OptionalLong controlRowCount, OptionalLong testRowCount, List<ColumnMatchResult<?>> mismatchedColumns) {
        this.dataType = Objects.requireNonNull(dataType, "data type is null");
        this.matchType = Objects.requireNonNull(matchType, "match type is null");
        this.controlChecksum = Objects.requireNonNull(controlChecksum, "controlChecksum is null");
        this.controlRowCount = Objects.requireNonNull(controlRowCount, "controlRowCount is null");
        this.testRowCount = Objects.requireNonNull(testRowCount, "testRowCount is null");
        this.mismatchedColumns = ImmutableList.copyOf(mismatchedColumns);
    }

    @Override
    public boolean isMatched() {
        return this.matchType == MatchType.MATCH;
    }

    @Override
    public String getDataType() {
        return this.dataType.name();
    }

    @Override
    public String getMatchTypeName() {
        return this.matchType.name();
    }

    @Override
    public boolean isMismatchPossiblyCausedByNonDeterminism() {
        return this.matchType == MatchType.ROW_COUNT_MISMATCH || this.matchType == MatchType.COLUMN_MISMATCH;
    }

    public MatchType getMatchType() {
        return this.matchType;
    }

    public ChecksumResult getControlChecksum() {
        Preconditions.checkState((boolean)this.controlChecksum.isPresent(), (Object)"controlChecksum is missing");
        return this.controlChecksum.get();
    }

    public List<ColumnMatchResult<?>> getMismatchedColumns() {
        return this.mismatchedColumns;
    }

    @Override
    public String getReport() {
        StringBuilder message = new StringBuilder().append(this.matchType.name().replace("_", " ")).append('\n');
        if (this.matchType == MatchType.SCHEMA_MISMATCH || this.matchType == MatchType.SNAPSHOT_DOES_NOT_EXIST) {
            return message.toString();
        }
        Preconditions.checkState((boolean)this.controlRowCount.isPresent(), (Object)"controlRowCount is missing");
        Preconditions.checkState((boolean)this.testRowCount.isPresent(), (Object)"testRowCount is missing");
        message.append(String.format("Control %s rows, Test %s rows%n", this.controlRowCount.getAsLong(), this.testRowCount.getAsLong()));
        if (this.matchType == MatchType.ROW_COUNT_MISMATCH) {
            return message.toString();
        }
        message.append("Mismatched Columns:\n");
        this.mismatchedColumns.forEach(columnMismatch -> message.append(String.format("  %s (%s)%s\n    control\t(%s)\n    test\t(%s)\n", columnMismatch.getColumn().getName(), columnMismatch.getColumn().getType().getDisplayName(), columnMismatch.getMessage().map(columnMessage -> " " + columnMessage).orElse(""), columnMismatch.getControlChecksum(), columnMismatch.getTestChecksum())));
        return message.toString();
    }

    public static enum MatchType {
        MATCH,
        SCHEMA_MISMATCH,
        ROW_COUNT_MISMATCH,
        COLUMN_MISMATCH,
        PARTITION_COUNT_MISMATCH,
        BUCKET_COUNT_MISMATCH,
        SNAPSHOT_DOES_NOT_EXIST;

    }

    public static enum DataType {
        DATA,
        PARTITION_DATA,
        BUCKET_DATA;

    }
}

