/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.verifier.framework;

import com.facebook.presto.sql.parser.SqlParser;
import com.facebook.presto.sql.tree.CreateView;
import com.facebook.presto.sql.tree.QualifiedName;
import com.facebook.presto.sql.tree.ShowCreate;
import com.facebook.presto.sql.tree.Statement;
import com.facebook.presto.verifier.framework.ClusterType;
import com.facebook.presto.verifier.framework.DdlVerification;
import com.facebook.presto.verifier.framework.QueryObjectBundle;
import com.facebook.presto.verifier.framework.SnapshotQuery;
import com.facebook.presto.verifier.framework.SourceQuery;
import com.facebook.presto.verifier.framework.VerificationContext;
import com.facebook.presto.verifier.framework.VerifierConfig;
import com.facebook.presto.verifier.prestoaction.PrestoAction;
import com.facebook.presto.verifier.prestoaction.QueryActions;
import com.facebook.presto.verifier.prestoaction.SqlExceptionClassifier;
import com.facebook.presto.verifier.rewrite.QueryRewriter;
import com.facebook.presto.verifier.source.SnapshotQueryConsumer;
import com.google.common.util.concurrent.ListeningExecutorService;
import java.sql.SQLException;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;

public class CreateViewVerification
extends DdlVerification<CreateView> {
    public static final PrestoAction.ResultSetConverter<String> SHOW_CREATE_VIEW_CONVERTER = resultSet -> {
        try {
            return Optional.of(resultSet.getString("Create View"));
        }
        catch (SQLException e) {
            throw new RuntimeException(e);
        }
    };
    private static final QualifiedName DUMMY_VIEW_NAME = QualifiedName.of((String)"dummy");
    private final QueryRewriter queryRewriter;

    public CreateViewVerification(SqlParser sqlParser, QueryActions queryActions, SourceQuery sourceQuery, QueryRewriter queryRewriter, SqlExceptionClassifier exceptionClassifier, VerificationContext verificationContext, VerifierConfig verifierConfig, ListeningExecutorService executor, SnapshotQueryConsumer snapshotQueryConsumer, Map<String, SnapshotQuery> snapshotQueries) {
        super(sqlParser, queryActions, sourceQuery, exceptionClassifier, verificationContext, verifierConfig, SHOW_CREATE_VIEW_CONVERTER, executor, snapshotQueryConsumer, snapshotQueries);
        this.queryRewriter = Objects.requireNonNull(queryRewriter, "queryRewriter is null");
    }

    @Override
    protected QueryObjectBundle getQueryRewrite(ClusterType clusterType) {
        return this.queryRewriter.rewriteQuery(this.getSourceQuery().getQuery(clusterType), clusterType);
    }

    @Override
    protected Statement getChecksumQuery(QueryObjectBundle queryBundle) {
        return new ShowCreate(ShowCreate.Type.VIEW, queryBundle.getObjectName());
    }

    @Override
    protected boolean match(CreateView controlObject, CreateView testObject, QueryObjectBundle control, QueryObjectBundle test) {
        controlObject = new CreateView(DUMMY_VIEW_NAME, controlObject.getQuery(), controlObject.isReplace(), controlObject.getSecurity());
        testObject = new CreateView(DUMMY_VIEW_NAME, testObject.getQuery(), testObject.isReplace(), testObject.getSecurity());
        return Objects.equals(controlObject, testObject);
    }
}

