/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.verifier.checksum;

import com.facebook.presto.common.type.ArrayType;
import com.facebook.presto.common.type.DoubleType;
import com.facebook.presto.common.type.RowType;
import com.facebook.presto.common.type.Type;
import com.facebook.presto.sql.QueryUtil;
import com.facebook.presto.sql.tree.ArithmeticUnaryExpression;
import com.facebook.presto.sql.tree.Cast;
import com.facebook.presto.sql.tree.CoalesceExpression;
import com.facebook.presto.sql.tree.ComparisonExpression;
import com.facebook.presto.sql.tree.Expression;
import com.facebook.presto.sql.tree.Identifier;
import com.facebook.presto.sql.tree.LambdaArgumentDeclaration;
import com.facebook.presto.sql.tree.LambdaExpression;
import com.facebook.presto.sql.tree.LongLiteral;
import com.facebook.presto.sql.tree.SingleColumn;
import com.facebook.presto.sql.tree.TryExpression;
import com.facebook.presto.verifier.checksum.ArrayColumnChecksum;
import com.facebook.presto.verifier.checksum.ChecksumResult;
import com.facebook.presto.verifier.checksum.ColumnMatchResult;
import com.facebook.presto.verifier.checksum.ColumnValidator;
import com.facebook.presto.verifier.checksum.FloatingPointColumnChecksum;
import com.facebook.presto.verifier.checksum.FloatingPointColumnValidator;
import com.facebook.presto.verifier.framework.Column;
import com.facebook.presto.verifier.framework.VerifierConfig;
import com.facebook.presto.verifier.framework.VerifierUtil;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import javax.inject.Inject;

public class ArrayColumnValidator
implements ColumnValidator {
    private final FloatingPointColumnValidator floatingPointValidator;
    private final boolean useErrorMarginForFloatingPointArrays;

    @Inject
    public ArrayColumnValidator(VerifierConfig config, FloatingPointColumnValidator floatingPointValidator) {
        this.floatingPointValidator = Objects.requireNonNull(floatingPointValidator, "floatingPointValidator is null");
        this.useErrorMarginForFloatingPointArrays = config.isUseErrorMarginForFloatingPointArrays();
    }

    @Override
    public List<SingleColumn> generateChecksumColumns(Column column) {
        Type columnType = column.getType();
        boolean useFloatingPointPath = this.useFloatingPointPath(column);
        if (useFloatingPointPath) {
            Type elementType = ((ArrayType)columnType).getElementType();
            Expression expression = elementType.equals(DoubleType.DOUBLE) ? column.getExpression() : new Cast(column.getExpression(), new ArrayType((Type)DoubleType.DOUBLE).getDisplayName());
            Expression sum = QueryUtil.functionCall((String)"sum", (Expression[])new Expression[]{QueryUtil.functionCall((String)"array_sum", (Expression[])new Expression[]{QueryUtil.functionCall((String)"filter", (Expression[])new Expression[]{expression, ArrayColumnValidator.generateLambdaExpression("is_finite")})})});
            Expression nanCount = QueryUtil.functionCall((String)"sum", (Expression[])new Expression[]{QueryUtil.functionCall((String)"cardinality", (Expression[])new Expression[]{QueryUtil.functionCall((String)"filter", (Expression[])new Expression[]{expression, ArrayColumnValidator.generateLambdaExpression("is_nan")})})});
            Expression posInfCount = QueryUtil.functionCall((String)"sum", (Expression[])new Expression[]{QueryUtil.functionCall((String)"cardinality", (Expression[])new Expression[]{QueryUtil.functionCall((String)"filter", (Expression[])new Expression[]{expression, ArrayColumnValidator.generateInfinityLambdaExpression(ArithmeticUnaryExpression.Sign.PLUS)})})});
            Expression negInfCount = QueryUtil.functionCall((String)"sum", (Expression[])new Expression[]{QueryUtil.functionCall((String)"cardinality", (Expression[])new Expression[]{QueryUtil.functionCall((String)"filter", (Expression[])new Expression[]{expression, ArrayColumnValidator.generateInfinityLambdaExpression(ArithmeticUnaryExpression.Sign.MINUS)})})});
            Expression arrayCardinalityChecksum = QueryUtil.functionCall((String)"checksum", (Expression[])new Expression[]{QueryUtil.functionCall((String)"cardinality", (Expression[])new Expression[]{expression})});
            CoalesceExpression arrayCardinalitySum = new CoalesceExpression(QueryUtil.functionCall((String)"sum", (Expression[])new Expression[]{QueryUtil.functionCall((String)"cardinality", (Expression[])new Expression[]{expression})}), (Expression)new LongLiteral("0"), new Expression[0]);
            return ImmutableList.of((Object)new SingleColumn(sum, Optional.of(VerifierUtil.delimitedIdentifier(FloatingPointColumnValidator.getSumColumnAlias(column)))), (Object)new SingleColumn(nanCount, Optional.of(VerifierUtil.delimitedIdentifier(FloatingPointColumnValidator.getNanCountColumnAlias(column)))), (Object)new SingleColumn(posInfCount, Optional.of(VerifierUtil.delimitedIdentifier(FloatingPointColumnValidator.getPositiveInfinityCountColumnAlias(column)))), (Object)new SingleColumn(negInfCount, Optional.of(VerifierUtil.delimitedIdentifier(FloatingPointColumnValidator.getNegativeInfinityCountColumnAlias(column)))), (Object)new SingleColumn(arrayCardinalityChecksum, Optional.of(VerifierUtil.delimitedIdentifier(ArrayColumnValidator.getCardinalityChecksumColumnAlias(column)))), (Object)new SingleColumn((Expression)arrayCardinalitySum, Optional.of(VerifierUtil.delimitedIdentifier(ArrayColumnValidator.getCardinalitySumColumnAlias(column)))));
        }
        Expression checksum = ArrayColumnValidator.generateArrayChecksum(column.getExpression(), columnType);
        Expression arrayCardinalityChecksum = QueryUtil.functionCall((String)"checksum", (Expression[])new Expression[]{QueryUtil.functionCall((String)"cardinality", (Expression[])new Expression[]{column.getExpression()})});
        CoalesceExpression arrayCardinalitySum = new CoalesceExpression(QueryUtil.functionCall((String)"sum", (Expression[])new Expression[]{QueryUtil.functionCall((String)"cardinality", (Expression[])new Expression[]{column.getExpression()})}), (Expression)new LongLiteral("0"), new Expression[0]);
        return ImmutableList.of((Object)new SingleColumn(checksum, Optional.of(VerifierUtil.delimitedIdentifier(ArrayColumnValidator.getChecksumColumnAlias(column)))), (Object)new SingleColumn(arrayCardinalityChecksum, Optional.of(VerifierUtil.delimitedIdentifier(ArrayColumnValidator.getCardinalityChecksumColumnAlias(column)))), (Object)new SingleColumn((Expression)arrayCardinalitySum, Optional.of(VerifierUtil.delimitedIdentifier(ArrayColumnValidator.getCardinalitySumColumnAlias(column)))));
    }

    public List<ColumnMatchResult<ArrayColumnChecksum>> validate(Column column, ChecksumResult controlResult, ChecksumResult testResult) {
        Preconditions.checkArgument((controlResult.getRowCount() == testResult.getRowCount() ? 1 : 0) != 0, (String)"Test row count (%s) does not match control row count (%s)", (long)testResult.getRowCount(), (long)controlResult.getRowCount());
        boolean useFloatingPointPath = this.useFloatingPointPath(column);
        ArrayColumnChecksum controlChecksum = ArrayColumnValidator.toColumnChecksum(column, controlResult, useFloatingPointPath);
        ArrayColumnChecksum testChecksum = ArrayColumnValidator.toColumnChecksum(column, testResult, useFloatingPointPath);
        if (!useFloatingPointPath) {
            return ImmutableList.of(new ColumnMatchResult<ArrayColumnChecksum>(Objects.equals(controlChecksum, testChecksum), column, controlChecksum, testChecksum));
        }
        if (!Objects.equals(controlChecksum.getCardinalityChecksum(), testChecksum.getCardinalityChecksum()) || !Objects.equals(controlChecksum.getCardinalitySum(), testChecksum.getCardinalitySum())) {
            return ImmutableList.of(new ColumnMatchResult<ArrayColumnChecksum>(false, column, Optional.of("cardinality mismatch"), controlChecksum, testChecksum));
        }
        ColumnMatchResult<FloatingPointColumnChecksum> result = this.floatingPointValidator.validate(column, controlChecksum.getFloatingPointChecksum(), testChecksum.getFloatingPointChecksum());
        return ImmutableList.of(new ColumnMatchResult<ArrayColumnChecksum>(result.isMatched(), column, result.getMessage(), controlChecksum, testChecksum));
    }

    public static Expression generateArrayChecksum(Expression column, Type type) {
        Preconditions.checkArgument((boolean)(type instanceof ArrayType), (String)"Expect ArrayType, found %s", (Object)type.getDisplayName());
        Type elementType = ((ArrayType)type).getElementType();
        if (elementType.isOrderable()) {
            Expression arraySort = QueryUtil.functionCall((String)"array_sort", (Expression[])new Expression[]{column});
            if (elementType instanceof ArrayType || elementType instanceof RowType) {
                return new CoalesceExpression(QueryUtil.functionCall((String)"checksum", (Expression[])new Expression[]{new TryExpression(arraySort)}), QueryUtil.functionCall((String)"checksum", (Expression[])new Expression[]{column}), new Expression[0]);
            }
            return QueryUtil.functionCall((String)"checksum", (Expression[])new Expression[]{arraySort});
        }
        return QueryUtil.functionCall((String)"checksum", (Expression[])new Expression[]{column});
    }

    private static Expression generateInfinityLambdaExpression(ArithmeticUnaryExpression.Sign sign) {
        ComparisonExpression lambdaBody = new ComparisonExpression(ComparisonExpression.Operator.EQUAL, (Expression)new Identifier("x"), (Expression)new ArithmeticUnaryExpression(sign, QueryUtil.functionCall((String)"infinity", (Expression[])new Expression[0])));
        return new LambdaExpression((List)ImmutableList.of((Object)new LambdaArgumentDeclaration(QueryUtil.identifier((String)"x"))), (Expression)lambdaBody);
    }

    private static Expression generateLambdaExpression(String functionName) {
        return new LambdaExpression((List)ImmutableList.of((Object)new LambdaArgumentDeclaration(QueryUtil.identifier((String)"x"))), QueryUtil.functionCall((String)functionName, (Expression[])new Expression[]{new Identifier("x")}));
    }

    private static ArrayColumnChecksum toColumnChecksum(Column column, ChecksumResult checksumResult, boolean useFloatingPointPath) {
        if (!useFloatingPointPath) {
            return new ArrayColumnChecksum(checksumResult.getChecksum(ArrayColumnValidator.getChecksumColumnAlias(column)), checksumResult.getChecksum(ArrayColumnValidator.getCardinalityChecksumColumnAlias(column)), (Long)checksumResult.getChecksum(ArrayColumnValidator.getCardinalitySumColumnAlias(column)), Optional.empty());
        }
        Object nanCount = checksumResult.getChecksum(FloatingPointColumnValidator.getNanCountColumnAlias(column));
        if (Objects.isNull(nanCount)) {
            return new ArrayColumnChecksum(null, null, 0L, Optional.of(new FloatingPointColumnChecksum(null, 0L, 0L, 0L, 0L)));
        }
        long cardinalitySum = (Long)checksumResult.getChecksum(ArrayColumnValidator.getCardinalitySumColumnAlias(column));
        return new ArrayColumnChecksum(null, checksumResult.getChecksum(ArrayColumnValidator.getCardinalityChecksumColumnAlias(column)), cardinalitySum, Optional.of(new FloatingPointColumnChecksum(checksumResult.getChecksum(FloatingPointColumnValidator.getSumColumnAlias(column)), (Long)nanCount, (Long)checksumResult.getChecksum(FloatingPointColumnValidator.getPositiveInfinityCountColumnAlias(column)), (Long)checksumResult.getChecksum(FloatingPointColumnValidator.getNegativeInfinityCountColumnAlias(column)), cardinalitySum)));
    }

    private boolean useFloatingPointPath(Column column) {
        Type columnType = column.getType();
        Preconditions.checkArgument((boolean)(columnType instanceof ArrayType), (String)"Expect ArrayType, found %s", (Object)columnType.getDisplayName());
        Type elementType = ((ArrayType)columnType).getElementType();
        return this.useErrorMarginForFloatingPointArrays && Column.FLOATING_POINT_TYPES.contains(elementType);
    }

    private static String getChecksumColumnAlias(Column column) {
        return column.getName() + "$checksum";
    }

    private static String getCardinalityChecksumColumnAlias(Column column) {
        return column.getName() + "$cardinality_checksum";
    }

    private static String getCardinalitySumColumnAlias(Column column) {
        return column.getName() + "$cardinality_sum";
    }
}

