/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.verifier.checksum;

import com.facebook.presto.verifier.checksum.FloatingPointColumnChecksum;
import com.facebook.presto.verifier.checksum.StructureColumnChecksum;
import com.google.common.base.Preconditions;
import java.util.Objects;
import java.util.Optional;
import javax.annotation.Nullable;

public class ArrayColumnChecksum
extends StructureColumnChecksum {
    private final Object checksum;
    private final Object cardinalityChecksum;
    private final long cardinalitySum;
    private final Optional<FloatingPointColumnChecksum> floatingPointChecksum;

    public ArrayColumnChecksum(@Nullable Object checksum, @Nullable Object cardinalityChecksum, long cardinalitySum, Optional<FloatingPointColumnChecksum> floatingPointChecksum) {
        this.checksum = checksum;
        this.cardinalityChecksum = cardinalityChecksum;
        this.cardinalitySum = cardinalitySum;
        this.floatingPointChecksum = floatingPointChecksum;
    }

    @Nullable
    public Object getChecksum() {
        return this.checksum;
    }

    @Override
    @Nullable
    public Object getCardinalityChecksum() {
        return this.cardinalityChecksum;
    }

    @Override
    public long getCardinalitySum() {
        return this.cardinalitySum;
    }

    public FloatingPointColumnChecksum getFloatingPointChecksum() {
        Preconditions.checkArgument((boolean)this.floatingPointChecksum.isPresent(), (Object)"Expect Floating Point Checksum to be present, but it is not");
        return this.floatingPointChecksum.get();
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        ArrayColumnChecksum o = (ArrayColumnChecksum)obj;
        return Objects.equals(this.checksum, o.checksum) && Objects.equals(this.floatingPointChecksum, o.floatingPointChecksum) && Objects.equals(this.cardinalityChecksum, o.cardinalityChecksum) && Objects.equals(this.cardinalitySum, o.cardinalitySum);
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.checksum, this.floatingPointChecksum, this.cardinalityChecksum, this.cardinalitySum);
    }

    @Override
    public String toString() {
        if (!this.floatingPointChecksum.isPresent()) {
            return String.format("checksum: %s, cardinality_checksum: %s, cardinality_sum: %s", this.checksum, this.cardinalityChecksum, this.cardinalitySum);
        }
        return String.format("%s, cardinality_checksum: %s, cardinality_sum: %s", this.floatingPointChecksum.get(), this.cardinalityChecksum, this.cardinalitySum);
    }
}

