/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.verifier.source;

import com.facebook.airlift.configuration.Config;
import com.facebook.airlift.configuration.ConfigDescription;
import com.google.common.base.Splitter;
import com.google.common.collect.ImmutableList;
import java.util.List;
import javax.validation.constraints.NotNull;

public class MySqlSourceQueryConfig {
    private String database = "jdbc:mysql://localhost:3306";
    private String tableName = "verifier_queries";
    private String snapshotTableName = "verifier_snapshots";
    private List<String> suites = ImmutableList.of();
    private int maxQueriesPerSuite = 100000;

    @NotNull
    public String getDatabase() {
        return this.database;
    }

    @Config(value="database")
    public MySqlSourceQueryConfig setDatabase(String database) {
        this.database = database;
        return this;
    }

    @NotNull
    public String getTableName() {
        return this.tableName;
    }

    @Config(value="table-name")
    public MySqlSourceQueryConfig setTableName(String tableName) {
        this.tableName = tableName;
        return this;
    }

    @NotNull
    public String getSnapshotTableName() {
        return this.snapshotTableName;
    }

    @Config(value="snapshot-table-name")
    public MySqlSourceQueryConfig setSnapshotTableName(String snapshotTabaleName) {
        this.snapshotTableName = snapshotTabaleName;
        return this;
    }

    @NotNull
    public List<String> getSuites() {
        return this.suites;
    }

    @ConfigDescription(value="The suites of queries in the query database to run")
    @Config(value="suites")
    public MySqlSourceQueryConfig setSuites(String suites) {
        if (suites != null) {
            this.suites = Splitter.on((char)',').trimResults().omitEmptyStrings().splitToList((CharSequence)suites);
        }
        return this;
    }

    public int getMaxQueriesPerSuite() {
        return this.maxQueriesPerSuite;
    }

    @ConfigDescription(value="The maximum number of queries to run for each suite")
    @Config(value="max-queries-per-suite")
    public MySqlSourceQueryConfig setMaxQueriesPerSuite(int maxQueriesPerSuite) {
        this.maxQueriesPerSuite = maxQueriesPerSuite;
        return this;
    }
}

