/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.verifier.source;

import com.facebook.presto.verifier.framework.SnapshotQuery;
import com.facebook.presto.verifier.source.SnapshotQueryConsumer;
import com.facebook.presto.verifier.source.VerifierDao;
import java.util.Objects;
import javax.inject.Provider;
import org.jdbi.v3.core.Handle;
import org.jdbi.v3.core.Jdbi;

public abstract class AbstractJdbiSnapshotQueryConsumer
implements SnapshotQueryConsumer {
    private final Provider<Jdbi> jdbiProvider;
    private final String tableName;

    public AbstractJdbiSnapshotQueryConsumer(Provider<Jdbi> jdbiProvider, String tableName) {
        this.jdbiProvider = Objects.requireNonNull(jdbiProvider, "jdbiProvider is null");
        this.tableName = Objects.requireNonNull(tableName, "tableName is null");
    }

    @Override
    public void accept(SnapshotQuery snapshot) {
        try (Handle handle = ((Jdbi)this.jdbiProvider.get()).open();){
            VerifierDao verifierDao = (VerifierDao)handle.attach(VerifierDao.class);
            verifierDao.saveSnapShot(this.tableName, snapshot.getSuite(), snapshot.getName(), snapshot.isExplain(), snapshot.getSnapshot());
        }
    }
}

