/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.verifier.rewrite;

import com.facebook.presto.sql.ExpressionFormatter;
import com.facebook.presto.sql.tree.Expression;
import com.facebook.presto.sql.tree.ExpressionRewriter;
import com.facebook.presto.sql.tree.ExpressionTreeRewriter;
import com.facebook.presto.sql.tree.FunctionCall;
import com.facebook.presto.sql.tree.Node;
import com.facebook.presto.sql.tree.QualifiedName;
import com.facebook.presto.sql.tree.Query;
import com.facebook.presto.sql.tree.SubqueryExpression;
import com.facebook.presto.verifier.rewrite.DefaultTreeRewriter;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;

public class FunctionCallRewriter
extends DefaultTreeRewriter<Context> {
    private static final Pattern FUNCTION_CALL_PATTERN = Pattern.compile("(\\w+)\\(([\\w|,]+)\\)");
    private static final Pattern FUNCTION_CALL_SUBSTITUTION_PATTERN = Pattern.compile(String.format("/%s/%s/", FUNCTION_CALL_PATTERN, FUNCTION_CALL_PATTERN));
    private final Map<QualifiedName, FunctionCallSubstitute> functionCallSubstituteMap;
    private List<List<FunctionCall>> processedFunctionCallSubstitutes = ImmutableList.of();

    private FunctionCallRewriter(Map<QualifiedName, FunctionCallSubstitute> functionCallSubstituteMap) {
        this.functionCallSubstituteMap = Objects.requireNonNull(functionCallSubstituteMap, "functionCallSubstituteMap is null.");
    }

    public static FunctionCallRewriter getInstance(String functionCallSubstitutes) {
        Map<QualifiedName, FunctionCallSubstitute> functionCallSubstituteMap = FunctionCallRewriter.constructFunctionCallSubstituteMap(functionCallSubstitutes);
        return functionCallSubstituteMap.isEmpty() ? null : new FunctionCallRewriter(functionCallSubstituteMap);
    }

    public static boolean validateFunctionCallSubstitutes(String functionCallSubstitutes) {
        if (functionCallSubstitutes == null) {
            return false;
        }
        Matcher matcher = FUNCTION_CALL_SUBSTITUTION_PATTERN.matcher(functionCallSubstitutes);
        return matcher.find();
    }

    public static Map<QualifiedName, FunctionCallSubstitute> constructFunctionCallSubstituteMap(String functionCallSubstitutes) {
        ImmutableMap.Builder map = ImmutableMap.builder();
        if (functionCallSubstitutes == null) {
            return map.build();
        }
        Matcher matcher = FUNCTION_CALL_SUBSTITUTION_PATTERN.matcher(functionCallSubstitutes);
        while (matcher.find()) {
            String originalName = matcher.group(1);
            ImmutableList originalArgumentList = ImmutableList.copyOf((Object[])matcher.group(2).split(","));
            String substituteName = matcher.group(3);
            ImmutableList substituteArgumentList = ImmutableList.copyOf((Object[])matcher.group(4).split(","));
            List<Integer> originalArgumentIndices = substituteArgumentList.stream().map(((List)originalArgumentList)::indexOf).collect(Collectors.toList());
            FunctionCallSubstitute substitute = new FunctionCallSubstitute(QualifiedName.of((String)substituteName), originalArgumentIndices);
            map.put((Object)QualifiedName.of((String)originalName), (Object)substitute);
        }
        return map.build();
    }

    public Node rewrite(Node root) {
        Context context = new Context();
        Node rewritten = (Node)this.process(root, context);
        this.processedFunctionCallSubstitutes = context.getFunctionCallSubstitutes();
        return rewritten;
    }

    public String getProcessedFunctionCallSubstitutes() {
        return this.processedFunctionCallSubstitutes.stream().map(functionCallSubstitute -> {
            String formattedOriginal = ExpressionFormatter.formatExpression((Expression)((Expression)functionCallSubstitute.get(0)), Optional.empty());
            String formattedSubstitute = ExpressionFormatter.formatExpression((Expression)((Expression)functionCallSubstitute.get(1)), Optional.empty());
            return String.format("% is substituted with %s", formattedOriginal, formattedSubstitute);
        }).collect(Collectors.joining(", "));
    }

    @Override
    protected Node visitExpression(Expression node, final Context context) {
        final FunctionCallRewriter nodeRewritter = this;
        return ExpressionTreeRewriter.rewriteWith((ExpressionRewriter)new ExpressionRewriter<Void>(){

            public Expression rewriteFunctionCall(FunctionCall expression, Void voidContext, ExpressionTreeRewriter<Void> treeRewriter) {
                if (!FunctionCallRewriter.this.functionCallSubstituteMap.containsKey(expression.getName())) {
                    return expression;
                }
                FunctionCall defaultRewrite = (FunctionCall)treeRewriter.defaultRewrite((Expression)expression, (Object)voidContext);
                FunctionCallSubstitute substitute = (FunctionCallSubstitute)FunctionCallRewriter.this.functionCallSubstituteMap.get(expression.getName());
                List originalArguments = expression.getArguments();
                List rewrittenArguments = (List)substitute.originalArgumentIndices.stream().map(originalIndex -> {
                    Expression originalArgument = (Expression)originalArguments.get((int)originalIndex);
                    return treeRewriter.rewrite(originalArgument, (Object)voidContext);
                }).collect(ImmutableList.toImmutableList());
                FunctionCall rewritten = new FunctionCall(substitute.name, defaultRewrite.getWindow(), defaultRewrite.getFilter(), defaultRewrite.getOrderBy(), defaultRewrite.isDistinct(), defaultRewrite.isIgnoreNulls(), rewrittenArguments);
                context.addFunctionCallSubstitute(expression, rewritten);
                return rewritten;
            }

            public Expression rewriteSubqueryExpression(SubqueryExpression expression, Void voidContext, ExpressionTreeRewriter<Void> treeRewriter) {
                Node query = (Node)nodeRewritter.process((Node)expression.getQuery(), context);
                if (expression.getQuery() == query) {
                    return expression;
                }
                return new SubqueryExpression((Query)query);
            }
        }, (Expression)node);
    }

    public static class Context {
        private List<List<FunctionCall>> functionCallSubstitutes = new ArrayList<List<FunctionCall>>();

        public void addFunctionCallSubstitute(FunctionCall original, FunctionCall substitute) {
            this.functionCallSubstitutes.add(Arrays.asList(original, substitute));
        }

        public List<List<FunctionCall>> getFunctionCallSubstitutes() {
            return ImmutableList.copyOf(this.functionCallSubstitutes);
        }
    }

    public static class FunctionCallSubstitute {
        private final QualifiedName name;
        private final List<Integer> originalArgumentIndices;

        public FunctionCallSubstitute(QualifiedName name, List<Integer> originalArgumentIndices) {
            this.name = Objects.requireNonNull(name, "name is null");
            this.originalArgumentIndices = ImmutableList.copyOf((Collection)Objects.requireNonNull(originalArgumentIndices, "originalArgumentIndices is null"));
        }

        public QualifiedName name() {
            return this.name;
        }

        public List<Integer> originalArgumentIndices() {
            return this.originalArgumentIndices;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            FunctionCallSubstitute that = (FunctionCallSubstitute)o;
            return this.name.equals((Object)that.name) && Objects.equals(this.originalArgumentIndices, that.originalArgumentIndices);
        }

        public int hashCode() {
            return Objects.hash(this.name, this.originalArgumentIndices);
        }
    }
}

