/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.verifier.prestoaction;

import com.facebook.presto.verifier.annotation.ForControl;
import com.facebook.presto.verifier.annotation.ForHelper;
import com.facebook.presto.verifier.annotation.ForTest;
import com.facebook.presto.verifier.framework.SourceQuery;
import com.facebook.presto.verifier.framework.VerificationContext;
import com.facebook.presto.verifier.prestoaction.PrestoActionFactory;
import com.facebook.presto.verifier.prestoaction.QueryActionFactory;
import com.facebook.presto.verifier.prestoaction.QueryActions;
import com.facebook.presto.verifier.prestoaction.QueryActionsFactory;
import com.google.inject.Inject;
import java.util.Objects;

public class QueryActionsProvider
implements QueryActionsFactory {
    private final PrestoActionFactory helpActionFactory;
    private final QueryActionFactory controlActionFactory;
    private final QueryActionFactory testActionFactory;

    @Inject
    public QueryActionsProvider(@ForHelper PrestoActionFactory helpActionFactory, @ForControl QueryActionFactory controlActionFactory, @ForTest QueryActionFactory testActionFactory) {
        this.helpActionFactory = Objects.requireNonNull(helpActionFactory, "helpActionFactory is null");
        this.controlActionFactory = Objects.requireNonNull(controlActionFactory, "controlActionFactory is null");
        this.testActionFactory = Objects.requireNonNull(testActionFactory, "testActionFactory is null");
    }

    @Override
    public QueryActions create(SourceQuery sourceQuery, VerificationContext verificationContext) {
        return new QueryActions(this.helpActionFactory.create(sourceQuery.getControlConfiguration(), verificationContext), this.controlActionFactory.create(sourceQuery.getControlConfiguration(), verificationContext), this.testActionFactory.create(sourceQuery.getTestConfiguration(), verificationContext));
    }
}

