/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.verifier.framework;

import com.facebook.presto.verifier.framework.ClusterType;
import com.facebook.presto.verifier.framework.QueryConfiguration;
import com.google.common.base.MoreObjects;
import com.google.common.base.Preconditions;
import java.util.Objects;
import org.jdbi.v3.core.mapper.Nested;
import org.jdbi.v3.core.mapper.reflect.ColumnName;
import org.jdbi.v3.core.mapper.reflect.JdbiConstructor;

public class SourceQuery {
    private final String suite;
    private final String name;
    private final String controlQuery;
    private final String testQuery;
    private final QueryConfiguration controlConfiguration;
    private final QueryConfiguration testConfiguration;

    @JdbiConstructor
    public SourceQuery(@ColumnName(value="suite") String suite, @ColumnName(value="name") String name, @ColumnName(value="controlQuery") String controlQuery, @ColumnName(value="testQuery") String testQuery, @Nested(value="control") QueryConfiguration controlConfiguration, @Nested(value="test") QueryConfiguration testConfiguration) {
        this.suite = Objects.requireNonNull(suite, "suite is null");
        this.name = Objects.requireNonNull(name, "name is null");
        this.controlQuery = SourceQuery.clean(controlQuery);
        this.testQuery = SourceQuery.clean(testQuery);
        this.controlConfiguration = Objects.requireNonNull(controlConfiguration, "controlConfiguration is null");
        this.testConfiguration = Objects.requireNonNull(testConfiguration, "testConfiguration is null");
    }

    public String getSuite() {
        return this.suite;
    }

    public String getName() {
        return this.name;
    }

    public String getQuery(ClusterType clusterType) {
        Preconditions.checkArgument((clusterType == ClusterType.CONTROL || clusterType == ClusterType.TEST ? 1 : 0) != 0, (String)"Invalid ClusterType: %s", (Object)((Object)clusterType));
        return clusterType == ClusterType.CONTROL ? this.controlQuery : this.testQuery;
    }

    public QueryConfiguration getControlConfiguration() {
        return this.controlConfiguration;
    }

    public QueryConfiguration getTestConfiguration() {
        return this.testConfiguration;
    }

    private static String clean(String sql) {
        sql = sql.replaceAll("\t", "  ");
        sql = sql.replaceAll("\n+", "\n");
        sql = sql.trim();
        while (sql.endsWith(";")) {
            sql = sql.substring(0, sql.length() - 1).trim();
        }
        return sql;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        SourceQuery o = (SourceQuery)obj;
        return Objects.equals(this.suite, o.suite) && Objects.equals(this.name, o.name) && Objects.equals(this.controlQuery, o.controlQuery) && Objects.equals(this.testQuery, o.testQuery) && Objects.equals(this.controlConfiguration, o.controlConfiguration) && Objects.equals(this.testConfiguration, o.testConfiguration);
    }

    public int hashCode() {
        return Objects.hash(this.suite, this.name, this.controlQuery, this.testQuery, this.controlConfiguration, this.testConfiguration);
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("suite", (Object)this.suite).add("name", (Object)this.name).add("controlQuery", (Object)this.controlQuery).add("testQuery", (Object)this.testQuery).add("controlConfiguration", (Object)this.controlConfiguration).add("testConfiguration", (Object)this.testConfiguration).toString();
    }
}

