/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.verifier.framework;

import com.google.common.base.MoreObjects;
import java.util.Objects;
import org.jdbi.v3.core.mapper.reflect.ColumnName;
import org.jdbi.v3.core.mapper.reflect.JdbiConstructor;

public class SnapshotQuery {
    private final String suite;
    private final String name;
    private final boolean explain;
    private final String snapshot;

    @JdbiConstructor
    public SnapshotQuery(@ColumnName(value="suite") String suite, @ColumnName(value="name") String name, @ColumnName(value="is_explain") boolean explain, @ColumnName(value="snapshot") String snapshot) {
        this.suite = Objects.requireNonNull(suite, "suite is null");
        this.name = Objects.requireNonNull(name, "name is null");
        this.explain = Objects.requireNonNull(Boolean.valueOf(explain), "explain is null");
        this.snapshot = Objects.requireNonNull(snapshot, "snapshot is null");
    }

    public String getSuite() {
        return this.suite;
    }

    public String getName() {
        return this.name;
    }

    public boolean isExplain() {
        return this.explain;
    }

    public String getSnapshot() {
        return this.snapshot;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        SnapshotQuery o = (SnapshotQuery)obj;
        return Objects.equals(this.suite, o.suite) && Objects.equals(this.name, o.name) && Objects.equals(this.snapshot, o.snapshot);
    }

    public int hashCode() {
        return Objects.hash(this.suite, this.name, this.snapshot);
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("suite", (Object)this.suite).add("name", (Object)this.name).add("snapshot", (Object)this.snapshot).toString();
    }
}

