/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.verifier.framework;

import com.facebook.presto.sql.tree.CreateTable;
import com.facebook.presto.sql.tree.CreateTableAsSelect;
import com.facebook.presto.sql.tree.CreateView;
import com.facebook.presto.sql.tree.Insert;
import com.facebook.presto.sql.tree.Query;
import com.facebook.presto.sql.tree.Statement;
import java.util.Optional;

public enum QueryType {
    CREATE_TABLE_AS_SELECT(CreateTableAsSelect.class),
    INSERT(Insert.class),
    QUERY(Query.class),
    CREATE_VIEW(CreateView.class),
    CREATE_TABLE(CreateTable.class),
    UNSUPPORTED;

    private final Optional<Class<? extends Statement>> statementClass;

    private QueryType(Class<? extends Statement> statementClass) {
        this.statementClass = Optional.of(statementClass);
    }

    private QueryType() {
        this.statementClass = Optional.empty();
    }

    public static QueryType of(Statement statement) {
        for (QueryType queryType : QueryType.values()) {
            if (!queryType.statementClass.isPresent() || !queryType.statementClass.get().isAssignableFrom(statement.getClass())) continue;
            return queryType;
        }
        return UNSUPPORTED;
    }
}

