/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.verifier.framework;

import com.facebook.presto.common.ErrorCode;
import com.facebook.presto.spi.ErrorCodeSupplier;
import com.facebook.presto.verifier.framework.QueryException;
import com.facebook.presto.verifier.framework.QueryStage;
import com.facebook.presto.verifier.prestoaction.QueryActionStats;
import java.util.Objects;
import java.util.Optional;

public class PrestoQueryException
extends QueryException {
    private final Optional<ErrorCodeSupplier> errorCode;
    private final QueryActionStats queryActionStats;

    public PrestoQueryException(String message, boolean retryable, QueryStage queryStage, Optional<ErrorCodeSupplier> errorCode, QueryActionStats queryActionStats) {
        super(message, retryable, queryStage);
        this.errorCode = Objects.requireNonNull(errorCode, "errorCode is null");
        this.queryActionStats = Objects.requireNonNull(queryActionStats, "queryActionStats is null");
    }

    public PrestoQueryException(Throwable cause, boolean retryable, QueryStage queryStage, Optional<ErrorCodeSupplier> errorCode, QueryActionStats queryActionStats) {
        super(cause, retryable, queryStage);
        this.errorCode = Objects.requireNonNull(errorCode, "errorCode is null");
        this.queryActionStats = Objects.requireNonNull(queryActionStats, "queryActionStats is null");
    }

    public Optional<ErrorCodeSupplier> getErrorCode() {
        return this.errorCode;
    }

    public QueryActionStats getQueryActionStats() {
        return this.queryActionStats;
    }

    @Override
    public String getErrorCodeName() {
        return String.format("PRESTO(%s)", this.errorCode.map(ErrorCodeSupplier::toErrorCode).map(ErrorCode::getName).orElse("UNKNOWN"));
    }
}

