/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.verifier.framework;

import com.facebook.airlift.log.Logger;
import com.facebook.presto.common.type.TypeManager;
import com.facebook.presto.sql.SqlFormatter;
import com.facebook.presto.sql.tree.Node;
import com.facebook.presto.sql.tree.QualifiedName;
import com.facebook.presto.sql.tree.ShowColumns;
import com.facebook.presto.sql.tree.Statement;
import com.facebook.presto.verifier.checksum.ChecksumResult;
import com.facebook.presto.verifier.checksum.ChecksumValidator;
import com.facebook.presto.verifier.checksum.ColumnMatchResult;
import com.facebook.presto.verifier.framework.Column;
import com.facebook.presto.verifier.framework.DataMatchResult;
import com.facebook.presto.verifier.framework.QueryBundle;
import com.facebook.presto.verifier.framework.QueryStage;
import com.facebook.presto.verifier.framework.VerifierUtil;
import com.facebook.presto.verifier.prestoaction.PrestoAction;
import com.facebook.presto.verifier.prestoaction.QueryAction;
import com.facebook.presto.verifier.prestoaction.QueryActionStats;
import com.google.common.collect.ImmutableList;
import java.util.List;
import java.util.Locale;
import java.util.Objects;
import java.util.Optional;
import java.util.OptionalLong;
import java.util.function.Consumer;

public class DataVerificationUtil {
    private static final Logger log = Logger.get(DataVerificationUtil.class);

    private DataVerificationUtil() {
    }

    public static void teardownSafely(QueryAction queryAction, Optional<? extends QueryBundle> bundle, Consumer<QueryActionStats> queryStatsConsumer) {
        if (!bundle.isPresent()) {
            return;
        }
        for (Statement teardownQuery : bundle.get().getTeardownQueries()) {
            try {
                VerifierUtil.runAndConsume(() -> queryAction.execute(teardownQuery, QueryStage.forTeardown(((QueryBundle)bundle.get()).getCluster())), queryStatsConsumer);
            }
            catch (Throwable t) {
                log.warn("Failed to teardown %s: %s", new Object[]{bundle.get().getCluster().name().toLowerCase(Locale.ENGLISH), SqlFormatter.formatSql((Node)teardownQuery, Optional.empty())});
            }
        }
    }

    public static List<Column> getColumns(PrestoAction prestoAction, TypeManager typeManager, QualifiedName tableName) {
        return prestoAction.execute((Statement)new ShowColumns(tableName), QueryStage.DESCRIBE, resultSet -> Optional.of(Column.fromResultSet(typeManager, resultSet))).getResults();
    }

    public static DataMatchResult match(ChecksumValidator checksumValidator, List<Column> controlColumns, List<Column> testColumns, ChecksumResult controlChecksum, ChecksumResult testChecksum) {
        DataMatchResult.MatchType matchType;
        Object mismatchedColumns;
        Objects.requireNonNull(controlColumns, "controlColumns is null.");
        if (!controlColumns.equals(testColumns)) {
            return new DataMatchResult(DataMatchResult.MatchType.SCHEMA_MISMATCH, Optional.empty(), OptionalLong.empty(), OptionalLong.empty(), (List<ColumnMatchResult<?>>)ImmutableList.of());
        }
        OptionalLong controlRowCount = OptionalLong.of(controlChecksum.getRowCount());
        OptionalLong testRowCount = OptionalLong.of(testChecksum.getRowCount());
        if (controlChecksum.getRowCount() != testChecksum.getRowCount()) {
            mismatchedColumns = ImmutableList.of();
            matchType = DataMatchResult.MatchType.ROW_COUNT_MISMATCH;
        } else {
            mismatchedColumns = checksumValidator.getMismatchedColumns(controlColumns, controlChecksum, testChecksum);
            matchType = mismatchedColumns.isEmpty() ? DataMatchResult.MatchType.MATCH : DataMatchResult.MatchType.COLUMN_MISMATCH;
        }
        return new DataMatchResult(matchType, Optional.of(controlChecksum), controlRowCount, testRowCount, (List<ColumnMatchResult<?>>)mismatchedColumns);
    }
}

