/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.verifier.checksum;

import com.facebook.presto.common.type.SqlVarbinary;
import com.fasterxml.jackson.annotation.JsonTypeInfo;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.core.TreeNode;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JsonDeserializer;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.Module;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.deser.std.StdDeserializer;
import com.fasterxml.jackson.databind.jsontype.PolymorphicTypeValidator;
import com.fasterxml.jackson.databind.jsontype.impl.LaissezFaireSubTypeValidator;
import com.fasterxml.jackson.databind.module.SimpleModule;
import com.google.common.base.Preconditions;
import com.google.common.base.Suppliers;
import java.io.IOException;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Supplier;

public class ChecksumResult {
    private static final Supplier<ObjectMapper> OBJECT_MAPPER_SUPPLIER = Suppliers.memoize(() -> {
        ObjectMapper mapper = new ObjectMapper();
        mapper.activateDefaultTyping((PolymorphicTypeValidator)LaissezFaireSubTypeValidator.instance, ObjectMapper.DefaultTyping.NON_FINAL, JsonTypeInfo.As.WRAPPER_ARRAY);
        return mapper;
    });
    private static final String ROW_COUNT = "rowCount";
    private static final String CHECKSUMS = "checksums";
    private final long rowCount;
    private final Map<String, Object> checksums;

    public ChecksumResult(long rowCount, Map<String, Object> checksums) {
        this.rowCount = rowCount;
        this.checksums = Collections.unmodifiableMap(Objects.requireNonNull(checksums, "checksums is null"));
        for (Object checksum : checksums.values()) {
            Preconditions.checkArgument((checksum == null || checksum instanceof Long || checksum instanceof Double || checksum instanceof SqlVarbinary ? 1 : 0) != 0, (String)"checksum can only be one of (null, Long, Double, SqlVarbinary), found %s", (Object)(checksum == null ? "null" : checksum.getClass().getName()));
        }
    }

    public long getRowCount() {
        return this.rowCount;
    }

    public Map<String, Object> getChecksums() {
        return this.checksums;
    }

    public Object getChecksum(String columnName) {
        Preconditions.checkArgument((boolean)this.checksums.containsKey(columnName), (String)"column does not exist: %s", (Object)columnName);
        return this.checksums.get(columnName);
    }

    public static Optional<ChecksumResult> fromResultSet(ResultSet resultSet) throws SQLException {
        long rowCount = resultSet.getLong(1);
        ResultSetMetaData metaData = resultSet.getMetaData();
        HashMap<String, Object> checksums = new HashMap<String, Object>(metaData.getColumnCount());
        for (int i = 2; i <= metaData.getColumnCount(); ++i) {
            String columnName = metaData.getColumnName(i);
            Object checksum = resultSet.getObject(i);
            if (checksum == null) {
                checksums.put(columnName, null);
                continue;
            }
            if (metaData.getColumnType(i) == 8) {
                Preconditions.checkState((boolean)(checksum instanceof Double), (String)"Expecting double for column %s, found %s", (Object)columnName, checksum.getClass());
                checksums.put(columnName, checksum);
                continue;
            }
            if (metaData.getColumnType(i) == -5) {
                Preconditions.checkState((boolean)(checksum instanceof Long), (String)"Expecting bigint for column %s, found %s", (Object)columnName, checksum.getClass());
                checksums.put(columnName, checksum);
                continue;
            }
            Preconditions.checkState((boolean)(checksum instanceof byte[]), (String)"Expecting binary for column %s, found %s", (Object)columnName, checksum.getClass());
            checksums.put(columnName, new SqlVarbinary((byte[])checksum));
        }
        return Optional.of(new ChecksumResult(rowCount, checksums));
    }

    public static String toJson(ChecksumResult checksumResult) {
        Objects.requireNonNull(checksumResult, "checksumResult is null");
        try {
            String json = OBJECT_MAPPER_SUPPLIER.get().writerWithDefaultPrettyPrinter().writeValueAsString((Object)checksumResult);
            return json;
        }
        catch (JsonProcessingException exception) {
            throw new RuntimeException(exception);
        }
    }

    public static ChecksumResult fromJson(String json) {
        try {
            ObjectMapper objectMapper = OBJECT_MAPPER_SUPPLIER.get();
            SimpleModule module = new SimpleModule();
            module.addDeserializer(ChecksumResult.class, (JsonDeserializer)new ChecksumResultDeserializer());
            module.addDeserializer(SqlVarbinary.class, (JsonDeserializer)new SqlVarbinaryDeserializer());
            objectMapper.registerModule((Module)module);
            ChecksumResult checksumResult = (ChecksumResult)objectMapper.readValue(json, ChecksumResult.class);
            return checksumResult;
        }
        catch (JsonProcessingException exception) {
            throw new RuntimeException(exception);
        }
    }

    static class ChecksumResultDeserializer
    extends StdDeserializer<ChecksumResult> {
        public ChecksumResultDeserializer() {
            this(null);
        }

        public ChecksumResultDeserializer(Class<?> vc) {
            super(vc);
        }

        public ChecksumResult deserialize(JsonParser jp, DeserializationContext ctxt) throws IOException {
            JsonNode node = (JsonNode)jp.getCodec().readTree(jp);
            return new ChecksumResult(node.get(ChecksumResult.ROW_COUNT).asLong(), (Map)jp.getCodec().treeToValue((TreeNode)node.get(ChecksumResult.CHECKSUMS), Map.class));
        }
    }

    static class SqlVarbinaryDeserializer
    extends StdDeserializer<SqlVarbinary> {
        public SqlVarbinaryDeserializer() {
            this(null);
        }

        public SqlVarbinaryDeserializer(Class<?> vc) {
            super(vc);
        }

        public SqlVarbinary deserialize(JsonParser jp, DeserializationContext ctxt) throws IOException {
            JsonNode node = (JsonNode)jp.getCodec().readTree(jp);
            return new SqlVarbinary((byte[])jp.getCodec().treeToValue((TreeNode)node, byte[].class));
        }
    }
}

