/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.verifier.checksum;

import com.facebook.presto.common.type.ArrayType;
import com.facebook.presto.common.type.RowType;
import com.facebook.presto.common.type.Type;
import com.facebook.presto.sql.QueryUtil;
import com.facebook.presto.sql.tree.CoalesceExpression;
import com.facebook.presto.sql.tree.Expression;
import com.facebook.presto.sql.tree.FunctionCall;
import com.facebook.presto.sql.tree.LongLiteral;
import com.facebook.presto.sql.tree.QualifiedName;
import com.facebook.presto.sql.tree.SingleColumn;
import com.facebook.presto.sql.tree.TryExpression;
import com.facebook.presto.verifier.checksum.ArrayColumnChecksum;
import com.facebook.presto.verifier.checksum.ChecksumResult;
import com.facebook.presto.verifier.checksum.ColumnMatchResult;
import com.facebook.presto.verifier.checksum.ColumnValidator;
import com.facebook.presto.verifier.framework.Column;
import com.facebook.presto.verifier.framework.VerifierUtil;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import java.util.List;
import java.util.Objects;
import java.util.Optional;

public class ArrayColumnValidator
implements ColumnValidator {
    @Override
    public List<SingleColumn> generateChecksumColumns(Column column) {
        Expression checksum = ArrayColumnValidator.generateArrayChecksum(column.getExpression(), column.getType());
        Expression arrayCardinalityChecksum = QueryUtil.functionCall((String)"checksum", (Expression[])new Expression[]{QueryUtil.functionCall((String)"cardinality", (Expression[])new Expression[]{column.getExpression()})});
        CoalesceExpression arrayCardinalitySum = new CoalesceExpression(QueryUtil.functionCall((String)"sum", (Expression[])new Expression[]{QueryUtil.functionCall((String)"cardinality", (Expression[])new Expression[]{column.getExpression()})}), (Expression)new LongLiteral("0"), new Expression[0]);
        return ImmutableList.of((Object)new SingleColumn(checksum, Optional.of(VerifierUtil.delimitedIdentifier(ArrayColumnValidator.getChecksumColumnAlias(column)))), (Object)new SingleColumn(arrayCardinalityChecksum, Optional.of(VerifierUtil.delimitedIdentifier(ArrayColumnValidator.getCardinalityChecksumColumnAlias(column)))), (Object)new SingleColumn((Expression)arrayCardinalitySum, Optional.of(VerifierUtil.delimitedIdentifier(ArrayColumnValidator.getCardinalitySumColumnAlias(column)))));
    }

    public List<ColumnMatchResult<ArrayColumnChecksum>> validate(Column column, ChecksumResult controlResult, ChecksumResult testResult) {
        ArrayColumnChecksum controlChecksum = ArrayColumnValidator.toColumnChecksum(column, controlResult);
        ArrayColumnChecksum testChecksum = ArrayColumnValidator.toColumnChecksum(column, testResult);
        return ImmutableList.of(new ColumnMatchResult<ArrayColumnChecksum>(Objects.equals(controlChecksum, testChecksum), column, controlChecksum, testChecksum));
    }

    public static Expression generateArrayChecksum(Expression column, Type type) {
        Preconditions.checkArgument((boolean)(type instanceof ArrayType), (String)"Expect ArrayType, found %s", (Object)type.getDisplayName());
        Type elementType = ((ArrayType)type).getElementType();
        if (elementType.isOrderable()) {
            FunctionCall arraySort = new FunctionCall(QualifiedName.of((String)"array_sort"), (List)ImmutableList.of((Object)column));
            if (elementType instanceof ArrayType || elementType instanceof RowType) {
                return new CoalesceExpression((Expression)new FunctionCall(QualifiedName.of((String)"checksum"), (List)ImmutableList.of((Object)new TryExpression((Expression)arraySort))), (Expression)new FunctionCall(QualifiedName.of((String)"checksum"), (List)ImmutableList.of((Object)column)), new Expression[0]);
            }
            return new FunctionCall(QualifiedName.of((String)"checksum"), (List)ImmutableList.of((Object)arraySort));
        }
        return new FunctionCall(QualifiedName.of((String)"checksum"), (List)ImmutableList.of((Object)column));
    }

    private static ArrayColumnChecksum toColumnChecksum(Column column, ChecksumResult checksumResult) {
        return new ArrayColumnChecksum(checksumResult.getChecksum(ArrayColumnValidator.getChecksumColumnAlias(column)), checksumResult.getChecksum(ArrayColumnValidator.getCardinalityChecksumColumnAlias(column)), (Long)checksumResult.getChecksum(ArrayColumnValidator.getCardinalitySumColumnAlias(column)));
    }

    private static String getChecksumColumnAlias(Column column) {
        return column.getName() + "$checksum";
    }

    private static String getCardinalityChecksumColumnAlias(Column column) {
        return column.getName() + "$cardinality_checksum";
    }

    private static String getCardinalitySumColumnAlias(Column column) {
        return column.getName() + "$cardinality_sum";
    }
}

