/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.verifier.prestoaction;

import com.facebook.airlift.configuration.AbstractConfigurationAwareModule;
import com.facebook.airlift.configuration.ConfigBinder;
import com.facebook.presto.verifier.annotation.ForControl;
import com.facebook.presto.verifier.annotation.ForHelper;
import com.facebook.presto.verifier.annotation.ForTest;
import com.facebook.presto.verifier.framework.VerifierConfig;
import com.facebook.presto.verifier.prestoaction.JdbcPrestoActionFactory;
import com.facebook.presto.verifier.prestoaction.PrestoActionConfig;
import com.facebook.presto.verifier.prestoaction.PrestoActionFactory;
import com.facebook.presto.verifier.prestoaction.QueryActionFactory;
import com.facebook.presto.verifier.prestoaction.QueryActionsConfig;
import com.facebook.presto.verifier.prestoaction.QueryActionsFactory;
import com.facebook.presto.verifier.prestoaction.QueryActionsProvider;
import com.facebook.presto.verifier.prestoaction.SqlExceptionClassifier;
import com.facebook.presto.verifier.retry.ForClusterConnection;
import com.facebook.presto.verifier.retry.ForPresto;
import com.facebook.presto.verifier.retry.RetryConfig;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableSet;
import com.google.inject.Binder;
import com.google.inject.Inject;
import com.google.inject.Injector;
import com.google.inject.Key;
import com.google.inject.Scopes;
import java.lang.annotation.Annotation;
import java.util.Objects;
import java.util.Set;
import javax.inject.Provider;

public class QueryActionsModule
extends AbstractConfigurationAwareModule {
    private final SqlExceptionClassifier exceptionClassifier;
    private final Set<String> supportedQueryActionTypes;

    public QueryActionsModule(SqlExceptionClassifier exceptionClassifier, Set<String> customQueryActionTypes) {
        this.exceptionClassifier = Objects.requireNonNull(exceptionClassifier, "exceptionClassifier is null");
        this.supportedQueryActionTypes = ImmutableSet.builder().add((Object)"presto-jdbc").addAll(customQueryActionTypes).build();
    }

    protected void setup(Binder binder) {
        binder.bind(SqlExceptionClassifier.class).toInstance((Object)this.exceptionClassifier);
        binder.bind(QueryActionsFactory.class).to(QueryActionsProvider.class).in(Scopes.SINGLETON);
        ConfigBinder.configBinder((Binder)binder).bindConfig(RetryConfig.class, ForClusterConnection.class, "cluster-connection");
        ConfigBinder.configBinder((Binder)binder).bindConfig(RetryConfig.class, ForPresto.class, "presto");
        QueryActionsConfig config = (QueryActionsConfig)this.buildConfigObject(QueryActionsConfig.class);
        String controlQueryActionType = config.getControlQueryActionType();
        String testQueryActionType = config.getTestQueryActionType();
        Preconditions.checkArgument((boolean)this.supportedQueryActionTypes.contains(controlQueryActionType), (String)"Unsupported QueryAction type: %s", (Object)controlQueryActionType);
        Preconditions.checkArgument((boolean)this.supportedQueryActionTypes.contains(testQueryActionType), (String)"Unsupported QueryAction type: %s", (Object)testQueryActionType);
        if (controlQueryActionType.equals("presto-jdbc")) {
            ConfigBinder.configBinder((Binder)binder).bindConfig(PrestoActionConfig.class, ForControl.class, "control");
            binder.bind(QueryActionFactory.class).annotatedWith(ForControl.class).toProvider((Provider)new JdbcPrestoActionFactoryProvider(ForControl.class)).in(Scopes.SINGLETON);
        }
        if (testQueryActionType.equals("presto-jdbc")) {
            ConfigBinder.configBinder((Binder)binder).bindConfig(PrestoActionConfig.class, ForTest.class, "test");
            binder.bind(QueryActionFactory.class).annotatedWith(ForTest.class).toProvider((Provider)new JdbcPrestoActionFactoryProvider(ForTest.class)).in(Scopes.SINGLETON);
        }
        if (config.isRunHelperQueriesOnControl()) {
            Preconditions.checkArgument((boolean)controlQueryActionType.equals("presto-jdbc"), (Object)"Cannot run helper queries on control cluster because it is not a presto-jdbc action");
            binder.bind(PrestoActionFactory.class).annotatedWith(ForHelper.class).toProvider((Provider)new JdbcPrestoActionFactoryProvider(ForControl.class)).in(Scopes.SINGLETON);
        } else {
            ConfigBinder.configBinder((Binder)binder).bindConfig(PrestoActionConfig.class, ForHelper.class, "helper");
            binder.bind(PrestoActionFactory.class).annotatedWith(ForHelper.class).toProvider((Provider)new JdbcPrestoActionFactoryProvider(ForHelper.class)).in(Scopes.SINGLETON);
        }
    }

    public static class JdbcPrestoActionFactoryProvider
    implements Provider<PrestoActionFactory> {
        private final Class<? extends Annotation> annotationClass;
        private Injector injector;

        public JdbcPrestoActionFactoryProvider(Class<? extends Annotation> annotationClass) {
            this.annotationClass = Objects.requireNonNull(annotationClass, "annotationClass is null");
        }

        @Inject
        public void setInjector(Injector injector) {
            this.injector = injector;
        }

        public PrestoActionFactory get() {
            QueryActionsConfig queryActionsConfig = (QueryActionsConfig)this.injector.getInstance(QueryActionsConfig.class);
            return new JdbcPrestoActionFactory((SqlExceptionClassifier)this.injector.getInstance(SqlExceptionClassifier.class), (PrestoActionConfig)this.injector.getInstance(Key.get(PrestoActionConfig.class, this.annotationClass)), (RetryConfig)this.injector.getInstance(Key.get(RetryConfig.class, ForClusterConnection.class)), (RetryConfig)this.injector.getInstance(Key.get(RetryConfig.class, ForPresto.class)), queryActionsConfig.getMetadataTimeout(), queryActionsConfig.getChecksumTimeout(), (VerifierConfig)this.injector.getInstance(VerifierConfig.class));
        }
    }
}

