/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.verifier.prestoaction;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import java.net.URI;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;

public interface PrestoAddress {
    public List<String> getHosts();

    public int getJdbcPort();

    public Optional<Integer> getHttpPort();

    public Map<String, String> getJdbcUrlParameters();

    default public List<String> getJdbcUrls() {
        String query = this.getJdbcUrlParameters().entrySet().stream().map(entry -> String.format("%s=%s", entry.getKey(), entry.getValue())).collect(Collectors.joining("&"));
        return (List)this.getHosts().stream().map(host -> String.format("jdbc:presto://%s:%s?%s", host, this.getJdbcPort(), query)).collect(ImmutableList.toImmutableList());
    }

    default public List<URI> getHttpUris(String path) {
        Preconditions.checkState((boolean)this.getHttpPort().isPresent(), (Object)"httpPort is not present");
        return (List)this.getHosts().stream().map(host -> URI.create(String.format("http://%s:%s", host, this.getHttpPort().get())).resolve(path)).collect(ImmutableList.toImmutableList());
    }
}

