/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.verifier.resolver;

import com.facebook.presto.common.CatalogSchemaName;
import com.facebook.presto.metadata.BuiltInTypeAndFunctionNamespaceManager;
import com.facebook.presto.sql.tree.AstVisitor;
import com.facebook.presto.sql.tree.FunctionCall;
import com.facebook.presto.sql.tree.Node;
import com.facebook.presto.sql.tree.QualifiedName;
import com.facebook.presto.verifier.framework.DataMatchResult;
import com.facebook.presto.verifier.framework.QueryBundle;
import com.facebook.presto.verifier.resolver.FailureResolver;
import com.facebook.presto.verifier.resolver.IgnoredFunctionsMismatchResolverConfig;
import com.google.common.base.Preconditions;
import com.google.common.base.Splitter;
import com.google.common.collect.ImmutableList;
import java.util.HashSet;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import javax.inject.Inject;

public class IgnoredFunctionsMismatchResolver
implements FailureResolver {
    public static final String NAME = "ignored-functions";
    private final List<String> ignoredFunctions;

    @Inject
    public IgnoredFunctionsMismatchResolver(IgnoredFunctionsMismatchResolverConfig config) {
        this.ignoredFunctions = (List)config.getFunctions().stream().map(IgnoredFunctionsMismatchResolver::normalizeFunctionName).collect(ImmutableList.toImmutableList());
    }

    @Override
    public Optional<String> resolveResultMismatch(DataMatchResult matchResult, QueryBundle control) {
        Preconditions.checkArgument((!matchResult.isMatched() ? 1 : 0) != 0, (Object)"Expect not matched");
        if (matchResult.getMatchType() != DataMatchResult.MatchType.COLUMN_MISMATCH && matchResult.getMatchType() != DataMatchResult.MatchType.ROW_COUNT_MISMATCH) {
            return Optional.empty();
        }
        HashSet ignoredFunctionsInQuery = new HashSet();
        new Visitor().process((Node)control.getQuery(), ignoredFunctionsInQuery);
        return ignoredFunctionsInQuery.isEmpty() ? Optional.empty() : Optional.of("Query references ignored function: " + ignoredFunctionsInQuery);
    }

    private static String normalizeFunctionName(String name) {
        return IgnoredFunctionsMismatchResolver.normalizeFunctionName(QualifiedName.of((Iterable)Splitter.on((String)".").splitToList((CharSequence)name)));
    }

    private static String normalizeFunctionName(QualifiedName name) {
        if (name.getParts().size() == 3 && new CatalogSchemaName((String)name.getParts().get(0), (String)name.getParts().get(1)).equals((Object)BuiltInTypeAndFunctionNamespaceManager.DEFAULT_NAMESPACE)) {
            return name.getSuffix();
        }
        return name.toString();
    }

    private class Visitor
    extends AstVisitor<Void, Set<String>> {
        private Visitor() {
        }

        protected Void visitNode(Node node, Set<String> context) {
            node.getChildren().forEach(child -> {
                Void cfr_ignored_0 = (Void)this.process((Node)child, context);
            });
            return null;
        }

        protected Void visitFunctionCall(FunctionCall node, Set<String> ignoredFunctionsInQuery) {
            super.visitFunctionCall(node, ignoredFunctionsInQuery);
            String functionName = IgnoredFunctionsMismatchResolver.normalizeFunctionName(node.getName());
            if (IgnoredFunctionsMismatchResolver.this.ignoredFunctions.contains(functionName)) {
                ignoredFunctionsInQuery.add(functionName);
            }
            return null;
        }
    }
}

