/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.verifier.resolver;

import com.facebook.airlift.configuration.AbstractConfigurationAwareModule;
import com.facebook.airlift.configuration.ConfigBinder;
import com.facebook.presto.verifier.resolver.ChecksumExceededTimeLimitFailureResolver;
import com.facebook.presto.verifier.resolver.ClusterSizeFetcherModule;
import com.facebook.presto.verifier.resolver.ExceededGlobalMemoryLimitFailureResolver;
import com.facebook.presto.verifier.resolver.ExceededTimeLimitFailureResolver;
import com.facebook.presto.verifier.resolver.FailureResolver;
import com.facebook.presto.verifier.resolver.FailureResolverConfig;
import com.facebook.presto.verifier.resolver.FailureResolverFactory;
import com.facebook.presto.verifier.resolver.FailureResolverManagerFactory;
import com.facebook.presto.verifier.resolver.IgnoredFunctionsMismatchResolver;
import com.facebook.presto.verifier.resolver.IgnoredFunctionsMismatchResolverConfig;
import com.facebook.presto.verifier.resolver.StructuredColumnMismatchResolver;
import com.facebook.presto.verifier.resolver.TooManyOpenPartitionsFailureResolver;
import com.facebook.presto.verifier.resolver.TooManyOpenPartitionsFailureResolverConfig;
import com.facebook.presto.verifier.resolver.VerifierLimitationFailureResolver;
import com.google.common.collect.ImmutableList;
import com.google.inject.Binder;
import com.google.inject.Module;
import com.google.inject.Scopes;
import com.google.inject.multibindings.Multibinder;
import com.google.inject.name.Names;
import java.lang.annotation.Annotation;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.Optional;

public class FailureResolverModule
extends AbstractConfigurationAwareModule {
    public static final FailureResolverModule BUILT_IN = FailureResolverModule.builder().bind("exceeded-global-memory-limit", ExceededGlobalMemoryLimitFailureResolver.class, Optional.empty()).bind("exceeded-time-limit", ExceededTimeLimitFailureResolver.class, Optional.empty()).bind("checksum-exceeded-time-limit", ChecksumExceededTimeLimitFailureResolver.class, Optional.empty()).bind("verifier-limitation", VerifierLimitationFailureResolver.class, Optional.empty()).bindFactory("too-many-open-partitions", TooManyOpenPartitionsFailureResolver.Factory.class, Optional.of(TooManyOpenPartitionsFailureResolverConfig.class), (List<Module>)ImmutableList.of((Object)new ClusterSizeFetcherModule())).bind("structured-column", StructuredColumnMismatchResolver.class, Optional.empty()).bind("ignored-functions", IgnoredFunctionsMismatchResolver.class, Optional.of(IgnoredFunctionsMismatchResolverConfig.class)).build();
    private final List<FailureResolverBinding> resolvers;
    private final List<FailureResolverFactoryBinding> factories;

    private FailureResolverModule(List<FailureResolverBinding> resolvers, List<FailureResolverFactoryBinding> factories) {
        this.resolvers = ImmutableList.copyOf(resolvers);
        this.factories = ImmutableList.copyOf(factories);
    }

    protected void setup(Binder binder) {
        ConfigBinder.configBinder((Binder)binder).bindConfig(FailureResolverConfig.class);
        binder.bind(FailureResolverManagerFactory.class).in(Scopes.SINGLETON);
        Multibinder.newSetBinder((Binder)binder, FailureResolver.class);
        Multibinder.newSetBinder((Binder)binder, FailureResolverFactory.class);
        if (!((FailureResolverConfig)this.buildConfigObject(FailureResolverConfig.class)).isEnabled()) {
            return;
        }
        for (FailureResolverBinding failureResolverBinding : this.resolvers) {
            this.bind(binder, failureResolverBinding.getName(), Optional.of(failureResolverBinding.getResolverClass()), Optional.empty(), failureResolverBinding.getConfigClass(), failureResolverBinding.getAdditionalModules());
        }
        for (FailureResolverFactoryBinding failureResolverFactoryBinding : this.factories) {
            this.bind(binder, failureResolverFactoryBinding.getName(), Optional.empty(), Optional.of(failureResolverFactoryBinding.getFactoryClass()), failureResolverFactoryBinding.getConfigClass(), failureResolverFactoryBinding.getAdditionalModules());
        }
    }

    private void bind(Binder binder, String name, Optional<Class<? extends FailureResolver>> failureResolverClass, Optional<Class<? extends FailureResolverFactory>> failureResolverFactoryClass, Optional<Class<?>> failureResolverConfigClass, List<Module> additionalModules) {
        ConfigBinder.configBinder((Binder)binder).bindConfig(FailureResolverConfig.class, (Annotation)Names.named((String)name), name);
        if (((FailureResolverConfig)this.buildConfigObject(FailureResolverConfig.class, name)).isEnabled()) {
            failureResolverClass.ifPresent(clazz -> Multibinder.newSetBinder((Binder)binder, FailureResolver.class).addBinding().to(clazz).in(Scopes.SINGLETON));
            failureResolverFactoryClass.ifPresent(clazz -> Multibinder.newSetBinder((Binder)binder, FailureResolverFactory.class).addBinding().to(clazz).in(Scopes.SINGLETON));
            failureResolverConfigClass.ifPresent(clazz -> ConfigBinder.configBinder((Binder)binder).bindConfig(clazz, name));
            additionalModules.forEach(arg_0 -> ((FailureResolverModule)this).install(arg_0));
        }
    }

    public static Builder builder() {
        return new Builder();
    }

    private static abstract class AbstractFailureResolverBinding {
        private final String name;
        private final Optional<Class<?>> configClass;
        private final List<Module> additionalModules;

        public AbstractFailureResolverBinding(String name, Optional<Class<?>> configClass, List<Module> additionalModules) {
            this.name = Objects.requireNonNull(name, "name is null");
            this.configClass = Objects.requireNonNull(configClass, "configClass is null");
            this.additionalModules = ImmutableList.copyOf(additionalModules);
        }

        public String getName() {
            return this.name;
        }

        public Optional<Class<?>> getConfigClass() {
            return this.configClass;
        }

        public List<Module> getAdditionalModules() {
            return this.additionalModules;
        }
    }

    private static class FailureResolverFactoryBinding
    extends AbstractFailureResolverBinding {
        private final Class<? extends FailureResolverFactory> factoryClass;

        public FailureResolverFactoryBinding(String name, Class<? extends FailureResolverFactory> factoryClass, Optional<Class<?>> configClass, List<Module> additionalModules) {
            super(name, configClass, additionalModules);
            this.factoryClass = factoryClass;
        }

        public Class<? extends FailureResolverFactory> getFactoryClass() {
            return this.factoryClass;
        }
    }

    private static class FailureResolverBinding
    extends AbstractFailureResolverBinding {
        private final Class<? extends FailureResolver> resolverClass;

        public FailureResolverBinding(String name, Class<? extends FailureResolver> resolverClass, Optional<Class<?>> configClass) {
            super(name, configClass, (List<Module>)ImmutableList.of());
            this.resolverClass = resolverClass;
        }

        public Class<? extends FailureResolver> getResolverClass() {
            return this.resolverClass;
        }
    }

    public static class Builder {
        private final List<FailureResolverBinding> resolvers = new ArrayList<FailureResolverBinding>();
        private final List<FailureResolverFactoryBinding> factories = new ArrayList<FailureResolverFactoryBinding>();

        public Builder bind(String name, Class<? extends FailureResolver> failureResolverClass, Optional<Class<?>> configClass) {
            this.resolvers.add(new FailureResolverBinding(name, failureResolverClass, configClass));
            return this;
        }

        public Builder bindFactory(String name, Class<? extends FailureResolverFactory> failureResolverFactoryClass, Optional<Class<?>> configClass, List<Module> additionalModules) {
            this.factories.add(new FailureResolverFactoryBinding(name, failureResolverFactoryClass, configClass, additionalModules));
            return this;
        }

        public FailureResolverModule build() {
            return new FailureResolverModule(this.resolvers, this.factories);
        }
    }
}

