/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.verifier.prestoaction;

import com.facebook.airlift.json.JsonCodec;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.Objects;
import java.util.Optional;

public class ClientInfo {
    private static final String CLIENT_INFO_TYPE = "VERIFIER";
    private static final JsonCodec<ClientInfo> CLIENT_INFO_JSON_CODEC = JsonCodec.jsonCodec(ClientInfo.class);
    private final String testId;
    private final Optional<String> testName;
    private final String sourceQueryName;
    private final String suite;

    public ClientInfo(String testId, Optional<String> testName, String sourceQueryName, String suite) {
        this.testId = Objects.requireNonNull(testId, "testId is null");
        this.testName = Objects.requireNonNull(testName, "testName is null");
        this.sourceQueryName = Objects.requireNonNull(sourceQueryName, "sourceQueryName is null");
        this.suite = Objects.requireNonNull(suite, "suite is null");
    }

    @JsonProperty
    public String getType() {
        return CLIENT_INFO_TYPE;
    }

    @JsonProperty
    public String getTestId() {
        return this.testId;
    }

    @JsonProperty
    public Optional<String> getTestName() {
        return this.testName;
    }

    @JsonProperty
    public String getSourceQueryName() {
        return this.sourceQueryName;
    }

    @JsonProperty
    public String getSuite() {
        return this.suite;
    }

    public String serialize() {
        return CLIENT_INFO_JSON_CODEC.toJson((Object)this).replaceAll("\\n", "");
    }
}

