/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.verifier.framework;

import com.facebook.presto.common.type.Type;
import com.facebook.presto.common.type.TypeManager;
import com.facebook.presto.common.type.TypeSignature;
import com.facebook.presto.sql.parser.ParsingOptions;
import com.facebook.presto.sql.tree.Identifier;
import com.facebook.presto.verifier.framework.PrestoQueryException;
import com.facebook.presto.verifier.framework.QueryException;
import com.facebook.presto.verifier.framework.QueryResult;
import com.facebook.presto.verifier.prestoaction.QueryActionStats;
import com.google.common.base.Functions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.util.List;
import java.util.Map;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.IntStream;

public class VerifierUtil {
    public static final ParsingOptions PARSING_OPTIONS = ParsingOptions.builder().setDecimalLiteralTreatment(ParsingOptions.DecimalLiteralTreatment.AS_DOUBLE).build();

    private VerifierUtil() {
    }

    public static Identifier delimitedIdentifier(String name) {
        return new Identifier(name, true);
    }

    public static void runAndConsume(Callable<QueryActionStats> callable, Consumer<QueryActionStats> queryStatsConsumer) {
        VerifierUtil.runAndConsume(callable, queryStatsConsumer, e -> {});
    }

    public static void runAndConsume(Callable<QueryActionStats> callable, Consumer<QueryActionStats> queryStatsConsumer, Consumer<QueryException> queryExceptionConsumer) {
        VerifierUtil.callAndConsume(callable, Functions.identity(), queryStatsConsumer, queryExceptionConsumer);
    }

    public static <V> QueryResult<V> callAndConsume(Callable<QueryResult<V>> callable, Consumer<QueryActionStats> queryStatsConsumer) {
        return VerifierUtil.callAndConsume(callable, queryStatsConsumer, e -> {});
    }

    public static <V> QueryResult<V> callAndConsume(Callable<QueryResult<V>> callable, Consumer<QueryActionStats> queryStatsConsumer, Consumer<QueryException> queryExceptionConsumer) {
        return VerifierUtil.callAndConsume(callable, QueryResult::getQueryActionStats, queryStatsConsumer, queryExceptionConsumer);
    }

    private static <V> V callAndConsume(Callable<V> callable, Function<V, QueryActionStats> queryStatsTransformer, Consumer<QueryActionStats> queryStatsConsumer, Consumer<QueryException> queryExceptionConsumer) {
        try {
            V result = callable.call();
            queryStatsConsumer.accept(queryStatsTransformer.apply(result));
            return result;
        }
        catch (PrestoQueryException e) {
            queryStatsConsumer.accept(e.getQueryActionStats());
            queryExceptionConsumer.accept(e);
            throw e;
        }
    }

    public static List<String> getColumnNames(ResultSetMetaData metadata) {
        return (List)VerifierUtil.callUnchecked(() -> (ImmutableList)IntStream.rangeClosed(1, metadata.getColumnCount()).mapToObj(i -> VerifierUtil.callUnchecked(() -> metadata.getColumnName(i))).collect(ImmutableList.toImmutableList()));
    }

    public static Map<String, Integer> getColumnIndices(ResultSetMetaData metadata) {
        return (Map)VerifierUtil.callUnchecked(() -> (ImmutableMap)IntStream.rangeClosed(1, metadata.getColumnCount()).boxed().collect(ImmutableMap.toImmutableMap(i -> VerifierUtil.callUnchecked(() -> metadata.getColumnName((int)i)), i -> i - 1)));
    }

    public static List<Type> getColumnTypes(TypeManager typeManager, ResultSetMetaData metadata) {
        return (List)VerifierUtil.callUnchecked(() -> (ImmutableList)IntStream.rangeClosed(1, metadata.getColumnCount()).mapToObj(i -> VerifierUtil.callUnchecked(() -> metadata.getColumnTypeName(i))).map(TypeSignature::parseTypeSignature).map(arg_0 -> ((TypeManager)typeManager).getType(arg_0)).collect(ImmutableList.toImmutableList()));
    }

    private static <V> V callUnchecked(SqlExceptionCallable<V> callable) {
        try {
            return callable.call();
        }
        catch (SQLException e) {
            throw new RuntimeException(e);
        }
    }

    public static interface SqlExceptionCallable<V> {
        public V call() throws SQLException;
    }

    public static interface Callable<V> {
        public V call();
    }
}

